CREATE TABLE ${db.unico.schema}.RECURSO (
	ID NUMERIC(10,0) NOT NULL,
	NOME VARCHAR(50) NOT NULL,
	DESCRICAO VARCHAR(50) NOT NULL,
	CONSTRAINT PKRECURSO PRIMARY KEY (ID)
);

CREATE TABLE ${db.unico.schema}.GRUPO (
	ID NUMERIC(10,0) NOT NULL,
	NOME VARCHAR(50) NOT NULL,
	CONSTRAINT PKGRUPO PRIMARY KEY (ID)
);

CREATE TABLE ${db.unico.schema}.GRUPORECURSO (
	GRUPO NUMERIC(10,0) NOT NULL,
	RECURSO NUMERIC(10,0) NOT NULL,
	CONSTRAINT PKGRUPORECURSO PRIMARY KEY (GRUPO, RECURSO),
	CONSTRAINT FKGRUPORECURSOGP FOREIGN KEY(GRUPO) REFERENCES ${db.unico.schema}.GRUPO(ID),
	CONSTRAINT FKGRUPORECURSORC FOREIGN KEY(RECURSO) REFERENCES ${db.unico.schema}.RECURSO(ID)
);

CREATE TABLE ${db.unico.schema}.USUARIO(
	ID          NUMERIC(10,0) NOT NULL,
	USUARIO 	VARCHAR(15) NOT NULL,
	SENHA 		VARCHAR(60),
	ATIVO 		CHAR(1) DEFAULT 'S' NOT NULL,
	EMAIL     	VARCHAR(100),
	PESSOA      NUMERIC(10,0),
    DATAEXPIRACAO   DATE, /* Data em que a senha do usuario expira e precisa ser modificada */
    USUARIORESPONSAVEL NUMERIC(10,0),
    CONTABLOQUEADA VARCHAR(1)  DEFAULT 'N',
    SENHAEXPIRADA VARCHAR(1)  DEFAULT 'N',
    MODOAUTENTICACAO CHAR(1) DEFAULT 'I', 
    SOURCECLASS VARCHAR(50),
    HASHSTRING VARCHAR(200),    
	CONSTRAINT PKUSUARIO PRIMARY KEY (ID),
    CONSTRAINT FKPESSOA_USUARIO FOREIGN KEY (PESSOA) REFERENCES ${db.unico.schema}.PESSOA (ID),
    CONSTRAINT FKUSUARIO_USURESPONSAVEL FOREIGN KEY (USUARIORESPONSAVEL) REFERENCES ${db.unico.schema}.USUARIO (ID),
    CONSTRAINT FKUSUARIO_MODOAUTENTICACAO FOREIGN KEY (MODOAUTENTICACAO) REFERENCES ${db.unico.schema}.USUARIOMODOAUTENTICACAO(ID)
);

CREATE TABLE ${db.unico.schema}.USUARIOENTIDADE (
  				   ID NUMERIC(10,0) NOT NULL,	
				   USUARIO NUMERIC(10,0) NOT NULL,
                   ENTIDADE NUMERIC(10,0) NOT NULL,
                   PRINCIPAL VARCHAR(1),
  				   CONSTRAINT PKUSUARIOENTIDADE PRIMARY KEY(ID), 
                   CONSTRAINT FKUSUARIOENT_USUARIO FOREIGN KEY (USUARIO) REFERENCES ${db.unico.schema}.USUARIO(ID),
                   CONSTRAINT FKUSUARIOENT_ENTIDADE  FOREIGN KEY  (ENTIDADE)  REFERENCES ${db.unico.schema}.ENTIDADE (ID)

);

CREATE TABLE ${db.unico.schema}.USUARIOMODULO (
  				   ID NUMERIC(10,0) NOT NULL,	
				   USUARIO NUMERIC(10,0) NOT NULL, 
                   MODULO NUMERIC(10,0) NOT NULL,	
                   PRINCIPAL VARCHAR(1),   
  				   CONSTRAINT PKUSUARIOMODULO PRIMARY KEY(ID), 
                   CONSTRAINT FKUSUARIOMOD_USUARIO FOREIGN KEY (USUARIO) REFERENCES ${db.unico.schema}.USUARIO(ID),
                   CONSTRAINT FKUSUARIOMOD_MODULO FOREIGN KEY (MODULO) REFERENCES ${db.unico.schema}.MODULO(MODULO)
);

CREATE TABLE ${db.unico.schema}.USUARIORECURSO (
	USUARIO NUMERIC(10,0) NOT NULL,
	RECURSO NUMERIC(10,0) NOT NULL,
	CONSTRAINT PKUSUARIORECURSO PRIMARY KEY (USUARIO, RECURSO),
	CONSTRAINT FKUSUARIORECURSOUSU FOREIGN KEY(USUARIO) REFERENCES ${db.unico.schema}.USUARIO(ID),
	CONSTRAINT FKUSUARIORECURSORC FOREIGN KEY(RECURSO) REFERENCES ${db.unico.schema}.RECURSO(ID)
);

CREATE TABLE ${db.unico.schema}.USUARIOGRUPO (
	USUARIO NUMERIC(10,0) NOT NULL,
	GRUPO NUMERIC(10,0) NOT NULL,
	CONSTRAINT PKUSUARIOGRUPO PRIMARY KEY (USUARIO,GRUPO),
	CONSTRAINT FKUSUARIOGRUPOGP FOREIGN KEY(GRUPO) REFERENCES ${db.unico.schema}.GRUPO(ID),
	CONSTRAINT FKUSUARIOGRUPOUS FOREIGN KEY(USUARIO) REFERENCES ${db.unico.schema}.USUARIO(ID)
);

INSERT INTO ${db.unico.schema}.RECURSO(ID, NOME, DESCRICAO) VALUES (1, 'ROLE_FrmUnicoUsuario', 'Cadastro Usuário');
INSERT INTO ${db.unico.schema}.RECURSO(ID, NOME, DESCRICAO) VALUES (2, 'ROLE_FrmUnicoModulo', 'Cadastro Módulo');
INSERT INTO ${db.unico.schema}.RECURSO(ID, NOME, DESCRICAO) VALUES (3, 'ROLE_LOGAR', 'Logar');
INSERT INTO ${db.unico.schema}.RECURSO(ID, NOME, DESCRICAO) VALUES (4, 'ROLE_ADMIN', 'Administrar');

INSERT INTO ${db.unico.schema}.GRUPO(ID, NOME) VALUES (1, 'Usuários');
INSERT INTO ${db.unico.schema}.GRUPO(ID, NOME) VALUES (2, 'Administradores');

INSERT INTO ${db.unico.schema}.GRUPORECURSO(GRUPO, RECURSO) VALUES (1, 3);

INSERT INTO ${db.unico.schema}.GRUPORECURSO(GRUPO, RECURSO) VALUES (2, 1);
INSERT INTO ${db.unico.schema}.GRUPORECURSO(GRUPO, RECURSO) VALUES (2, 2);
INSERT INTO ${db.unico.schema}.GRUPORECURSO(GRUPO, RECURSO) VALUES (2, 4);


