CREATE TABLE ${db.unico.schema}.GRAUINSTRUCAO (ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(1000), 
  				   CONSTRAINT PKGRAUINSTRUCAO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.ENTIDADETIPO (ID CHAR(1) NOT NULL, 
  				   DESCRICAO VARCHAR(1000), 
  				   CONSTRAINT PKENTIDADETIPO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOASITUACAO (ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(1000), 
  				   CONSTRAINT PKPESSOASITUACAO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOATIPOEMPRESA (ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(1000), 
  				   CONSTRAINT PKPESSOATIPOEMPRESA PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPOCONTA (
                   ID CHAR(1) NOT NULL, 
  				   DESCRICAO VARCHAR(1000), 
  				   CONSTRAINT PKTIPOCONTA PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.ENDERECOTIPO (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(100), 
  				   CONSTRAINT PKENDERECOTIPO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOASEXO (
                   ID CHAR(1) NOT NULL, 
  				   DESCRICAO VARCHAR(50), 
  				   CONSTRAINT PKPESSOASEXO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOACORCABELO (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(50), 
  				   CONSTRAINT PKPESSOACORCABELO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOACOROLHO (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(50), 
  				   CONSTRAINT PKPESSOACOROLHO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOACORPELE (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(50), 
  				   CONSTRAINT PKPESSOACORPELE PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOANACIONALIDADE (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(500), 
  				   CONSTRAINT PKPESSOANACIONALIDADE PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOAESTADOCIVIL (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(500), 
  				   CONSTRAINT PKPESSOAESTADOCIVIL PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.CLASSIFICACAODOCUMENTO (
                   ID CHAR(1) NOT NULL,  
  				   DESCRICAO VARCHAR(500), 
  				   CONSTRAINT PKCLASSIFICACAODOCUMENTO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.CONTRIBUICAOPREVIDENCIARIA (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(1000), 
  				   CONSTRAINT PKCONTRIBUICAOPREVIDENCIARIA PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.DOCUMENTOAPRESENTADOPOR (
                   ID CHAR(1) NOT NULL,  
  				   DESCRICAO VARCHAR(500), 
  				   CONSTRAINT PKDOCUMENTOAPRESENTADOPOR PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.FUNDOPREVIDENCIASOCIAL (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(1000), 
  				   CONSTRAINT PKFUNDOPREVIDENCIASOCIAL PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.SOCIOFUNCAO (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(500), 
  				   CONSTRAINT PKSOCIOFUNCAO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.SOCIOTIPOREGISTRO (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(100), 
  				   CONSTRAINT PKSOCIOTIPOREGISTRO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPODOCUMENTO (
                   ID NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(100), 
  				   CONSTRAINT PKTIPODOCUMENTO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.USUARIOMODOAUTENTICACAO (ID CHAR(1) NOT NULL, 
  				   DESCRICAO VARCHAR(200), 
  				   CONSTRAINT PKUSUARIOMODOAUTENTICACAO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.MODULO (
                   MODULO NUMERIC(10,0) NOT NULL,
  				   DESCRICAO VARCHAR(30) NOT NULL, 
  				   PATH VARCHAR(100), 
  				   TIPOMODULO CHAR(1), 
  				   CONTROLAACESSORELATORIO CHAR(1), 
  				   SOURCECLASS VARCHAR(50),
   				   HASHSTRING VARCHAR(200),
  				   CONSTRAINT PKMODULO PRIMARY KEY (MODULO)
)
#
CREATE TABLE ${db.unico.schema}.PAIS (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(60) NOT NULL,
                   CODIGOBACEN VARCHAR(5),
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKPAIS PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.CNAE (
                   ID NUMERIC(10,0) NOT NULL,
                   CODIGO VARCHAR(250) NOT NULL,
                   DESCRICAO VARCHAR(250) NOT NULL,
                   ADMITEMOVIMENTO CHAR(1),
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKCNAE PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.UNIDADEFEDERACAO(ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(50),
                   SIGLA VARCHAR(2),
                   PAIS NUMERIC(10,0) NOT NULL,
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKUNIDADEFEDERACAO PRIMARY KEY (ID),
                   CONSTRAINT FKUF_PAIS FOREIGN KEY (PAIS) REFERENCES ${db.unico.schema}.PAIS(ID)
)
#
CREATE TABLE ${db.unico.schema}.CIDADE (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100) NOT NULL,
                   CODIGONACIONAL VARCHAR(20),
                   CODIGOIBGE NUMERIC(10,0),
                   UNIDADEFEDERACAO NUMERIC(10,0) NOT NULL,
                   CODIGOAPLIC NUMERIC(10,0),
                   INATIVO CHAR(1) DEFAULT 'N',
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKCIDADE PRIMARY KEY (ID),
                   CONSTRAINT FKCIDADE_UF FOREIGN KEY (UNIDADEFEDERACAO) REFERENCES ${db.unico.schema}.UNIDADEFEDERACAO(ID)
)
#
CREATE TABLE ${db.unico.schema}.BAIRRO (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100) NOT NULL,
                   CIDADE NUMERIC(10,0) NOT NULL,  
                   INATIVO CHAR(1) DEFAULT 'N',
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKBAIRRO PRIMARY KEY (ID),
                   CONSTRAINT FKBAIRROE_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.unico.schema}.CIDADE(ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPOLOGRADOURO (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100) NOT NULL,
                   SIGLA VARCHAR(3),  
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKTIPOLOGRADOURO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.LOGRADOURO (ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(100) NOT NULL,
                   TIPOLOGRADOURO NUMERIC(10,0),
                   CIDADE NUMERIC(10,0) NOT NULL,
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKLOGRADOURO PRIMARY KEY (ID),
                   CONSTRAINT FKLOGRADOURO_TPLOGRA FOREIGN KEY (TIPOLOGRADOURO) REFERENCES ${db.unico.schema}.TIPOLOGRADOURO(ID),
                   CONSTRAINT FKLOGRADOURO_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.unico.schema}.CIDADE(ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA (ID NUMERIC(10,0) NOT NULL,
                   NOME VARCHAR(150),
                   TIPOPESSOA VARCHAR(1),
                   CNPJ_CPF VARCHAR(20),
                   RG_NUMERO VARCHAR(20),
                   RG_DATAEMISSAO DATE,
                   RG_ORGAOEMISSOR VARCHAR(20),
                   RESTRICAOJUDICIAL VARCHAR(1),
                   RESPONSAVELLIQUIDACAO VARCHAR(1),
                   MICROEMPRESA VARCHAR(1),
                   RG_UF NUMERIC(10,0),
                   NOMEFANTASIA VARCHAR(150),
                   OBSERVACAO VARCHAR(1000),
                   OBSERVACAOJUDICIAL VARCHAR(1000),
                   IDTCEPR NUMERIC(10,0),
                   DATAALTERACAO TIMESTAMP,
                   DATACADASTRO DATE,
                   DATAINCLUSAO DATE,
                   INSCRICAOESTADUAL VARCHAR(20),
                   PIS VARCHAR(20),
                   INSCRICAOMUNICIPAL VARCHAR(20),
                   AUTONOMO   VARCHAR(1),
				   ESTRANGEIRO   VARCHAR(1),
				   
				   CONTRIBUINTE   VARCHAR(1),
				   FORNECEDOR   VARCHAR(1),
				   PESSOAL   VARCHAR(1),
				   PROTOCOLO   VARCHAR(1),

				   INATIVO   VARCHAR(1),
				   SITUACAO NUMERIC(10,0),
				   ESCOLARIDADE NUMERIC(10,0),
				   TIPOEMPRESA NUMERIC(10,0),
				   DATANASCIMENTO DATE,
				   OPTANTESIMPLES VARCHAR(1),
				   AUDESPGENERICA VARCHAR(20),
				   AUDESPESPECIAL VARCHAR(20),
				   INSCMUNDATARENOVACAO DATE,
				   INSCMUNDATAVIGENCIA DATE,
				   CAU VARCHAR(15),
				   CREA VARCHAR(15),
				   OAB VARCHAR(15),
				   DATAFIMSUSPENSAO DATE,
				   DATAINISUSPENSAO DATE,
				   CARGO VARCHAR(50),
                   MATRICULA VARCHAR(20),
                   DATAABERTURACNPJ DATE,
                   DATAISSQN DATE, 
                   NIRE VARCHAR(12),
                   NIT VARCHAR(12),
                   CODIGOSISTEMAANTERIOR VARCHAR(18),
                   SOURCECLASS VARCHAR(50),
                   CNAE NUMERIC(10,0),
                   HASHSTRING VARCHAR(200),
                   CIDADENASCIMENTO NUMERIC(10,0),
                   CIDADETITULO NUMERIC(10,0),
                   CTPS                VARCHAR(20),
                   SERIECTPS                  VARCHAR(20),
                   ESTADOCTPS                 CHAR(2),
                   DATAEXPEDICAOCTPS          DATE,
                   DATAPIS                    DATE,
                   INSCRICAOINSS              VARCHAR(20),
                   DATAINSS                   DATE,
                   CNH                        VARCHAR(20),
                   DATAVALIDADECNH            DATE,
                   CATEGORIACNH               VARCHAR(10),
                   DATAEXPEDICAOCNH           DATE,
                   PRONTUARIOCNH              VARCHAR(20),
                   OBSERVACAOCNH              VARCHAR(1000),
                   SEXO                       CHAR(1),
                   TIPOSANGUINEO              VARCHAR(10),
                   DEFICIENTE                 CHAR(1),
                   ALTURA                     NUMERIC(15,2),
                   PESO                       NUMERIC(15,2),
                   SINAIS                     VARCHAR(60),
                   COR                        NUMERIC(10),
                   CABELO                     NUMERIC(10),
                   OLHOS                      NUMERIC(10),
                   ESTADOCIVIL                NUMERIC(10),
                   NOMEPAI                    VARCHAR(60),
                   NOMEMAE                    VARCHAR(60),
                   NACIONALIDADE              NUMERIC(10),
                   DATACHEGADA                DATE,
                   CARTEIRAMODELO19           VARCHAR(20),
                   DATAOBITO                  DATE,
                   RESERVISTA                 VARCHAR(20),
                   CATEGORIARESERVISTA        VARCHAR(10),
                   REGIAORESERVISTA           VARCHAR(10),
                   TITULOELEITOR              VARCHAR(20),
                   SECAOELEITORAL             VARCHAR(10),
                   ZONAELEITORAL              VARCHAR(10),
                   REGISTROPROFISSIONAL       VARCHAR(20),
                   DATAREGISTROPROFISSIONAL   DATE,
                   ORGAOREGISTROPROFISSIONAL  VARCHAR(20),
                   ALVARAJUDICIAL             CHAR(1),
                   CERTIDAONASCIMENTO         VARCHAR(50),
                   CERTIDAOOBITO              VARCHAR(20),
                   LIVROCERTIDAONASCIMENTO    VARCHAR(20),
                   LIVROCERTIDAOOBITO         VARCHAR(20),
                   FOLHACERTIDAONASCIMENTO    VARCHAR(20),
                   FOLHACERTIDAOOBITO         VARCHAR(20),
                   CAUSAMORTE                 VARCHAR(500),
                   CONSTRAINT PKPESSOA PRIMARY KEY (ID),
                   CONSTRAINT FKPESSOA_UF FOREIGN KEY (RG_UF) REFERENCES ${db.unico.schema}.UNIDADEFEDERACAO(ID),
                   CONSTRAINT FKPESSOA_CNAEF FOREIGN KEY (CNAE) REFERENCES ${db.unico.schema}.CNAE(ID),
                   CONSTRAINT FKPESSOA_SITUACAO FOREIGN KEY (SITUACAO) REFERENCES ${db.unico.schema}.PESSOASITUACAO(ID),
				   CONSTRAINT FKPESSOA_TIPOEMPRESA FOREIGN KEY (TIPOEMPRESA) REFERENCES ${db.unico.schema}.PESSOATIPOEMPRESA(ID),	
                   CONSTRAINT FKPESSOA_CIDNASC FOREIGN KEY (CIDADENASCIMENTO) REFERENCES ${db.unico.schema}.CIDADE(ID),
                   CONSTRAINT FKPESSOA_CIDTITU FOREIGN KEY (CIDADETITULO) REFERENCES ${db.unico.schema}.CIDADE(ID),
                   CONSTRAINT FKPESSOA_CORCABELO FOREIGN KEY (CABELO) REFERENCES ${db.unico.schema}.PESSOACORCABELO(ID),
				   CONSTRAINT FKPESSOA_COROLHO FOREIGN KEY (OLHOS) REFERENCES ${db.unico.schema}.PESSOACOROLHO(ID),
				   CONSTRAINT FKPESSOA_CORPELE FOREIGN KEY (COR) REFERENCES ${db.unico.schema}.PESSOACORPELE(ID),
				   CONSTRAINT FKPESSOA_NACIONALIDADE FOREIGN KEY (NACIONALIDADE) REFERENCES ${db.unico.schema}.PESSOANACIONALIDADE(ID),
				   CONSTRAINT FKPESSOA_ESTADOCIVIL FOREIGN KEY (ESTADOCIVIL) REFERENCES ${db.unico.schema}.PESSOAESTADOCIVIL(ID)
)
#
CREATE TABLE ${db.unico.schema}.ENDERECOPESSOA (ID NUMERIC(10,0) NOT NULL,
                   PESSOA NUMERIC(10,0) NOT NULL,
                   CEP NUMERIC(10,0),  
                   CIDADE NUMERIC(10,0),  
                   LOGRADOURO NUMERIC(10,0),  
                   BAIRRO NUMERIC(10,0),  
                   NUMERO VARCHAR(10),
                   COMPLEMENTO VARCHAR(100),
                   TIPO NUMERIC(10,0),
                   PRINCIPAL VARCHAR(1),
                   CONSTRAINT PKENDERECOPESSOA PRIMARY KEY (ID),
                   CONSTRAINT FKENDPESSOA_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.unico.schema}.PESSOA(ID),
                   CONSTRAINT FKENDPESSOA_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.unico.schema}.CIDADE(ID),
                   CONSTRAINT FKENDPESSOA_LOGRADOURO FOREIGN KEY (LOGRADOURO) REFERENCES ${db.unico.schema}.LOGRADOURO(ID),
                   CONSTRAINT FKENDPESSOA_BAIRRO FOREIGN KEY (BAIRRO) REFERENCES ${db.unico.schema}.BAIRRO(ID),
                   CONSTRAINT FKENDPESSOA_TIPO FOREIGN KEY (TIPO) REFERENCES ${db.unico.schema}.ENDERECOTIPO(ID)
)
#
CREATE TABLE ${db.unico.schema}.BANCO (ID NUMERIC(10,0) NOT NULL,
				   CODIGO NUMERIC(10,0) NOT NULL,
  				   DESCRICAO VARCHAR(100) NOT NULL, 
  				   SOURCECLASS VARCHAR(50),
  				   HASHSTRING VARCHAR(200),
  				   CONSTRAINT PKBANCO PRIMARY KEY(ID)
)
#
CREATE TABLE ${db.unico.schema}.AGENCIA (
  				   ID NUMERIC(10,0) NOT NULL,
  				   CODIGO VARCHAR(10) NOT NULL,
  				   BANCO NUMERIC(10,0) NOT NULL, 
  				   DESCRICAO VARCHAR(50), 
  				   CIDADE NUMERIC(10,0), 
  				   SOURCECLASS VARCHAR(50),
  				   HASHSTRING VARCHAR(200),
   				   CONSTRAINT PKAGENCIA PRIMARY KEY(ID), 
  				   CONSTRAINT FKAGENCIA_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.unico.schema}.CIDADE(ID),
  				   CONSTRAINT FKAGENCIA_BANCO FOREIGN KEY (BANCO) REFERENCES ${db.unico.schema}.BANCO(ID)
)
#
CREATE TABLE ${db.unico.schema}.BANCOPESSOA (
  				   ID NUMERIC(10,0) NOT NULL,	
				   PESSOA NUMERIC(10,0) NOT NULL, 
				   CODIGOTCE NUMERIC(10,0),
  				   BANCO NUMERIC(10,0), 
  				   AGENCIA NUMERIC(10,0), 
  				   CONTA VARCHAR(20), 
  				   TIPOCONTA CHAR(1), 
			       ORDEMBANCARIA VARCHAR(20),
			       DATAABERTURA DATE, 
  				   OPERACAO VARCHAR(10), 
  				   DATAENCERRAMENTO DATE, 
                   PRINCIPAL VARCHAR(1),  
  				   CONSTRAINT PKBANCOPESSOA PRIMARY KEY(ID), 
                   CONSTRAINT FKBANCOPESSOA_AGENCIA FOREIGN KEY (AGENCIA) REFERENCES ${db.unico.schema}.AGENCIA(ID), 
  				   CONSTRAINT FKBANCOPESSOA_BANCO FOREIGN KEY (BANCO) REFERENCES ${db.unico.schema}.BANCO(ID), 
  				   CONSTRAINT FKBANCOPESSOA_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.unico.schema}.PESSOA(ID),
				   CONSTRAINT FKBANCOPESSOA_TIPOCONTA FOREIGN KEY (TIPOCONTA) REFERENCES ${db.unico.schema}.TIPOCONTA(ID)	  				   
)
#
CREATE TABLE ${db.unico.schema}.CONTATOPESSOA (
  				   ID NUMERIC(10,0) NOT NULL, 
  				   PESSOA NUMERIC(10,0) NOT NULL, 
  				   NOME VARCHAR(60), 
  				   TELEFONERESIDENCIAL VARCHAR(20), 
  				   TELEFONECOMERCIAL VARCHAR(20), 
  				   TELEFONEFAX VARCHAR(20), 
  				   TELEFONECELULAR VARCHAR(20), 
  				   EMAIL VARCHAR(100), 
  				   HOMEPAGE VARCHAR(100), 
  				   CPF VARCHAR(11), 
  				   REPRESENTANTELEGAL VARCHAR(1) NOT NULL, 
  				   REPRESENTANTE NUMERIC(10,0), 
  			       RG VARCHAR(20), 
  				   ORGAOEMISSOR VARCHAR(20), 
  				   DATAJUNTACOMERCIAL DATE, 
  				   BRASILEIRO VARCHAR(1), 
  				   PRINCIPAL VARCHAR(1),
  				   CONSTRAINT PKCONTATOPESSOA PRIMARY KEY(ID), 
  				   CONSTRAINT FKCONTATOPESSOA_PESSOA FOREIGN KEY (PESSOA) REFERENCES ${db.unico.schema}.PESSOA(ID) 
)
#
CREATE TABLE ${db.unico.schema}.DOCUMENTO (
  ID NUMERIC(10,0) NOT NULL,
  TIPODOCUMENTO NUMERIC(10,0) NOT NULL,
  DESCRICAO VARCHAR(4000) NOT NULL,
  CODIGOTCE NUMERIC(10,0),
  POSSUIVALIDADE CHAR(1),
  OBRIGATORIOCERTIDAO CHAR(1),
  APRESENTADOPOR CHAR(1),
  CLASSIFICACAO CHAR(1),
  SOURCECLASS VARCHAR(50),
  HASHSTRING VARCHAR(200),
  ATIVO VARCHAR(1),
  CONSTRAINT PKDOCUMENTO PRIMARY KEY(ID),
  CONSTRAINT FKCLASSIFICACAODOCUMENTO FOREIGN KEY (CLASSIFICACAO)
    REFERENCES ${db.unico.schema}.CLASSIFICACAODOCUMENTO(ID),
  CONSTRAINT FKAPRESENTADOPOR FOREIGN KEY (APRESENTADOPOR)
    REFERENCES ${db.unico.schema}.DOCUMENTOAPRESENTADOPOR(ID),
  CONSTRAINT FKTIPODOCUMENTO FOREIGN KEY (TIPODOCUMENTO)
    REFERENCES ${db.unico.schema}.TIPODOCUMENTO(ID)    
    
)
#
CREATE TABLE ${db.unico.schema}.DOCUMENTOPESSOA (
  ID NUMERIC(10,0) NOT NULL, 
  PESSOA NUMERIC(10,0) NOT NULL, 
  DOCUMENTO NUMERIC(10,0),
  NUMERODOCUMENTO VARCHAR(50),
  DATAEMISSAO DATE NOT NULL, 
  DATAALTERACAO DATE,
  DATAVALIDADE DATE,
  IDARQUIVO NUMERIC(10,0),
  CONSTRAINT PKDOCUMENTOPESSOA PRIMARY KEY(ID),
  CONSTRAINT FKDOCUMENTO_DOCUMENTO FOREIGN KEY (DOCUMENTO)
    REFERENCES ${db.unico.schema}.DOCUMENTO(ID),
  CONSTRAINT FKDOCUMENTOPESSOA_PESSOA FOREIGN KEY (PESSOA)
    REFERENCES ${db.unico.schema}.PESSOA(ID)
)
#
CREATE TABLE ${db.unico.schema}.SOCIOPESSOA (
  ID NUMERIC(10,0) NOT NULL,
  PESSOA NUMERIC(10,0) NOT NULL, 
  SOCIO NUMERIC(10,0) NOT NULL, 
  FUNCAO NUMERIC(10,0), 
  TIPOREGISTRO NUMERIC(10,0), 
  DATAREGISTRO DATE, 
  NUMEROREGISTRO VARCHAR(30), 
  CONSTRAINT PKSOCIOPESSOA PRIMARY KEY(ID),
  CONSTRAINT FKSOCIOPESSO_PESSOA FOREIGN KEY (PESSOA)
    REFERENCES ${db.unico.schema}.PESSOA(ID),
  CONSTRAINT FKSOCIOPESSO_SOCIO FOREIGN KEY (SOCIO)
    REFERENCES ${db.unico.schema}.PESSOA(ID),
  CONSTRAINT FKSOCIO_FUNCAO FOREIGN KEY (FUNCAO)
    REFERENCES ${db.unico.schema}.SOCIOFUNCAO(ID),
  CONSTRAINT FKSOCIO_TIPOREGISTRO FOREIGN KEY (TIPOREGISTRO)
    REFERENCES ${db.unico.schema}.SOCIOTIPOREGISTRO(ID)
)
#
CREATE TABLE ${db.unico.schema}.RAMOATIVIDADE (
                   ID NUMERIC(10,0) NOT NULL,
                   DESCRICAO VARCHAR(500) NOT NULL,
                   SOURCECLASS VARCHAR(50),
                   HASHSTRING VARCHAR(200),
                   CONSTRAINT PKRAMOATIVIDADE PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOA_RAMOATIVIDADE
(
  PESSOA NUMERIC(10,0) NOT NULL,
  RAMOATIVIDADE NUMERIC(10,0) NOT NULL,
  CONSTRAINT PKUPESSOARAMOAT PRIMARY KEY (PESSOA, RAMOATIVIDADE),
  CONSTRAINT FKUPESSOARAMOATIVIDADE_PESSOA FOREIGN KEY (PESSOA)   REFERENCES ${db.unico.schema}.PESSOA (ID),
  CONSTRAINT FKUPESSOARAMOATIVIDADE_RAMO FOREIGN KEY (RAMOATIVIDADE)   REFERENCES ${db.unico.schema}.RAMOATIVIDADE (ID)
)
#
CREATE TABLE ${db.unico.schema}.PESSOAALTERARAZAO
(
  ID NUMERIC(10,0) NOT NULL,
  PESSOA NUMERIC(10,0) NOT NULL,
  NOMEANTIGO VARCHAR(80),
  NOMENOVO VARCHAR(80),
  MOTIVACAO VARCHAR(250),
  INICIOVIGENCIA DATE,
  CONSTRAINT PKUPESSOAALTERARAZAO PRIMARY KEY (ID),
  CONSTRAINT FKUPESSOAALTERARAZAO FOREIGN KEY (PESSOA)
      REFERENCES ${db.unico.schema}.PESSOA (ID)
)
#
CREATE TABLE ${db.unico.schema}.ENTIDADE
(
  ID                   NUMERIC(10) NOT NULL,
  NOME                 VARCHAR(100),
  CNPJ                 VARCHAR(20),
  CIDADE               NUMERIC(10),
  BAIRRO               NUMERIC(10),
  LOGRADOURO           NUMERIC(10),
  NUMERO               VARCHAR(10),
  COMPLEMENTO          VARCHAR(60),
  CEP                  VARCHAR(10),
  ENTIDADEPRINCIPAL    CHAR(1),
  TIPOENTIDADE         CHAR(1),
  BRASAO               ${blob.type},
  TELEFONE             VARCHAR(20),
  IDENTIFICACAOTCE     VARCHAR(10),
  CNAE                 NUMERIC(10),
  EMAIL                VARCHAR(60), 
  GPS                  NUMERIC(10) DEFAULT 2402,
  FPAS                 NUMERIC(10) DEFAULT 582,
  TIPOSISTEMA          VARCHAR(1) DEFAULT 'A',
  CARIMBOCARNECORREIOS ${blob.type},
  CONSOLIDA         VARCHAR(1),
  CODAUDESP        NUMERIC(10),
  CODMUNICAUDESP  NUMERIC(10),
  CLIENTEELOTECH  CHAR(1) default 'N',
  PERCENTUALISENCAOFILANTROPICA NUMERIC(8,4) DEFAULT 0,
  SOURCECLASS VARCHAR(50),
  HASHSTRING VARCHAR(200),  
  CONSTRAINT XPKENTIDADE PRIMARY KEY (ID),
  CONSTRAINT FKENTIDADE_CIDADE FOREIGN KEY (CIDADE) REFERENCES ${db.unico.schema}.CIDADE(ID),
  CONSTRAINT FKENTIDADE_LOGRADOURO FOREIGN KEY (LOGRADOURO) REFERENCES ${db.unico.schema}.LOGRADOURO(ID),
  CONSTRAINT FKENTIDADE_BAIRRO FOREIGN KEY (BAIRRO) REFERENCES ${db.unico.schema}.BAIRRO(ID),
  CONSTRAINT FKENTIDADE_CNAE FOREIGN KEY (CNAE) REFERENCES ${db.unico.schema}.CNAE(ID),
  CONSTRAINT FKENTIDADE_TIPOENTIDADE FOREIGN KEY (TIPOENTIDADE) REFERENCES ${db.unico.schema}.ENTIDADETIPO(ID),
  CONSTRAINT FKCONTRIBUICAO_PREVIDENCIARIA FOREIGN KEY (GPS) REFERENCES ${db.unico.schema}.CONTRIBUICAOPREVIDENCIARIA(ID),
  CONSTRAINT FKFUNDO_PREVIDENCIA_SOCIAL FOREIGN KEY (FPAS) REFERENCES ${db.unico.schema}.FUNDOPREVIDENCIASOCIAL(ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPOLEIDOCUMENTO
(
   ID              NUMERIC(10,0) NOT NULL,
   CODIGO          NUMERIC(10,0),
   DESCRICAO       VARCHAR(250),
   EXIGENUMERODOC  CHAR(1),
   CONSTRAINT PKTIPOLEIDOC PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPOLEIESCOPO
(
   ID            NUMERIC(10,0) NOT NULL,
   CODIGO        NUMERIC(10,0),
   DESCRICAO     VARCHAR(250),
   PLURIANUAL    CHAR(1),
   CONSTRAINT PKTIPOLEIESCOPO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPOLEINATUREZA
(
   ID            NUMERIC(10,0) NOT NULL,
   CODIGO        NUMERIC(10,0),
   DESCRICAO     VARCHAR(250),
   CONSTRAINT PKTIPONATLEI PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.LEIATO
(
   ID                          NUMERIC(10,0)           NOT NULL,
   ENTIDADE                    NUMERIC(10,0)           NOT NULL,
   NUMERO                      NUMERIC(10,0)           NOT NULL,
   ANO                         NUMERIC(10,0)           NOT NULL,
   TIPOLEIESCOPO               NUMERIC(10,0)           NOT NULL,
   TIPOLEINATUREZA             NUMERIC(10,0)           NOT NULL,
   TIPOLEIDOCUMENTO            NUMERIC(10,0),
   VALORSUPLEMENTAR 		   NUMERIC(15,4), 
   VALORESPECIAL 			   NUMERIC(15,4), 
   VALOREXTRAORDINARIO 		   NUMERIC(15,4), 
   VALORSUPERAVIT 			   NUMERIC(15,4), 
   VALORSUPERAVITVINCULADO     NUMERIC(15,4), 
   VALOREXCESSO 			   NUMERIC(15,4), 
   VALOREXCESSOVINCULADO 	   NUMERIC(15,4), 
   VALORANULACAO 			   NUMERIC(15,4), 
   VALOROPERACAODECREDITO 	   NUMERIC(15,4), 
   VALORSEMDESPCORRESPONDENTE  NUMERIC(15,4),
   PERCSUPLEMENTACAO 		   NUMERIC(15,4), 
   PERCOPCREDARO 			   NUMERIC(15,4), 
   PERCOPCREDINT 			   NUMERIC(15,4), 
   DATAATO                     DATE,
   DATAPUBLICACAO              DATE,
   DATACADASTRO                DATE,
   DATAGERACAOTC			   DATE,	
   ANOINICIO                   NUMERIC(10,0),
   PAGINA                      VARCHAR(50),
   ANOEDICAO                   NUMERIC(10,0),
   NUMEROEDICAO                NUMERIC(10,0),
   IDTCE                       NUMERIC(10),
   SUMULA					   VARCHAR(4000),
   MOSTRAPORTAL                CHAR(1),
   DATAINICIOVIGENCIA		   DATE,
   DATAFIMVIGENCIA			   DATE,
   SITUACAO	                   CHAR(1),
   VEICULOPUBLICACAO 		   NUMERIC(10,0),
   ESFERAGOVERNO               CHAR(1),
   NUMEROTCE                   VARCHAR(20),
   IDUNICOATOISS			   NUMERIC(10,0),
   LEIAUTORIZATIVA			   NUMERIC(10,0),
   MODULO					   NUMERIC(10,0),	
   SOURCECLASS 				   VARCHAR(50),
   HASHSTRING 				   VARCHAR(200),  
   CONSTRAINT PKLEIATO PRIMARY KEY (ID),
   CONSTRAINT FKLEIATO_ENTIDADE  FOREIGN KEY  (ENTIDADE)  REFERENCES ${db.unico.schema}.ENTIDADE (ID),
   CONSTRAINT FKLEIATO_DOC  FOREIGN KEY  (TIPOLEIDOCUMENTO)  REFERENCES ${db.unico.schema}.TIPOLEIDOCUMENTO (ID),
   CONSTRAINT FKLEIATO_ESCOPO  FOREIGN KEY  (TIPOLEIESCOPO)  REFERENCES ${db.unico.schema}.TIPOLEIESCOPO (ID),
   CONSTRAINT FKLEIATO_NATUREZA  FOREIGN KEY  (TIPOLEINATUREZA)  REFERENCES ${db.unico.schema}.TIPOLEINATUREZA (ID),
   CONSTRAINT FKLEIATO_MODULO  FOREIGN KEY  (MODULO)  REFERENCES ${db.unico.schema}.MODULO (MODULO)
)
#
CREATE TABLE ${db.unico.schema}.TIPOVEICULOPUBLICACAO
(
   ID            NUMERIC(10,0) NOT NULL,
   CODIGO        NUMERIC(10,0),
   DESCRICAO     VARCHAR(250),
   UF            VARCHAR(2),
   TIPOVEICULOPUBLICACAO VARCHAR(3),
   CONSTRAINT PKTIPOVEICULOPUB PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPOLICITACAO
(
   ID            NUMERIC(10,0) NOT NULL,
   CODIGO        NUMERIC(10,0),
   DESCRICAO     VARCHAR(250),
   CODIGOCONTABILIDADE   VARCHAR(2),
   CONSTRAINT PKTIPOLICITACAO PRIMARY KEY (ID)
)
#
CREATE TABLE ${db.unico.schema}.VEICULOPUBLICACAO
(
   ID              NUMERIC(10,0) NOT NULL,
   CODIGOOPERACAO  NUMERIC(10,0) NOT NULL,
   CODIGOATOSPESSOAL VARCHAR(50),
   DATAALTERACAO     DATE,
   DATACADASTRO      DATE,
   DESCRICAO     VARCHAR(60),
   DATAENVIO     DATE,
   MOTIVOBAIXA  VARCHAR(250),
   OBSERVACAO  VARCHAR(250),
   DATABAIXA     DATE,
   ANOLICITACAO NUMERIC(10,0),
   NUMEROLICITACAO NUMERIC(10,0),
   POSSUILICITACAO VARCHAR(1),
   ENTIDADELICITACAO NUMERIC(10,0),
   PESSOA NUMERIC(10,0),
   ENTIDADE NUMERIC(10,0) NOT NULL,
   TIPOLICITACAO NUMERIC(10,0),
   TIPOVEICULOPUBLICACAO NUMERIC(10,0),
   LEIATO                NUMERIC(10,0),
   SOURCECLASS 				   VARCHAR(50),
   HASHSTRING 				   VARCHAR(200),  
   CONSTRAINT PKVEICULOPUBLICACAO PRIMARY KEY (ID),
   CONSTRAINT FKVEICULOPUB_ENTIDADELIC  FOREIGN KEY  (ENTIDADELICITACAO)  REFERENCES ${db.unico.schema}.ENTIDADE (ID),
   CONSTRAINT FKVEICULOPUB_PESSOA  FOREIGN KEY  (PESSOA)  REFERENCES ${db.unico.schema}.PESSOA (ID),
   CONSTRAINT FKVEICULOPUB_ENTIDADE  FOREIGN KEY  (ENTIDADE)  REFERENCES ${db.unico.schema}.ENTIDADE (ID),
   CONSTRAINT FKVEICULOPUB_TIPOLICI  FOREIGN KEY  (TIPOLICITACAO)  REFERENCES ${db.unico.schema}.TIPOLICITACAO (ID),
   CONSTRAINT FKVEICULOPUB_TIPOVEICU FOREIGN KEY  (TIPOVEICULOPUBLICACAO)  REFERENCES ${db.unico.schema}.TIPOVEICULOPUBLICACAO (ID),
   CONSTRAINT FKVEICULOPUB_LEIATO FOREIGN KEY  (LEIATO)  REFERENCES ${db.unico.schema}.LEIATO (ID)   
)
#
CREATE TABLE ${db.unico.schema}.LEIATOARQUIVO (
                   ID NUMERIC(10,0) NOT NULL,
                   LEIATO NUMERIC(10,0) NOT NULL,
                   PRINCIPAL VARCHAR(1),
                   IDARQUIVO NUMERIC(10,0),
                   CONSTRAINT PKLEIATOARQUIVO PRIMARY KEY (ID),
                   CONSTRAINT FKLEIATOARQ_LEIATO FOREIGN KEY (LEIATO) REFERENCES ${db.unico.schema}.LEIATO(ID)
                   
)
#
CREATE TABLE ${db.unico.schema}.LEIATOPUBLICACAO (
                   ID NUMERIC(10,0) NOT NULL,
                   LEIATO NUMERIC(10,0) NOT NULL,
                   PRINCIPAL VARCHAR(1),
                   VEICULOPUBLICACAO NUMERIC(10,0) NOT NULL,
                   NUMEROEDICAO NUMERIC(10,0),
                   ANOEDICAO NUMERIC(10,0),
                   DATAPUBLICACAO DATE,                   
                   CONSTRAINT PKLEIATOPUBLICACAO PRIMARY KEY (ID),
                   CONSTRAINT FKLEIATOPUB_LEIATO FOREIGN KEY (LEIATO) REFERENCES ${db.unico.schema}.LEIATO(ID),
                   CONSTRAINT FKLEIATOPUB_VEICUL FOREIGN KEY (VEICULOPUBLICACAO) REFERENCES ${db.unico.schema}.VEICULOPUBLICACAO(ID)
)
#
CREATE TABLE ${db.unico.schema}.TIPOLEIDOCUMENTO_ESCOPO (
                TIPOLEIDOCUMENTO NUMERIC(10,0) NOT NULL, 
                TIPOLEIESCOPO NUMERIC(10,0) NOT NULL,
                CONSTRAINT PKTIPOLEIDOC_ESCOPO PRIMARY KEY (TIPOLEIDOCUMENTO,TIPOLEIESCOPO),
                CONSTRAINT FKTIPOLEIESCOP_TIPOLEIDOC FOREIGN KEY (TIPOLEIDOCUMENTO) REFERENCES ${db.unico.schema}.TIPOLEIDOCUMENTO (ID),
                CONSTRAINT FKTIPOLEIESCOP_TIPOLEIESCOP FOREIGN KEY (TIPOLEIESCOPO) REFERENCES ${db.unico.schema}.TIPOLEIESCOPO (ID))
