/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.web.rest;

import br.com.elotech.core.domain.AuthenticationDetails;
import br.com.elotech.core.security.jwt.TokenGenerator;
import br.com.elotech.core.utils.Cipher;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.service.KeycloakAuthService;
import br.com.elotech.di.service.UsuarioService;
import br.com.elotech.unico.client.dto.LoginDTO;
import br.com.elotech.unico.client.dto.TipoUsuarioEnumDTO;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.BooleanUtils;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Profile(value={"!cloud"})
public class AuthenticationController {
    public static final String TOKEN_PREFIX = "token:";
    @Inject
    private KeycloakAuthService keycloakService;
    @Inject
    private TokenGenerator tokenGenerator;
    @Inject
    private AuthenticationManager authenticationManager;
    @Inject
    private UsuarioService usuarioService;

    @RequestMapping(value={"/api/authenticate"}, method={RequestMethod.POST})
    public ResponseEntity<AuthenticationDetails> authenticate(@Valid @RequestBody LoginDTO loginDTO, HttpServletResponse response) throws VerificationException {
        if (loginDTO.getPassword().startsWith(TOKEN_PREFIX)) {
            loginDTO.setPassword(Cipher.xorDecodeHex((String)loginDTO.getPassword().substring(TOKEN_PREFIX.length())));
        }
        if (TipoUsuarioEnumDTO.ELOTECH.equals((Object)loginDTO.getTipo()) || loginDTO.getUsername().endsWith("@elotech.com.br")) {
            AccessTokenResponse tokenResponse = this.keycloakService.auth(loginDTO);
            Usuario usuario = this.usuarioService.addUserByKeycloakLdap(tokenResponse, loginDTO);
            loginDTO.setUsername(usuario.getUsuario());
        }
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)loginDTO.getUsername().toLowerCase(Locale.getDefault()), (Object)loginDTO.getPassword());
        Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        boolean rememberMe = BooleanUtils.isTrue((Boolean)loginDTO.isRememberMe());
        String jwt = this.tokenGenerator.createToken(authentication, Boolean.valueOf(rememberMe));
        String token = "Bearer " + jwt;
        response.addHeader("Authorization", token);
        response.addHeader("X-AUTH-TOKEN", token);
        Optional entidadePadrao = this.usuarioService.getEntidadePadraoUsuario(loginDTO.getUsername());
        AuthenticationDetails.AuthenticationDetailsBuilder authenticationDetails = AuthenticationDetails.builder().token(jwt);
        if (entidadePadrao.isPresent()) {
            this.addDefaultHeaders((Entidade)entidadePadrao.get(), response);
            authenticationDetails.entidade(((Entidade)entidadePadrao.get()).getId()).nomeEntidade(((Entidade)entidadePadrao.get()).getNome());
        }
        return ResponseEntity.ok((Object)authenticationDetails.build());
    }

    @RequestMapping(value={"/rest/login"}, method={RequestMethod.POST})
    public ResponseEntity<?> login(@Valid @RequestBody LoginDTO loginDTO, HttpServletResponse response) throws VerificationException {
        return this.authenticate(loginDTO, response);
    }

    @RequestMapping(value={"/rest/token-acesso"}, method={RequestMethod.POST})
    public ResponseEntity<?> tokenAcesso(@Valid @RequestBody LoginDTO loginDTO) {
        return ResponseEntity.ok(Map.of("token", TOKEN_PREFIX + Cipher.xorEncodeHex((String)loginDTO.getPassword())));
    }

    private void addDefaultHeaders(Entidade entidadePadrao, HttpServletResponse response) {
        response.addHeader("ENTIDADE", entidadePadrao.getId().toString());
        response.addHeader("ENTIDADE_NOME", entidadePadrao.getNome());
    }
}

