/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.validation;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.di.strategy.resposta.ValidacaoStrategyFactoryUtils;
import br.com.elotech.di.strategy.resposta.ValidacaoValidatorStrategy;
import br.com.elotech.unico.client.domain.TipoValidacao;
import br.com.elotech.unico.client.dto.RespostaUnicoDTO;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class RespostaValidatorUtils {
    private RespostaValidatorUtils() {
    }

    public static void validar(List<RespostaUnicoDTO> respostas) {
        respostas.forEach(resposta -> {
            if (Boolean.TRUE.equals(resposta.getCampoObrigatorio()) && StringUtils.isBlank((CharSequence)resposta.getValorResposta()) && Objects.isNull(resposta.getCodigoAlternativa())) {
                throw new EloValidationException(String.format("O campo '%s' \u00e9 obrigat\u00f3rio", resposta.getDescricaoCampo()));
            }
            resposta.getValidacoesCampo().forEach(validacao -> {
                RespostaUnicoDTO respostaParaValidacao = respostas.stream().filter(r -> r.getIdentificadorCampo().equalsIgnoreCase(validacao.getCampoDependente())).findFirst().orElse(null);
                if (Objects.nonNull(respostaParaValidacao) && Boolean.TRUE.equals(respostaParaValidacao.getCampoAtivo())) {
                    ValidacaoValidatorStrategy validacaoValidator = ValidacaoStrategyFactoryUtils.get((TipoValidacao)validacao.getTipo());
                    validacaoValidator.validar(resposta, validacao, respostaParaValidacao);
                }
            });
        });
    }
}

