/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.validation;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.config.DBProperties;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.di.config.UnicoProperties;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.jdbc.core.JdbcTemplate;

@ConfigurationProperties(prefix="versions")
public class MinimumVersionValidator
implements InitializingBean {
    private static final String SQL_VERSAO = "SELECT max(versaobase) as versao FROM %s.logupdatedatabase where modulo in (%s) and datafim is not null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DBConfigProperties dbConfigProperties;
    private final JdbcTemplate jdbcTemplate;
    private final UnicoProperties unicoProperties;
    @NotNull
    private Integer contabil;
    @NotNull
    private Integer compras;
    @NotNull
    private Integer aiseRh;
    @NotNull
    private Integer aiseTributos;
    @NotNull
    private Integer protocolo;

    public MinimumVersionValidator(DBConfigProperties dbConfigProperties, JdbcTemplate jdbcTemplate, UnicoProperties unicoProperties) {
        this.dbConfigProperties = dbConfigProperties;
        this.jdbcTemplate = jdbcTemplate;
        this.unicoProperties = unicoProperties;
    }

    public boolean validate() {
        this.internalValidate(this.dbConfigProperties.getAise(), this.aiseRh, "Aise RH", new ModuloEnum[]{ModuloEnum.MODULO_LOGIN, ModuloEnum.MODULO_RH});
        this.internalValidate(this.dbConfigProperties.getAise(), this.aiseTributos, "Aise Tributos", new ModuloEnum[]{ModuloEnum.MODULO_TRIBUTARIO});
        this.internalValidate(this.dbConfigProperties.getContabilidade(), this.contabil, "Cont\u00e1bil", new ModuloEnum[]{ModuloEnum.MODULO_SISCOP});
        this.internalValidate(this.dbConfigProperties.getCompras(), this.compras, "Compras", new ModuloEnum[]{ModuloEnum.MODULO_COMPRAS});
        this.internalValidate(this.dbConfigProperties.getProtocolo(), this.protocolo, "Protocolo", new ModuloEnum[]{ModuloEnum.MODULO_PROTOCOLO});
        this.dbConfigProperties.validate();
        this.log.info("Validation ok");
        return true;
    }

    private void internalValidate(DBProperties dbProperties, Integer version, String name, ModuloEnum ... modulo) {
        Integer currentVersion = this.getCurrentVersion(dbProperties, modulo);
        if (Objects.nonNull(currentVersion) && currentVersion < version) {
            String msg = String.format("\u00c9 necess\u00e1rio atualizar %s, vers\u00e3o m\u00ednima %s e atual %s", name, version, currentVersion);
            this.log.error(msg);
            throw new IllegalStateException(msg);
        }
    }

    private Integer getCurrentVersion(DBProperties dbProperties, ModuloEnum ... modulos) {
        String filtro = Stream.of(modulos).map(ModuloEnum::getValue).map(s -> "'" + s + "'").collect(Collectors.joining(","));
        String sql = String.format(SQL_VERSAO, dbProperties.getSchema(), filtro);
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.unicoProperties.getValidateStart().booleanValue()) {
            this.log.info("Skip validate start!");
            return;
        }
        try {
            if (!this.unicoProperties.getCloud().booleanValue()) {
                this.validate();
            }
        }
        catch (IllegalStateException e) {
            this.log.error("Finalizar aplica\u00e7\u00e3o.", (Throwable)e);
            System.exit(0);
        }
    }

    @Generated
    public String toString() {
        return "MinimumVersionValidator(log=" + String.valueOf(this.getLog()) + ", dbConfigProperties=" + String.valueOf(this.getDbConfigProperties()) + ", jdbcTemplate=" + String.valueOf(this.getJdbcTemplate()) + ", unicoProperties=" + String.valueOf(this.getUnicoProperties()) + ", contabil=" + this.getContabil() + ", compras=" + this.getCompras() + ", aiseRh=" + this.getAiseRh() + ", aiseTributos=" + this.getAiseTributos() + ", protocolo=" + this.getProtocolo() + ")";
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public DBConfigProperties getDbConfigProperties() {
        return this.dbConfigProperties;
    }

    @Generated
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Generated
    public UnicoProperties getUnicoProperties() {
        return this.unicoProperties;
    }

    @Generated
    public Integer getContabil() {
        return this.contabil;
    }

    @Generated
    public Integer getCompras() {
        return this.compras;
    }

    @Generated
    public Integer getAiseRh() {
        return this.aiseRh;
    }

    @Generated
    public Integer getAiseTributos() {
        return this.aiseTributos;
    }

    @Generated
    public Integer getProtocolo() {
        return this.protocolo;
    }

    @Generated
    public void setContabil(Integer contabil) {
        this.contabil = contabil;
    }

    @Generated
    public void setCompras(Integer compras) {
        this.compras = compras;
    }

    @Generated
    public void setAiseRh(Integer aiseRh) {
        this.aiseRh = aiseRh;
    }

    @Generated
    public void setAiseTributos(Integer aiseTributos) {
        this.aiseTributos = aiseTributos;
    }

    @Generated
    public void setProtocolo(Integer protocolo) {
        this.protocolo = protocolo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinimumVersionValidator)) {
            return false;
        }
        MinimumVersionValidator other = (MinimumVersionValidator)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$contabil = this.getContabil();
        Integer other$contabil = other.getContabil();
        if (this$contabil == null ? other$contabil != null : !((Object)this$contabil).equals(other$contabil)) {
            return false;
        }
        Integer this$compras = this.getCompras();
        Integer other$compras = other.getCompras();
        if (this$compras == null ? other$compras != null : !((Object)this$compras).equals(other$compras)) {
            return false;
        }
        Integer this$aiseRh = this.getAiseRh();
        Integer other$aiseRh = other.getAiseRh();
        if (this$aiseRh == null ? other$aiseRh != null : !((Object)this$aiseRh).equals(other$aiseRh)) {
            return false;
        }
        Integer this$aiseTributos = this.getAiseTributos();
        Integer other$aiseTributos = other.getAiseTributos();
        if (this$aiseTributos == null ? other$aiseTributos != null : !((Object)this$aiseTributos).equals(other$aiseTributos)) {
            return false;
        }
        Integer this$protocolo = this.getProtocolo();
        Integer other$protocolo = other.getProtocolo();
        if (this$protocolo == null ? other$protocolo != null : !((Object)this$protocolo).equals(other$protocolo)) {
            return false;
        }
        Logger this$log = this.getLog();
        Logger other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        DBConfigProperties this$dbConfigProperties = this.getDbConfigProperties();
        DBConfigProperties other$dbConfigProperties = other.getDbConfigProperties();
        if (this$dbConfigProperties == null ? other$dbConfigProperties != null : !this$dbConfigProperties.equals(other$dbConfigProperties)) {
            return false;
        }
        JdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        JdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        if (this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate)) {
            return false;
        }
        UnicoProperties this$unicoProperties = this.getUnicoProperties();
        UnicoProperties other$unicoProperties = other.getUnicoProperties();
        return !(this$unicoProperties == null ? other$unicoProperties != null : !this$unicoProperties.equals(other$unicoProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MinimumVersionValidator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $contabil = this.getContabil();
        result = result * 59 + ($contabil == null ? 43 : ((Object)$contabil).hashCode());
        Integer $compras = this.getCompras();
        result = result * 59 + ($compras == null ? 43 : ((Object)$compras).hashCode());
        Integer $aiseRh = this.getAiseRh();
        result = result * 59 + ($aiseRh == null ? 43 : ((Object)$aiseRh).hashCode());
        Integer $aiseTributos = this.getAiseTributos();
        result = result * 59 + ($aiseTributos == null ? 43 : ((Object)$aiseTributos).hashCode());
        Integer $protocolo = this.getProtocolo();
        result = result * 59 + ($protocolo == null ? 43 : ((Object)$protocolo).hashCode());
        Logger $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        DBConfigProperties $dbConfigProperties = this.getDbConfigProperties();
        result = result * 59 + ($dbConfigProperties == null ? 43 : $dbConfigProperties.hashCode());
        JdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        UnicoProperties $unicoProperties = this.getUnicoProperties();
        result = result * 59 + ($unicoProperties == null ? 43 : $unicoProperties.hashCode());
        return result;
    }
}

