/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.validation;

import br.com.elotech.core.validation.EloValidatorAbstract;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaDocumento;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class EloValidatorDocumentoPessoa
extends EloValidatorAbstract<Pessoa> {
    public static final String MESSAGE_DOCUMENTO_EXISTENTE = "Este Documento/Certid\u00e3o j\u00e1 Existe: ";

    private void addViolationIfDuplicate(List<EloViolation> violations, List<PessoaDocumento> listDocumentoPessoa) {
        if (listDocumentoPessoa.size() > 1) {
            PessoaDocumento pessoaDocumento = listDocumentoPessoa.get(0);
            String documento = String.format("Documento: %s N\u00famero: %s Data Emiss\u00e3o: %s", pessoaDocumento.getDoc().getDocumento().getDescricao(), pessoaDocumento.getDoc().getNumeroDocumento(), pessoaDocumento.getDoc().getDataEmissao().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            violations.add(new EloViolation(MESSAGE_DOCUMENTO_EXISTENTE + documento, "Documentos Anexos:"));
        }
    }

    private String getKeyDocumentoPessoa(PessoaDocumento documentoPessoa) {
        return documentoPessoa.getDoc().getDataEmissao().toString() + documentoPessoa.getDoc().getNumeroDocumento() + documentoPessoa.getDoc().getDocumento().getId().toString();
    }

    protected void registerValidator() {
        this.registerValidator("documentos");
    }

    public List<EloViolation> valid(Pessoa entity) {
        ArrayList<EloViolation> violations = new ArrayList<EloViolation>();
        Map<Object, List<PessoaDocumento>> map = entity.getDocumentos().stream().collect(Collectors.groupingBy(i -> this.getKeyDocumentoPessoa(i)));
        map.forEach((k, v) -> this.addViolationIfDuplicate(violations, v));
        return violations;
    }
}

