/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.validation;

import br.com.elotech.core.validation.EloValidatorAbstract;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaBanco;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class EloValidatorBancoPessoa
extends EloValidatorAbstract<Pessoa> {
    public static final String MESSAGE_VALIDATE_BANCO = "Este n\u00famero de banco, ag\u00eancia e conta j\u00e1 est\u00e1 vinculado ao credor";

    private void addViolationIfDuplicate(List<EloViolation> violations, List<PessoaBanco> listBancoPessoa) {
        if (listBancoPessoa.size() > 1) {
            violations.add(new EloViolation(MESSAGE_VALIDATE_BANCO));
        }
    }

    private String getKeyBancoPessoa(PessoaBanco bancoPessoa) {
        if (bancoPessoa.getConta().getAgencia() == null) {
            return bancoPessoa.getConta().getConta();
        }
        return bancoPessoa.getConta().getConta() + bancoPessoa.getConta().getAgencia().getCodigo() + String.valueOf(bancoPessoa.getConta().getAgencia().getBanco());
    }

    protected void registerValidator() {
        this.registerValidator("bancosPessoa");
    }

    public List<EloViolation> valid(Pessoa entity) {
        ArrayList<EloViolation> violations = new ArrayList<EloViolation>();
        if (Boolean.TRUE.equals(entity.getIsServiceAccount())) {
            return violations;
        }
        List contas = entity.getBancosPessoa();
        Map<String, List<PessoaBanco>> map = contas.stream().collect(Collectors.groupingBy(i -> this.getKeyBancoPessoa(i)));
        map.forEach((k, v) -> this.addViolationIfDuplicate(violations, v));
        for (PessoaBanco pessoaBanco : contas) {
            if (pessoaBanco.getConta() == null || pessoaBanco.getConta().getConta() == null || !pessoaBanco.getValidaDigito().booleanValue() || pessoaBanco.getConta().getConta().indexOf("-") != -1) continue;
            violations.add(new EloViolation("Conta Bancaria Inv\u00e1lida Sem '-' digito verificador", "Conta Bancaria:", "conta.agencia", PessoaBanco.class));
        }
        return violations;
    }
}

