/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.utils;

import java.util.Optional;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.JsonWebToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SecurityUtils {
    public static final String INTEGRACAO_UNICO_TENANT = "integracao-unico-tenant";

    private SecurityUtils() {
    }

    public static String getNome() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof KeycloakAuthenticationToken) {
            KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)auth;
            return token.getAccount().getKeycloakSecurityContext().getToken().getName();
        }
        return null;
    }

    public static KeycloakAuthenticationToken getAuthentication() {
        return (KeycloakAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
    }

    public static Optional<KeycloakSecurityContext> getSecurityContext() {
        Optional<KeycloakSecurityContext> requestSecurityContext = Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(requestAttributes -> (KeycloakSecurityContext)requestAttributes.getAttribute(KeycloakSecurityContext.class.getName(), 0));
        if (requestSecurityContext.isPresent()) {
            return requestSecurityContext;
        }
        return Optional.ofNullable(SecurityUtils.getAuthentication()).map(token -> token.getAccount().getKeycloakSecurityContext());
    }

    public static String getTenantIntegracaoRequerimento() {
        return SecurityUtils.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-unico-tenant")).map(Object::toString).orElse("");
    }
}

