/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.utils;

public final class NIFUtils {
    public static Boolean isNIFValido(String nif) {
        if (nif == null || nif.length() != 9 || !nif.matches("\\d{9}")) {
            return false;
        }
        int soma = 0;
        for (int i = 0; i < 8; ++i) {
            int digito = Character.getNumericValue(nif.charAt(i));
            soma += digito * (9 - i);
        }
        int digitoControle = 0;
        if (soma % 11 > 1 && ((digitoControle = 11 - soma % 11) == 10 || digitoControle == 11)) {
            digitoControle = 0;
        }
        return digitoControle == Character.getNumericValue(nif.charAt(8));
    }
}

