/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.utils;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import org.springframework.core.env.ConfigurableEnvironment;

/*
 * Exception performing whole class analysis ignored.
 */
public class AmbienteUtils {
    public static String getCurrentURL(ConfigurableEnvironment environment) {
        return AmbienteUtils.buildUrlOnCloud((ConfigurableEnvironment)environment, (String)AmbienteUtils.getContextPath((ConfigurableEnvironment)environment));
    }

    public static String getCurrentURLReportExecutor(ConfigurableEnvironment environment) {
        return AmbienteUtils.buildUrlOnCloud((ConfigurableEnvironment)environment, (String)AmbienteUtils.getContextPathReportExecuter());
    }

    private static String buildUrlOnCloud(ConfigurableEnvironment environment, String contextPath) {
        return "https://".concat(AmbienteUtils.getTenant()).concat("." + AmbienteUtils.getAmbiente((ConfigurableEnvironment)environment)).concat(".elotech.com.br").concat(contextPath);
    }

    public static String getTenant() {
        return TenantContextHolder.getCurrentTenantId();
    }

    public static String getAmbiente(ConfigurableEnvironment environment) {
        if (AmbienteUtils.isProdEnvironment((ConfigurableEnvironment)environment)) {
            return "oxy";
        }
        if (AmbienteUtils.isQaEnvironment((ConfigurableEnvironment)environment)) {
            return "qa";
        }
        if (AmbienteUtils.isTestEnvironment((ConfigurableEnvironment)environment)) {
            return "test";
        }
        return "dev";
    }

    public static String getContextPath(ConfigurableEnvironment environment) {
        return environment.getProperty("server.servlet.context-path", "/unico-api");
    }

    public static String getContextPathReportExecuter() {
        return "/report-executor-api";
    }

    private static boolean isQaEnvironment(ConfigurableEnvironment environment) {
        return AmbienteUtils.environmentAccept((ConfigurableEnvironment)environment, (String[])new String[]{"qa"});
    }

    private static boolean isProdEnvironment(ConfigurableEnvironment environment) {
        return AmbienteUtils.environmentAccept((ConfigurableEnvironment)environment, (String[])new String[]{"production"});
    }

    private static boolean isTestEnvironment(ConfigurableEnvironment environment) {
        return AmbienteUtils.environmentAccept((ConfigurableEnvironment)environment, (String[])new String[]{"test"});
    }

    private static boolean environmentAccept(ConfigurableEnvironment environment, String ... profiles) {
        return environment.acceptsProfiles(profiles);
    }
}

