/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.unificacao;

import br.com.elotech.di.unificacao.SiaficDependency;
import br.com.elotech.di.unificacao.SiaficDependent;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SiaficModel {
    private String type;
    private List<SiaficDependency> dependencies;

    public List<SiaficDependency> filterByTable(String tableName) {
        return this.dependencies.stream().filter(d -> d.getTable().equalsIgnoreCase(tableName)).collect(Collectors.toList());
    }

    public SiaficDependency filterBySchemaAndTable(String schema, String tableName) {
        return this.dependencies.stream().filter(d -> d.getSchema().equalsIgnoreCase(schema)).filter(d -> d.getTable().equalsIgnoreCase(tableName)).findFirst().get();
    }

    public List<SiaficDependent> getForeignKeyConstraints() {
        return this.getDependencies().stream().flatMap(d -> d.getDependents().stream()).filter(d -> StringUtils.isNotBlank((CharSequence)d.getConstraint())).collect(Collectors.toList());
    }

    public List<SiaficDependent> getVirtualConstraints() {
        return this.getDependencies().stream().flatMap(d -> d.getDependents().stream()).filter(d -> StringUtils.isBlank((CharSequence)d.getConstraint())).collect(Collectors.toList());
    }

    @Generated
    public SiaficModel() {
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public List<SiaficDependency> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setDependencies(List<SiaficDependency> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SiaficModel)) {
            return false;
        }
        SiaficModel other = (SiaficModel)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List this$dependencies = this.getDependencies();
        List other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SiaficModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SiaficModel(type=" + this.getType() + ", dependencies=" + String.valueOf(this.getDependencies()) + ")";
    }
}

