/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.unificacao;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.jpa.hibernate.information.DataBaseInformationAccess;
import br.com.elotech.core.jpa.hibernate.information.TableDependencies;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.protocolo.ProtocoloPessoa;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import lombok.Generated;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PessoasTableDependencyResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PessoasTableDependencyResolver.class);
    private static final String SISCOP = "SISCOP";
    private static final String AISE = "AISE";
    private static final String APICE = "APICE";
    private static final String PROTOCOLO = "PROTOCOLO";
    private static final String UNICO = "UNICO";
    private final ObjectMapper objectMapper = new XmlMapper();
    private final DataBaseInformationAccess dataBaseInformationAccess;
    private final EntityManagerFactory emf;
    private final DBConfigProperties dbConfigProperties;
    private volatile List<TableInformation> tableDependencies;

    public PessoasTableDependencyResolver(DataBaseInformationAccess dataBaseInformationAccess, EntityManagerFactory emf, DBConfigProperties dbConfigProperties) {
        this.dataBaseInformationAccess = dataBaseInformationAccess;
        this.emf = emf;
        this.dbConfigProperties = dbConfigProperties;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public TableDependencies readFromXml(Class<?> clazzLegado) {
        block20: {
            String resouceName = String.format("/pessoa-dependencias-%s.xml", clazzLegado.getSimpleName());
            try (InputStream resourceAsStream = this.getClass().getResourceAsStream(resouceName);){
                TableDependencies tableDependencies;
                if (resourceAsStream == null) {
                    throw new IllegalArgumentException("Not found resource " + resouceName);
                }
                InputStreamReader streamReader = new InputStreamReader(resourceAsStream);
                try {
                    tableDependencies = this.normalizeSchemas((TableDependencies)this.objectMapper.readValue((Reader)streamReader, TableDependencies.class));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            streamReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        log.error("Erro lendo resource stream. {}", (Object)ex.getMessage(), (Object)ex);
                        if (resourceAsStream != null) {
                            resourceAsStream.close();
                        }
                        break block20;
                    }
                }
                streamReader.close();
                return tableDependencies;
            }
            catch (IOException ex) {
                log.error("Erro lendo resource stream. {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        return null;
    }

    private TableDependencies normalizeSchemas(TableDependencies tableDependencies) {
        tableDependencies.getDependencies().forEach(tb -> tb.setSchema(this.getNormalizeSchema(tb.getSchema())));
        return tableDependencies;
    }

    private String getNormalizeSchema(String schema) {
        switch (schema) {
            case "SISCOP": {
                return this.dbConfigProperties.getContabilidade().getSchema();
            }
            case "APICE": {
                return this.dbConfigProperties.getCompras().getSchema();
            }
            case "AISE": {
                return this.dbConfigProperties.getAise().getSchema();
            }
            case "PROTOCOLO": {
                return this.dbConfigProperties.getProtocolo().getSchema();
            }
            case "UNICO": {
                return this.dbConfigProperties.getUnico().getSchema();
            }
        }
        throw new IllegalArgumentException("Schema " + schema);
    }

    public List<TableInformation> readFromDB() {
        ArrayList<TableInformation> all = new ArrayList<TableInformation>();
        QualifiedTableName tableSiscopPessoa = this.getTableNameByClass(SiscopFornecedor.class);
        QualifiedTableName tableAisePessoa = this.getTableNameByClass(AisePessoa.class);
        QualifiedTableName tableApicePessoa = this.getTableNameByClass(ApicePessoa.class);
        QualifiedTableName tableProtocoloPessoa = this.getTableNameByClass(ProtocoloPessoa.class);
        all.addAll(this.dataBaseInformationAccess.getTableDependencies(tableSiscopPessoa, this.emf));
        all.addAll(this.dataBaseInformationAccess.getTableDependencies(tableAisePessoa, this.emf));
        all.addAll(this.dataBaseInformationAccess.getTableDependencies(tableApicePessoa, this.emf));
        all.addAll(this.dataBaseInformationAccess.getTableDependencies(tableProtocoloPessoa, this.emf));
        return all;
    }

    public List<TableInformation> readDBJoinXml() {
        ArrayList<TableInformation> all = new ArrayList<TableInformation>();
        all.addAll(this.readFromDB());
        ArrayList tablesFromXml = new ArrayList();
        tablesFromXml.addAll(this.getDependenciesFromFile(ProtocoloPessoa.class));
        tablesFromXml.addAll(this.getDependenciesFromFile(AisePessoa.class));
        tablesFromXml.addAll(this.getDependenciesFromFile(SiscopFornecedor.class));
        tablesFromXml.addAll(this.getDependenciesFromFile(ApicePessoa.class));
        tablesFromXml.forEach(tb -> {
            if (!all.stream().anyMatch(tbAll -> tbAll.getName().render().equalsIgnoreCase(tb.getName().render()))) {
                all.add((TableInformation)tb);
            }
        });
        return all;
    }

    private List<TableInformation> getDependenciesFromFile(Class<?> clazz) {
        return this.dataBaseInformationAccess.getTableDependenciesFromFile(this.emf, this.readFromXml(clazz), this.dataBaseInformationAccess.getTableInformation(clazz, this.emf));
    }

    public QualifiedTableName getTableNameByClass(Class<?> clazz) {
        return this.dataBaseInformationAccess.getQualifiedTableName(clazz, this.emf);
    }

    public String getTableNameByClassAsString(Class<?> clazz) {
        TableInformation table = this.dataBaseInformationAccess.getTableInformation(clazz, this.emf);
        return table.getName().render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableInformation> getTableDependencies() {
        if (this.tableDependencies == null) {
            PessoasTableDependencyResolver pessoasTableDependencyResolver = this;
            synchronized (pessoasTableDependencyResolver) {
                if (this.tableDependencies == null) {
                    this.tableDependencies = this.readDBJoinXml();
                }
            }
        }
        return this.tableDependencies;
    }

    public List<Map<String, String>> getPrimaryKeyValues(EntityManager em, TableInformation table, String columnName, List<String> columnValues) {
        return this.dataBaseInformationAccess.getPrimaryKeysValuesWhere(em, table, columnName, columnValues);
    }
}

