/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.unificacao;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.exception.RecordNotFoundException;
import br.com.elotech.core.jpa.hibernate.information.DataBaseInformationUtils;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaDisableDuplicate;
import br.com.elotech.di.domain.PessoaSocio;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.dto.GrupoDuplicado;
import br.com.elotech.di.domain.dto.PessoaDuplicadaDTO;
import br.com.elotech.di.domain.dto.PessoaDuplicadaOrigemDTO;
import br.com.elotech.di.domain.protocolo.ProtocoloPessoa;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.repository.projection.PessoaDuplicadaProjection;
import br.com.elotech.di.service.PessoaService;
import br.com.elotech.di.unificacao.PessoaDBCommand;
import br.com.elotech.di.unificacao.PessoaDBCommandExecutor;
import br.com.elotech.di.unificacao.PessoaDBCommandType;
import br.com.elotech.di.unificacao.PessoaJoin;
import br.com.elotech.di.unificacao.PessoaJoinLogger;
import br.com.elotech.di.unificacao.PessoaMerger;
import br.com.elotech.di.unificacao.PessoasDuplicadasRepository;
import br.com.elotech.di.unificacao.PessoasTableDependencyResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PessoasDuplicadasService {
    @Generated
    private static final Logger log = Logger.getLogger(PessoasDuplicadasService.class.getName());
    private static final List<Class<?>> PESSOAS_CLASSES = Arrays.asList(AisePessoa.class, ApicePessoa.class, ProtocoloPessoa.class, SiscopFornecedor.class);
    private static final Map<Class<?>, String> CLASSES_PRIMARY_KEY = new HashMap();
    public static final String JOIN_LOGGER_FILE = "pessoa_join_%d.xml";
    private final PessoasDuplicadasRepository repository;
    private final PessoaService pessoaService;
    private final PessoaMerger pessoaMerger;
    private final PessoaDBCommandExecutor pessoaDBCommandExecutor;
    private final PessoasTableDependencyResolver pessoasTableDependencyResolver;
    private final ObjectMapper objectMapper = new XmlMapper();
    private final String joinFolder = "joins" + File.separator;
    private final EntityManager em;
    private final DBConfigProperties dbConfigProperties;

    public PessoasDuplicadasService(PessoasDuplicadasRepository repository, PessoaService pessoaService, PessoaMerger pessoaMerger, PessoaDBCommandExecutor pessoaDBCommandExecutor, PessoasTableDependencyResolver pessoasTableDependencyResolver, EntityManager em, DBConfigProperties dbConfigProperties) {
        this.repository = repository;
        this.pessoaService = pessoaService;
        this.pessoaMerger = pessoaMerger;
        this.pessoaDBCommandExecutor = pessoaDBCommandExecutor;
        this.pessoasTableDependencyResolver = pessoasTableDependencyResolver;
        this.em = em;
        this.dbConfigProperties = dbConfigProperties;
    }

    public Page<PessoaDuplicadaDTO> findDuplicadas(Pageable pageable) {
        Page page = this.repository.findDuplicadas(pageable);
        log.info("returned duplications " + String.valueOf(page.getContent()));
        List newContent = page.getContent().stream().collect(Collectors.groupingBy(g -> Optional.ofNullable(g.getNome()).orElse("").replaceAll(" ", "").concat("_").concat(Optional.ofNullable(g.getCnpjCpf()).orElse("")))).entrySet().stream().map(arg_0 -> this.fromProjection(arg_0)).sorted(Comparator.comparing(PessoaDuplicadaDTO::getQuantidade).reversed()).collect(Collectors.toList());
        return new PageImpl(newContent, pageable, page.getTotalElements());
    }

    public GrupoDuplicado findGrupo(Set<PessoaDuplicadaOrigemDTO> origem, String cnpjCpf) {
        Set nomes = origem.stream().map(PessoaDuplicadaOrigemDTO::getNome).collect(Collectors.toSet());
        List pessoas = this.repository.findByNomeInAndCnpjCpf(nomes, cnpjCpf);
        if (pessoas.isEmpty()) {
            throw new RecordNotFoundException(String.format("Nenhuma pessoa encontrada com os nomes \"%s\" e CNPJ/CPF: \"%s\"", origem, cnpjCpf));
        }
        return GrupoDuplicado.builder().pessoas((Collection)pessoas).build();
    }

    private PessoaDuplicadaDTO fromProjection(Map.Entry<String, List<PessoaDuplicadaProjection>> entry) {
        PessoaDuplicadaProjection first = entry.getValue().get(0);
        int quantidadeTotal = entry.getValue().stream().mapToInt(PessoaDuplicadaProjection::getQuantidade).sum();
        return PessoaDuplicadaDTO.builder().nome(first.getNome()).cnpjCpf(first.getCnpjCpf()).quantidade(Integer.valueOf(quantidadeTotal)).nomesOriginais(entry.getValue().stream().map(PessoaDuplicadaProjection::getNome).map(PessoaDuplicadaOrigemDTO::of).collect(Collectors.toSet())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Pessoa unificarWith(PessoaDuplicadaDTO pessoaDuplicadaDTO) {
        this.disableEnableTriggers("disable");
        try {
            GrupoDuplicado grupo = this.findGrupo(pessoaDuplicadaDTO.getNomesOriginais(), pessoaDuplicadaDTO.getCnpjCpf());
            Pessoa pessoa = this.unificar(grupo);
            return pessoa;
        }
        finally {
            this.disableEnableTriggers("enable");
        }
    }

    private void disableEnableTriggers(String command) {
        if ("postgres".equalsIgnoreCase(this.dbConfigProperties.getUnico().getPlatform())) {
            this.em.createNativeQuery(String.format("alter table %s.tribproprietario %s trigger tg_insertproprietariohistory", this.dbConfigProperties.getAise().getUser(), command)).executeUpdate();
            this.em.createNativeQuery(String.format("alter table %s.empenho          %s trigger trgbiu_empenho", this.dbConfigProperties.getContabilidade().getUser(), command)).executeUpdate();
            this.em.createNativeQuery(String.format("alter table %s.liquidacao       %s trigger trgbiu_liquidacao", this.dbConfigProperties.getContabilidade().getUser(), command)).executeUpdate();
        }
    }

    @Transactional
    public Pessoa unificarWithDisableDuplicate(PessoaDisableDuplicate pessoaDisableDuplicate) {
        ArrayList<Pessoa> allPessoas = new ArrayList<Pessoa>();
        allPessoas.add(pessoaDisableDuplicate.getPessoaEnable());
        allPessoas.addAll(pessoaDisableDuplicate.getPessoaDisables());
        GrupoDuplicado grupo = new GrupoDuplicado(allPessoas);
        grupo.setRemaining(pessoaDisableDuplicate.getPessoaEnable());
        return this.unificar(grupo);
    }

    @Transactional
    public Pessoa unificar(GrupoDuplicado grupoDuplicado) {
        Pessoa remaining = grupoDuplicado.chooseRemaining();
        log.info("Choiced person" + String.valueOf(remaining));
        ArrayList commands = new ArrayList();
        PESSOAS_CLASSES.forEach(clz -> this.addCommandsFor(grupoDuplicado, clz, remaining, commands));
        this.pessoaDBCommandExecutor.apply(commands);
        Pessoa merged = this.pessoaMerger.merge(grupoDuplicado);
        merged.setInativo(Boolean.FALSE);
        log.info("Try to save merged person" + String.valueOf(merged));
        this.pessoaService.saveSkippingValidation(merged, null);
        grupoDuplicado.getPessoasExcept(merged).forEach(arg_0 -> ((PessoaService)this.pessoaService).inactiveFromJoin(arg_0));
        this.saveJoinLogger(PessoaJoinLogger.of().withCommands(commands).withPessoaRemaing(remaining.getId()).withPessoaJoin(grupoDuplicado.getPessoasExcept(remaining).stream().map(p -> PessoaJoin.of().withId(p.getId()).withAisePessoa(p.getCodigoAise()).withApicePessoa(p.getCodigoApice()).withprotocoloPessoa(p.getCodigoProtocolo()).withSiscopPessoa(p.getCodigoSiscop())).collect(Collectors.toList())), JOIN_LOGGER_FILE);
        return merged;
    }

    private void addCommandsFor(GrupoDuplicado grupoDuplicado, Class<?> clazzLegado, Pessoa remaining, List<PessoaDBCommand> commands) {
        long countByClass = grupoDuplicado.countByClass(clazzLegado);
        long countExecuted = 0L;
        log.info("Count duplicate for class " + clazzLegado.getSimpleName() + " " + countByClass);
        String tableNameByClass = this.pessoasTableDependencyResolver.getTableNameByClassAsString(clazzLegado);
        List inactives = grupoDuplicado.getPessoas().stream().filter(p -> p.getCodigoLegadoByClass(clazzLegado) != null && !p.equals((Object)remaining)).collect(Collectors.toList());
        Optional<Object> pessoaJoin = countByClass == (long)inactives.size() ? inactives.stream().findFirst() : Optional.of(remaining);
        HashMap tablesPrimaryKeyValues = new HashMap();
        List legadosKeysValues = inactives.stream().map(p -> p.getCodigoLegadoByClass(clazzLegado).toString()).collect(Collectors.toList());
        for (Pessoa p2 : inactives) {
            log.info("Executing " + clazzLegado.getSimpleName() + " " + ++countExecuted + " of " + countByClass);
            if (countByClass > 1L && !p2.equals(pessoaJoin.get())) {
                this.addCommandsForDependencies(clazzLegado, commands, tableNameByClass, p2, (Pessoa)pessoaJoin.get(), tablesPrimaryKeyValues, legadosKeysValues);
            } else {
                commands.add(PessoaDBCommand.of().withTableName(tableNameByClass).withColumnName("idunico").withActualValue(p2.getId().toString()).withNewValue(remaining.getId().toString()).withPrimaryKey(String.format("%s=%d", CLASSES_PRIMARY_KEY.get(clazzLegado), p2.getCodigoLegadoByClass(clazzLegado))).withClassname(clazzLegado.getSimpleName()).withCommandType(PessoaDBCommandType.UPDATE));
            }
            List socios = this.pessoaService.findSocios(p2);
            for (PessoaSocio pessoaSocio : socios) {
                commands.add(PessoaDBCommand.of().withTableName(this.pessoasTableDependencyResolver.getTableNameByClassAsString(PessoaSocio.class)).withColumnName("socio").withActualValue(p2.getId().toString()).withNewValue(remaining.getId().toString()).withPrimaryKey(String.format("id=%d", pessoaSocio.getId())).withClassname(clazzLegado.getSimpleName()).withCommandType(PessoaDBCommandType.UPDATE));
            }
        }
    }

    private void addCommandsForDependencies(Class<?> clazzLegado, List<PessoaDBCommand> commands, String tableNameByClass, Pessoa p, Pessoa pessoaJoin, Map<String, List<Map<String, String>>> tablesPrimaryKeyValues, List<String> legadosKeysValues) {
        this.pessoasTableDependencyResolver.getTableDependencies().forEach(table -> table.getForeignKeys().forEach(fk -> fk.getColumnReferenceMappings().forEach(column -> {
            String tableFk = column.getReferencedColumnMetadata().getContainingTableInformation().getName().render();
            if (tableFk.equalsIgnoreCase(tableNameByClass)) {
                List foundRecords;
                String columName = column.getReferencingColumnMetadata().getColumnIdentifier().render().toUpperCase(Locale.getDefault());
                if (!tablesPrimaryKeyValues.containsKey(table.getName().render() + columName)) {
                    tablesPrimaryKeyValues.put(table.getName().render() + columName, this.pessoasTableDependencyResolver.getPrimaryKeyValues(this.pessoaService.getEm(), table, columName, legadosKeysValues));
                }
                if (!(foundRecords = (List)tablesPrimaryKeyValues.get(table.getName().render() + columName)).isEmpty()) {
                    log.info("Records dependencies size: " + foundRecords.size() + " from table " + String.valueOf(table.getName()) + " for " + p.getCodigoLegadoByClass(clazzLegado));
                }
                Stream<Map> values = foundRecords.stream().filter(mapValues -> ((String)mapValues.get(columName)).equals(p.getCodigoLegadoByClass(clazzLegado).toString()));
                values.forEach(value -> {
                    if (DataBaseInformationUtils.hasColumnInPrimaryKey((TableInformation)table, (Identifier)column.getReferencingColumnMetadata().getColumnIdentifier())) {
                        commands.add(PessoaDBCommand.of().withTableName(table.getName().render()).withColumnName(columName).withActualValue(p.getCodigoLegadoByClass(clazzLegado).toString()).withNewValue(pessoaJoin.getCodigoLegadoByClass(clazzLegado).toString()).withPrimaryKey(this.formatWhere(table, value)).withClassname(clazzLegado.getSimpleName()).withCommandType(PessoaDBCommandType.INSERT));
                        commands.add(PessoaDBCommand.of().withTableName(table.getName().render()).withPrimaryKey(this.formatWhere(table, value)).withClassname(clazzLegado.getSimpleName()).withCommandType(PessoaDBCommandType.DELETE));
                    } else {
                        commands.add(PessoaDBCommand.of().withTableName(table.getName().render()).withColumnName(columName).withActualValue(p.getCodigoLegadoByClass(clazzLegado).toString()).withNewValue(pessoaJoin.getCodigoLegadoByClass(clazzLegado).toString()).withPrimaryKey(this.formatWhere(table, value)).withClassname(clazzLegado.getSimpleName()).withCommandType(PessoaDBCommandType.UPDATE));
                    }
                });
            }
        })));
        commands.add(PessoaDBCommand.of().withTableName(tableNameByClass).withPrimaryKey(String.format("%s=%d", CLASSES_PRIMARY_KEY.get(clazzLegado), p.getCodigoLegadoByClass(clazzLegado))).withClassname(clazzLegado.getSimpleName()).withCommandType(PessoaDBCommandType.DELETE));
    }

    private String formatWhere(TableInformation table, Map<String, String> value) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            if (!DataBaseInformationUtils.hasColumnInPrimaryKey((TableInformation)table, (Identifier)Identifier.toIdentifier((String)entry.getKey()))) continue;
            if (builder.length() > 0) {
                builder.append(" and ");
            }
            builder.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }

    void saveJoinLogger(PessoaJoinLogger joinLogger, String fileNameToFormat) {
        Files.createDirectories(Paths.get(this.joinFolder, new String[0]), new FileAttribute[0]);
        FileUtils.writeStringToFile((File)new File(String.format(this.joinFolder + fileNameToFormat, joinLogger.getPessoaRemaing())), (String)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)joinLogger), (Charset)Charset.defaultCharset());
    }

    public PessoaJoinLogger readJoinXml(Long id) throws IOException {
        return (PessoaJoinLogger)this.objectMapper.readValue(FileUtils.readFileToString((File)new File(String.format(this.joinFolder + JOIN_LOGGER_FILE, id)), (Charset)Charset.defaultCharset()), PessoaJoinLogger.class);
    }

    public void recreatePessoaJoin(PessoaJoin pessoaJoin) {
        if (Objects.nonNull(pessoaJoin.getAisePessoa())) {
            this.saveReplicable((Replicable)AisePessoa.ofPessoa((Long)pessoaJoin.getAisePessoa()), pessoaJoin);
        }
        if (Objects.nonNull(pessoaJoin.getApicePessoa())) {
            this.saveReplicable((Replicable)ApicePessoa.ofPessoa((Long)pessoaJoin.getApicePessoa()), pessoaJoin);
        }
        if (Objects.nonNull(pessoaJoin.getProtocoloPessoa())) {
            this.saveReplicable((Replicable)ProtocoloPessoa.ofPessoa((Long)pessoaJoin.getProtocoloPessoa()), pessoaJoin);
        }
        if (Objects.nonNull(pessoaJoin.getSiscopPessoa())) {
            this.saveReplicable((Replicable)SiscopFornecedor.ofPessoa((Long)pessoaJoin.getSiscopPessoa()), pessoaJoin);
        }
    }

    private void saveReplicable(Replicable<Pessoa, Long> replicable, PessoaJoin pessoaJoin) {
        replicable.setIdUnico((Serializable)pessoaJoin.getId());
        this.em.persist(replicable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseCommands(Long pessoaId, List<PessoaDBCommand> commands) {
        List commandsReversed = this.pessoaDBCommandExecutor.reverseCommands(commands);
        this.disableEnableTriggers("disable");
        try {
            this.pessoaDBCommandExecutor.apply(commandsReversed);
        }
        finally {
            this.disableEnableTriggers("enable");
        }
        this.saveJoinLogger(PessoaJoinLogger.of().withCommands(commandsReversed).withPessoaRemaing(pessoaId), "pessoa_join_reverse_%d.xml");
    }

    static {
        CLASSES_PRIMARY_KEY.put(AisePessoa.class, "pessoa");
        CLASSES_PRIMARY_KEY.put(ApicePessoa.class, "pessoa");
        CLASSES_PRIMARY_KEY.put(ProtocoloPessoa.class, "codpessoa");
        CLASSES_PRIMARY_KEY.put(SiscopFornecedor.class, "fornecedor");
    }
}

