/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.unificacao;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaAlteraRazao;
import br.com.elotech.di.domain.PessoaBanco;
import br.com.elotech.di.domain.PessoaContato;
import br.com.elotech.di.domain.PessoaDocumento;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.PessoaImagem;
import br.com.elotech.di.domain.PessoaRH;
import br.com.elotech.di.domain.PessoaSocio;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.dto.GrupoDuplicado;
import br.com.elotech.di.domain.support.ValueObject;
import br.com.elotech.di.unificacao.PessoaMergeUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Embedded;
import javax.persistence.OneToMany;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;

@Component
public class PessoaMerger {
    public Pessoa merge(GrupoDuplicado grupoDuplicado) {
        Pessoa remaining = grupoDuplicado.chooseRemaining();
        PessoaMergeUtils.updateFlags((GrupoDuplicado)grupoDuplicado, (Pessoa)remaining);
        List others = grupoDuplicado.getPessoasExcept(remaining);
        this.setBooleanFieldValues(others, remaining);
        this.setFieldValues(others, (Object)remaining);
        this.mergeRG(others, remaining);
        this.mergePessoaRH(others, remaining);
        this.mergeEnderecos(others, remaining);
        this.mergeContaBancaria(others, remaining);
        this.mergeContatos(others, remaining);
        this.mergeDocumentos(others, remaining);
        this.mergeSocios(others, remaining);
        this.mergeImagens(others, remaining);
        this.mergeRamoAtividade(others, remaining);
        this.mergeAlteracaoRazaoSocial(others, remaining);
        return remaining;
    }

    void setBooleanFieldValues(List<Pessoa> pessoas, Pessoa remaining) {
        List booleanFields = Stream.of(remaining.getClass().getDeclaredFields()).filter(f -> Boolean.class.equals(f.getType())).collect(Collectors.toList());
        for (Field field : booleanFields) {
            field.setAccessible(true);
            if (!BooleanUtils.isFalse((Boolean)((Boolean)field.get(remaining)))) continue;
            field.set(remaining, PessoaMergeUtils.coalesce(pessoas, (Field)field, BooleanUtils::isTrue, (Object)Boolean.FALSE));
        }
    }

    private void mergeRG(List<Pessoa> pessoas, Pessoa remaining) {
        if (Objects.isNull(remaining.getRg())) {
            remaining.setRg((Rg)PessoaMergeUtils.coalesce(pessoas, Pessoa::getRg, Objects::nonNull, null));
        }
    }

    private void mergePessoaRH(List<Pessoa> pessoas, Pessoa remaining) {
        if (Objects.isNull(remaining.getRh())) {
            remaining.setRh((PessoaRH)PessoaMergeUtils.coalesce(pessoas, Pessoa::getRh, Objects::nonNull, null));
        }
        if (Objects.nonNull(remaining.getRh())) {
            List rh = pessoas.stream().map(Pessoa::getRh).filter(Objects::nonNull).collect(Collectors.toList());
            if (Objects.isNull(remaining.getRh().getCidadeNascimento())) {
                remaining.getRh().setCidadeNascimento((Cidade)PessoaMergeUtils.coalesce(rh, PessoaRH::getCidadeNascimento, Objects::nonNull, null));
            }
            if (Objects.isNull(remaining.getRh().getCidadeTitulo())) {
                remaining.getRh().setCidadeTitulo((Cidade)PessoaMergeUtils.coalesce(rh, PessoaRH::getCidadeTitulo, Objects::nonNull, null));
            }
            List rhComum = rh.stream().map(PessoaRH::getComum).filter(Objects::nonNull).collect(Collectors.toList());
            this.setFieldValues(rhComum, (Object)remaining.getRh().getComum());
        }
    }

    <T> void setFieldValues(List<T> others, T remaining) {
        List fields = Stream.of(remaining.getClass().getDeclaredFields()).filter(f -> !Boolean.class.equals(f.getType())).collect(Collectors.toList());
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(OneToMany.class) || field.isAnnotationPresent(Embedded.class) || !Objects.isNull(field.get(remaining))) continue;
            field.set(remaining, PessoaMergeUtils.coalesce(others, (Field)field, Objects::nonNull, null));
        }
    }

    private void mergeEnderecos(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getEnderecos().stream()).map(PessoaEndereco::copy).filter(endereco -> !PessoaMergeUtils.existsOn((ValueObject)endereco, (List)remaining.getEnderecos())).forEach(remaining.getEnderecos()::add);
        PessoaMergeUtils.definePrincipal((List)remaining.getEnderecos(), PessoaEndereco::getPrincipal, PessoaEndereco::setPrincipal);
    }

    private void mergeContaBancaria(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getBancosPessoa().stream()).map(PessoaBanco::copy).filter(banco -> !PessoaMergeUtils.existsOn((ValueObject)banco, (List)remaining.getBancosPessoa())).forEach(remaining.getBancosPessoa()::add);
        PessoaMergeUtils.definePrincipal((List)remaining.getBancosPessoa(), b -> b.getConta().getPrincipal(), b -> b.getConta().setPrincipal(Boolean.FALSE));
    }

    private void mergeContatos(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getContatos().stream()).map(PessoaContato::copy).filter(contato -> !PessoaMergeUtils.existsOn((ValueObject)contato, (List)remaining.getContatos())).forEach(remaining.getContatos()::add);
        PessoaMergeUtils.definePrincipal((List)remaining.getContatos(), PessoaContato::getPrincipal, PessoaContato::setPrincipal);
    }

    private void mergeDocumentos(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getDocumentos().stream()).map(PessoaDocumento::copy).forEach(remaining.getDocumentos()::add);
    }

    private void mergeSocios(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getSocios().stream()).map(PessoaSocio::copy).forEach(remaining.getSocios()::add);
    }

    private void mergeImagens(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getImagens().stream()).map(PessoaImagem::getArquivo).map(PessoaImagem::of).forEach(remaining.getImagens()::add);
        PessoaMergeUtils.definePrincipal((List)remaining.getImagens(), PessoaImagem::getPrincipal, PessoaImagem::setPrincipal);
    }

    private void mergeRamoAtividade(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getRamoAtividades().stream()).forEach(remaining.getRamoAtividades()::add);
    }

    private void mergeAlteracaoRazaoSocial(List<Pessoa> pessoas, Pessoa remaining) {
        pessoas.stream().flatMap(p -> p.getAlteracoesRazao().stream()).map(PessoaAlteraRazao::copy).forEach(remaining.getAlteracoesRazao()::add);
    }
}

