/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.unificacao;

import br.com.elotech.di.unificacao.DBCommandException;
import br.com.elotech.di.unificacao.PessoaDBCommand;
import br.com.elotech.di.unificacao.PessoaDBCommandType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Component;

@Component
public class PessoaDBCommandExecutor {
    @Generated
    private static final Logger log = Logger.getLogger(PessoaDBCommandExecutor.class.getName());
    private final EntityManager em;
    private final JdbcTemplate jdbcTemplate;
    private static final List<String> IGNORE_COLUMNS = new ArrayList();
    private static final List<String> TRANSITIVE_TABLES = new ArrayList();

    public PessoaDBCommandExecutor(EntityManager em, JdbcTemplate jdbcTemplate) {
        this.em = em;
        this.jdbcTemplate = jdbcTemplate;
    }

    public void apply(List<PessoaDBCommand> commands) {
        this.internalApply(this.reorderComands(commands));
    }

    public List<PessoaDBCommand> reorderComands(List<PessoaDBCommand> commands) {
        List<PessoaDBCommand> ordered = commands.stream().filter(cm -> !cm.getCommandType().equals((Object)PessoaDBCommandType.DELETE) && !this.contaisInTransitiveTables(cm)).collect(Collectors.toList());
        ordered.addAll(commands.stream().filter(cm -> !cm.getCommandType().equals((Object)PessoaDBCommandType.DELETE) && this.contaisInTransitiveTables(cm)).collect(Collectors.toList()));
        ordered.addAll(commands.stream().filter(cm -> cm.getCommandType().equals((Object)PessoaDBCommandType.DELETE) && this.contaisInTransitiveTables(cm)).collect(Collectors.toList()));
        ordered.addAll(commands.stream().filter(cm -> cm.getCommandType().equals((Object)PessoaDBCommandType.DELETE) && !this.contaisInTransitiveTables(cm)).collect(Collectors.toList()));
        return ordered;
    }

    private void internalApply(List<PessoaDBCommand> commands) {
        commands.forEach(cm -> {
            log.info("executing  " + String.valueOf(cm));
            if (cm.getCommandType().equals((Object)PessoaDBCommandType.UPDATE)) {
                this.executeUpdate(cm);
            } else if (cm.getCommandType().equals((Object)PessoaDBCommandType.DELETE)) {
                this.executeDelete(cm);
            } else {
                this.executeInsert(cm);
            }
        });
    }

    private void executeInsert(PessoaDBCommand cm) {
        String primaryKey = cm.getPrimaryKey().toUpperCase(Locale.getDefault());
        primaryKey = primaryKey.replaceFirst(String.format("%s=%s", cm.getColumnName().toUpperCase(Locale.getDefault()), cm.getActualValue()), String.format("%s=%s", cm.getColumnName(), cm.getNewValue()));
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet("select * from " + cm.getTableName() + " where " + primaryKey);
        if (!rs.next() || primaryKey.equalsIgnoreCase(cm.getPrimaryKey())) {
            SqlRowSetMetaData meta = rs.getMetaData();
            StringBuilder insertStatement = new StringBuilder();
            insertStatement.append("INSERT INTO ").append(cm.getTableName()).append(" SELECT ");
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                if (this.existsOnIgnoredColumns(cm, meta.getColumnName(i))) {
                    insertStatement.append("null");
                } else if (meta.getColumnName(i).equalsIgnoreCase(cm.getColumnName())) {
                    insertStatement.append(cm.getNewValue());
                } else {
                    insertStatement.append(meta.getColumnName(i));
                }
                if (i == meta.getColumnCount()) continue;
                insertStatement.append(',');
            }
            insertStatement.append(" FROM ").append(cm.getTableName()).append(" WHERE ").append(cm.getPrimaryKey());
            this.executeQuery(insertStatement.toString());
        }
    }

    public boolean existsOnIgnoredColumns(PessoaDBCommand cm, String columnName) {
        String tableColumn = String.format("%s.%s", cm.getTableName(), columnName).toUpperCase(Locale.getDefault());
        return IGNORE_COLUMNS.stream().anyMatch(tableColumn::endsWith);
    }

    private void executeQuery(String sqlCommand) {
        try {
            this.em.createNativeQuery(sqlCommand).executeUpdate();
        }
        catch (PersistenceException e) {
            log.warning("Error  executing " + sqlCommand);
            throw new DBCommandException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeUpdate(PessoaDBCommand cm) {
        this.executeQuery("update " + cm.getTableName() + " set " + cm.getColumnName() + "=" + cm.getNewValue() + " where " + cm.getPrimaryKey());
    }

    private void executeDelete(PessoaDBCommand cm) {
        this.executeQuery("delete from " + cm.getTableName() + " where " + cm.getPrimaryKey());
    }

    private boolean contaisInTransitiveTables(PessoaDBCommand cm) {
        return TRANSITIVE_TABLES.stream().anyMatch(table -> cm.getTableName().toUpperCase(Locale.getDefault()).contains((CharSequence)table));
    }

    public List<PessoaDBCommand> reverseCommands(List<PessoaDBCommand> pessoaDBCommands) {
        ArrayList<PessoaDBCommand> commandsReversed = new ArrayList<PessoaDBCommand>();
        pessoaDBCommands.forEach(cm -> commandsReversed.addAll(cm.reverse()));
        return commandsReversed;
    }

    static {
        IGNORE_COLUMNS.add("PAIS.CODIGOBACEN");
        IGNORE_COLUMNS.add("TRIBCONTRATOSOCIALPESSOA.IDSOCIOISS");
        IGNORE_COLUMNS.add(".IDKEY");
        IGNORE_COLUMNS.add("_IDKEY");
        TRANSITIVE_TABLES.add("CONTORDEMPAGAMENTOITEM");
        TRANSITIVE_TABLES.add("RHFUNCIONARIO");
        TRANSITIVE_TABLES.add("ENDERECOPESSOAHISTORICO");
        TRANSITIVE_TABLES.add("RHPESSOAHISTORICO");
        TRANSITIVE_TABLES.add("RHAVALIACAOCONCURSOITEM");
        TRANSITIVE_TABLES.add("TRIBSOLALVARACONTRATOSOCIAL");
        TRANSITIVE_TABLES.add("CLCERTIDAODOCUMENTACAO");
        TRANSITIVE_TABLES.add("CLCOTACAOITEM");
        TRANSITIVE_TABLES.add("CLADITIVOITEM");
        TRANSITIVE_TABLES.add("CLFORNECEDORPONTUACAO");
        TRANSITIVE_TABLES.add("FORNECEDORBANCOENTIDADE");
    }
}

