/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.unificacao;

import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.repository.Bairros;
import br.com.elotech.di.repository.Cidades;
import br.com.elotech.di.repository.Logradouros;
import br.com.elotech.di.service.BairroService;
import br.com.elotech.di.service.CidadeService;
import br.com.elotech.di.service.LogradouroService;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CidadeDuplicadaService {
    private final LogradouroService logradouroService;
    private final Logradouros logradouroRepository;
    private final BairroService bairroService;
    private final Bairros bairroRepository;
    private final CidadeService cidadeService;
    private final Cidades cidadeRepository;

    public void removerDuplicacoes(DuplicadaDTO cidadeDuplicadaDTO) {
        List chavesInativacao = cidadeDuplicadaDTO.getChavesInativa();
        this.inativarCidades(chavesInativacao, cidadeDuplicadaDTO.getChavePrincipal());
    }

    private void inativarCidades(List<Long> chavesInativacao, Long chavePrincipal) {
        List cidadesInativacao = this.cidadeRepository.findAllByIdInAndInativoIsFalse(chavesInativacao).stream().peek(cidade -> cidade.setInativo(Boolean.TRUE)).collect(Collectors.toList());
        this.cidadeService.saveAll(cidadesInativacao);
        Cidade cidade2 = new Cidade();
        cidade2.setId(chavePrincipal);
        this.inativarBairros(chavesInativacao, cidade2);
        this.inativarLogradouros(chavesInativacao, cidade2);
    }

    private void inativarBairros(List<Long> idsCidadesInativadas, Cidade cidade) {
        List<Bairro> bairrosInativacao = this.bairroRepository.findAllByCidadeIdIn(idsCidadesInativadas).stream().peek(bairro -> bairro.setInativo(Boolean.TRUE)).collect(Collectors.toList());
        this.bairroService.saveAll(bairrosInativacao);
        bairrosInativacao.forEach(bairro -> {
            Boolean existeBairroComMesmaDescricao = this.bairroRepository.existsByDescricaoIgnoreCaseAndCidadeId(bairro.getDescricao(), cidade.getId());
            if (!existeBairroComMesmaDescricao.booleanValue()) {
                Bairro bairroCidadePrincipal = new Bairro();
                bairroCidadePrincipal.setDescricao(bairro.getDescricao());
                bairroCidadePrincipal.setCidade(cidade);
                this.bairroService.saveAndFlush((EloDomain)bairroCidadePrincipal);
            }
        });
    }

    private void inativarLogradouros(List<Long> idsCidadesInativadas, Cidade cidade) {
        List<Logradouro> logradourosInativos = this.logradouroRepository.findAllByCidadeIdIn(idsCidadesInativadas).stream().peek(logradouro -> logradouro.setInativo(Boolean.TRUE)).collect(Collectors.toList());
        this.logradouroService.saveAll(logradourosInativos);
        logradourosInativos.forEach(logradouro -> {
            Boolean existeLogradouroComMesmaDescricao = this.logradouroRepository.existsByDescricaoIgnoreCaseAndCidadeId(logradouro.getDescricao(), cidade.getId());
            if (!existeLogradouroComMesmaDescricao.booleanValue()) {
                Logradouro logradouroCidadePrincipal = new Logradouro();
                logradouroCidadePrincipal.setDescricao(logradouro.getDescricao());
                logradouroCidadePrincipal.setCidade(cidade);
                this.logradouroService.saveAndFlush((EloDomain)logradouroCidadePrincipal);
            }
        });
    }

    @Generated
    public CidadeDuplicadaService(LogradouroService logradouroService, Logradouros logradouroRepository, BairroService bairroService, Bairros bairroRepository, CidadeService cidadeService, Cidades cidadeRepository) {
        this.logradouroService = logradouroService;
        this.logradouroRepository = logradouroRepository;
        this.bairroService = bairroService;
        this.bairroRepository = bairroRepository;
        this.cidadeService = cidadeService;
        this.cidadeRepository = cidadeRepository;
    }
}

