/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.support;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.service.support.CrudSavingStatus;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.service.support.CrudServiceException;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.di.batch.job.BatchContextHolder;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.AppParams;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.ReplicateAise;
import br.com.elotech.di.replicate.support.ReplicateProtocolo;
import br.com.elotech.di.replicate.support.Replicator;
import br.com.elotech.di.repository.support.UnicoCrudRepository;
import br.com.elotech.di.service.support.CrudServiceReplicate;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public class UnicoCrudService<T extends EloDomain<K>, K extends Serializable>
extends CrudService<T, K>
implements InitializingBean {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private List<Replicator<T, K, ? extends Replicable<T, K>>> replicators;
    @PersistenceUnit
    private EntityManagerFactory emf;
    @Autowired
    private UnicoProperties unicoProperties;
    @Autowired
    private AppParams appParams;
    @Value(value="${elotech.outbox-data-integration.producer.enabled:false}")
    private Boolean outboxEnabled = Boolean.FALSE;
    @Autowired
    private Optional<Publisher> publisher;

    public Logger getLog() {
        return this.log;
    }

    public Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public List<Replicator<T, K, ? extends Replicable<T, K>>> getReplicators() {
        return this.replicators;
    }

    public UnicoProperties getUnicoProperties() {
        return this.unicoProperties;
    }

    public boolean isUnicoCloud() {
        return this.unicoProperties.getCloud();
    }

    public void setUnicoProperties(UnicoProperties unicoProperties) {
        this.unicoProperties = unicoProperties;
    }

    private UnicoCrudRepository<T, K> getUnicoRepository() {
        return (UnicoCrudRepository)super.getCrudRepository();
    }

    public void setReplicators(List<Replicator<T, K, ? extends Replicable<T, K>>> replicators) {
        this.replicators = replicators;
    }

    protected void validateEntity(T entity, Authentication authentication, List<EloViolation> violations) {
    }

    public Boolean getOutboxEnabled() {
        return this.outboxEnabled;
    }

    public void setOutboxEnabled(Boolean value) {
        this.outboxEnabled = value;
    }

    protected void beforeSave(T entity, Authentication authentication) {
        List list;
        super.beforeSave(entity, authentication);
        List listViolations = this.getValidatorExecutor().validate(entity);
        this.validateEntity(entity, authentication, listViolations);
        CrudServiceException.throwExceptionViolations((List)listViolations);
        if (entity.isNew() && !BatchContextHolder.isRunning() && !(list = this.getUnicoRepository().findAllByHashString(entity.hashString())).isEmpty()) {
            CrudServiceException.throwDuplicateRecordException((List)list);
        }
    }

    protected void afterSave(T saved, Authentication authentication) {
        this.getEm().flush();
        this.internalReplicate(saved);
    }

    public void internalReplicate(T saved) {
        CrudServiceReplicate crudServiceReplicate = this.internalCreateReplicator(saved);
        crudServiceReplicate.replicateAfterSave(saved, this.getEm());
    }

    private CrudServiceReplicate<T, K> internalCreateReplicator(T entity) {
        if (this.unicoProperties != null && this.unicoProperties.getCloud().booleanValue()) {
            List activeReplicators = this.replicators.stream().filter(r -> TenantContextHolder.getTenant().getModulos().stream().map(arg_0 -> this.findReplicateByModulo(arg_0)).filter(Objects::nonNull).anyMatch(modulo -> modulo.isAssignableFrom(r.getClass()))).collect(Collectors.toList());
            return new CrudServiceReplicate(activeReplicators);
        }
        return this.createReplicator(entity);
    }

    protected CrudServiceReplicate<T, K> createReplicator(T entity) {
        return new CrudServiceReplicate(this.replicators);
    }

    public void replicate(K id, Consumer<T> customize) {
        EloDomain loaded = (EloDomain)this.findOne(id);
        Assert.notNull((Object)loaded, (String)("Entidade n\u00e3o encontrado com id " + String.valueOf(id)));
        customize.accept(loaded);
        CrudServiceReplicate crudServiceReplicate = this.internalCreateReplicator(loaded);
        crudServiceReplicate.replicateAfterSave(loaded, this.getEm());
    }

    protected void afterDelete(T entity, Authentication authentication) {
        CrudServiceReplicate crudServiceReplicate = this.internalCreateReplicator(entity);
        crudServiceReplicate.replicateAfterDelete(entity, this.getEm());
        this.publishOutboxEvent(OutboxActions.DELETED, entity);
    }

    public T save(T entity) {
        return (T)((EloDomain)super.save(entity, this.getAuthentication()));
    }

    public void delete(T entity) {
        super.delete(entity, this.getAuthentication());
    }

    @Transactional
    public T saveAndFlush(T entity) {
        EloDomain saved = (EloDomain)super.save(entity, this.getAuthentication());
        this.getCrudRepository().flush();
        return (T)saved;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public T persistAndFlushStateless(T entity) {
        this.executeOnNewTransaction(entityManager -> {
            this.beforeSave(entity, this.getAuthentication());
            if (entity.isNew()) {
                entityManager.persist((Object)entity);
            } else {
                entityManager.merge((Object)entity);
            }
            CrudServiceReplicate crudServiceReplicate = this.internalCreateReplicator(entity);
            crudServiceReplicate.replicateAfterSave(entity, entityManager);
            entityManager.flush();
        });
        return entity;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void executeOnNewTransaction(Consumer<EntityManager> function) {
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.emf);
        Assert.notNull((Object)entityManager, (String)"No transaction entity manager found");
        function.accept(entityManager);
    }

    @Transactional
    public List<T> saveAll(List<T> entities) {
        ArrayList<EloDomain> result = new ArrayList<EloDomain>();
        for (EloDomain entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    public void afterPropertiesSet() {
        Assert.isAssignable(UnicoCrudRepository.class, (Class)this.getRepository().getClass());
    }

    protected boolean shouldRefreshAfterSave() {
        return true;
    }

    protected void afterSaveWithStatus(T saved, CrudSavingStatus crudSavingStatus) {
        if (CrudSavingStatus.CREATED.equals((Object)crudSavingStatus)) {
            this.publishOutboxEvent(OutboxActions.CREATED, saved);
        } else if (CrudSavingStatus.UPDATED.equals((Object)crudSavingStatus)) {
            this.publishOutboxEvent(OutboxActions.UPDATED, saved);
        }
    }

    protected void publishOutboxEvent(OutboxActions action, T entity) {
        if (this.outboxEnabled.booleanValue() && this.appParams.isCloud() && this.unicoProperties.getCloud().booleanValue()) {
            if (!this.publisher.isPresent()) {
                throw new IllegalStateException("A integra\u00e7\u00e3o do Outbox est\u00e1 ativa mais n\u00e3o foi encontrada a depend\u00eancia do Publisher.");
            }
            if (entity instanceof EntityPublisher) {
                ((Publisher)this.publisher.get()).publish(action, (EntityEvent)((EntityPublisher)entity).convertToEvent());
            }
        }
    }

    private Class<?> findReplicateByModulo(Modulo modulo) {
        if (Modulo.OXY_TRIBUTOS.equals((Object)modulo)) {
            return ReplicateAise.class;
        }
        if (Modulo.OXY_PROCESSOS.equals((Object)modulo)) {
            return ReplicateProtocolo.class;
        }
        return null;
    }
}

