/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.support;

import br.com.elotech.core.exception.EloDatabaseException;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.Replicable;
import br.com.elotech.di.replicate.support.Replicator;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class CrudServiceReplicate<T extends EloDomain<K>, K extends Serializable> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<Replicator<T, K, ? extends Replicable<T, K>>> replicators;

    public CrudServiceReplicate(List<Replicator<T, K, ? extends Replicable<T, K>>> replicators) {
        this.replicators = replicators;
    }

    public void replicateAfterDelete(T entity, EntityManager entityManager) {
        for (Replicator replicator : this.replicators) {
            List legados = entityManager.createQuery("from " + replicator.getReplicableType().getSimpleName() + " where idUnico = :idUnico").setParameter("idUnico", (Object)entity.getId()).getResultList();
            if (legados.size() > 1) {
                throw new IllegalStateException(String.format("Mais de um objeto do tipo %s para o idunico %d.", replicator.getReplicableType().getSimpleName(), entity.getId()));
            }
            if (legados.size() != 1) continue;
            entityManager.remove(legados.get(0));
        }
    }

    public void replicateAfterSave(T entity, EntityManager entityManager) {
        Iterator iterator = this.replicators.iterator();
        while (iterator.hasNext()) {
            Replicator item;
            Replicator replicator = item = (Replicator)iterator.next();
            Class classReplicate = replicator.getReplicableType();
            TypedQuery query = entityManager.createQuery("from " + classReplicate.getSimpleName() + " where idUnico = :idUnico", classReplicate).setParameter("idUnico", (Object)entity.getId()).setFlushMode(FlushModeType.COMMIT);
            List list = query.getResultList();
            try {
                if (list.isEmpty()) {
                    if (!replicator.canReplicateFor(entity)) continue;
                    this.log.trace("Create new obj with type " + classReplicate.getSimpleName());
                    Replicable legado = replicator.from(entity, (Replicable)BeanUtils.instantiateClass((Class)classReplicate));
                    entityManager.persist((Object)legado);
                    continue;
                }
                Preconditions.checkArgument((list.size() == 1 ? 1 : 0) != 0, (Object)("Deveria haver apenas um registro com idUnico = " + String.valueOf(entity.getId()) + " para a classe " + String.valueOf(classReplicate)));
                entityManager.merge((Object)replicator.from(entity, (Replicable)list.get(0)));
                entityManager.flush();
            }
            catch (Exception ex) {
                String message = String.format("Erro ao replicar o registro do tipo %s com IdUnico %s para a tabela %s: %s", entity.getClass().getSimpleName(), entity.getId(), classReplicate.getSimpleName(), ex);
                this.log.error(message, (Throwable)ex);
                throw new EloDatabaseException(message, (Throwable)ex);
            }
        }
    }
}

