/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.sincronizar;

import br.com.elotech.client.painel.feign.NotificationWebSocketFeign;
import br.com.elotech.core.exception.NoRollbackForException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudSavingStatus;
import br.com.elotech.core.utils.ReflectionUtils;
import br.com.elotech.di.components.TransactionHandlerComponent;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.EntityPublisher;
import br.com.elotech.di.dto.StatusRepublishDTO;
import br.com.elotech.di.dto.TopicSocketDTO;
import br.com.elotech.di.dto.enums.ExchangesEnum;
import br.com.elotech.di.dto.enums.StatusPublishEnum;
import br.com.elotech.di.repository.support.UnicoCrudRepository;
import br.com.elotech.di.service.support.UnicoCrudService;
import br.com.elotech.lib.painel.dto.WebSocketMessage;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.unico.client.EntityEventPayload;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;

public abstract class AbstractSincronizarService<E extends EloDomain<K>, K extends Serializable, D extends EntityEventPayload<K>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSincronizarService.class);
    private static final int QTD_MAX_LOTE = 125;
    private static final double ATUALIZACAO_RATIO = 0.01;
    private static final int TIMEOUT = 1;
    private final ObjectProvider<Publisher> publisher;
    private final TransactionHandlerComponent transactionHandlerComponent;
    private final RedisTemplate<String, StatusRepublishDTO> redisTemplate;
    private final NotificationWebSocketFeign notificationWebSocketFeign;
    private final ObjectMapper objectMapper;
    private final EntityManager entityManager;
    private final UnicoCrudRepository<E, K> repository;
    private final UnicoCrudService<E, K> service;

    abstract ExchangesEnum getExchange();

    public boolean appliesTo(ExchangesEnum exchange) {
        return this.getExchange().equals((Object)exchange);
    }

    public String createKey(String exchange) {
        return String.format("FILA-topic(%s)-t(%s)", exchange, TenantContextHolder.getCurrentTenantId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void sincronizar(String search) {
        StatusRepublishDTO status = StatusRepublishDTO.buildObject((ExchangesEnum)this.getExchange(), (String)search);
        status.iniciar();
        this.handleCommunication(status);
        List ids = this.findToSincronizar(search);
        status.setQuantidadeTotal(Integer.valueOf(ids.size()));
        this.handleCommunication(status);
        int qtdLote = this.gerarQuantidadeTotalDoLote(status);
        try {
            List partitionedIds = ListUtils.partition((List)ids, (int)qtdLote);
            for (List idList : partitionedIds) {
                if (this.verificarSeStatusCancelado(status)) {
                    status.cancelar();
                    this.handleCommunication(status);
                    break;
                }
                this.transactionHandlerComponent.runInNewTransaction(() -> this.sincronizacaoInterna(idList, status));
            }
        }
        finally {
            StatusPublishEnum statusRecuperado = this.deletarCanceladoRedisKey(status);
            status.finalizar(statusRecuperado);
            this.handleCommunication(status);
        }
    }

    public void cancelarSincronizacao(StatusRepublishDTO status) {
        status.cancelando();
        this.handleCommunication(status);
    }

    private boolean verificarSeStatusCancelado(StatusRepublishDTO status) {
        String key = status.getKey() + "-CANCELADO";
        return this.redisTemplate.opsForValue().get((Object)key) != null;
    }

    private StatusPublishEnum deletarCanceladoRedisKey(StatusRepublishDTO status) {
        String key = status.getKey() + "-CANCELADO";
        StatusRepublishDTO statusRecuperado = (StatusRepublishDTO)this.redisTemplate.opsForValue().getAndDelete((Object)key);
        return Optional.ofNullable(statusRecuperado).map(StatusRepublishDTO::getStatus).orElse(StatusPublishEnum.EXECUTANDO);
    }

    private List<Long> findToSincronizar(String search) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root root = query.from(ReflectionUtils.getClassParameterizedType(this.getClass(), (int)0));
        Specification spec = RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search, Optional.empty());
        query.select((Selection)root.get("id")).where((Expression)spec.toPredicate(root, query, builder));
        return this.entityManager.createQuery(query).getResultList();
    }

    private void sincronizacaoInterna(List<Long> ids, StatusRepublishDTO status) {
        List entidades = this.repository.findByIdIn(ids);
        int qtdLote = this.gerarQuantidadeTotalDoLote(status);
        entidades.forEach(entidade -> {
            StatusPublishEnum foundStatus = this.getRedisStatus(status.getKey());
            status.executar(foundStatus);
            try {
                this.service.internalReplicate(entidade);
                this.entityManager.flush();
                this.publisher.ifAvailable(publish -> publish.publish(OutboxActions.valueOf((String)CrudSavingStatus.UPDATED.name()), (EntityEvent)((EntityPublisher)entidade).convertToEvent().setIsLoteTrue()));
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                status.handleErro(ex, entidade.getId(), foundStatus);
                this.handleCommunication(status);
                throw new NoRollbackForException(ex.getMessage(), (Throwable)ex);
            }
            status.incrementAndGet();
            if (status.getQuantidadeExecutada() % qtdLote == 0) {
                this.handleCommunication(status);
            }
        });
    }

    private StatusPublishEnum getRedisStatus(String key) {
        Optional<StatusRepublishDTO> statusRepublishDTO = Optional.ofNullable((StatusRepublishDTO)this.redisTemplate.opsForValue().get((Object)(key + "-CANCELADO")));
        return statusRepublishDTO.isPresent() ? statusRepublishDTO.get().getStatus() : StatusPublishEnum.EXECUTANDO;
    }

    private void handleCommunication(StatusRepublishDTO status) {
        this.handleRedis(status);
        this.handleWebSocket(status);
    }

    private void handleRedis(StatusRepublishDTO status) {
        this.redisTemplate.opsForValue().set((Object)status.getKey(), (Object)status.atualizar(), 1L, TimeUnit.DAYS);
    }

    private TopicSocketDTO buildTopic(ExchangesEnum exchange) {
        return TopicSocketDTO.builder().topic(this.createKey(exchange.getNome())).build();
    }

    private void handleWebSocket(StatusRepublishDTO status) {
        String jsonPayload = this.objectMapper.writeValueAsString((Object)status);
        String topic = this.buildTopic(status.getExchange()).getTopic();
        WebSocketMessage webSocketMessage = WebSocketMessage.builder().topic(topic).payload(jsonPayload).build();
        this.notificationWebSocketFeign.webSocketMessage(webSocketMessage);
    }

    private int gerarQuantidadeTotalDoLote(StatusRepublishDTO status) {
        double qtdLote = (double)status.getQuantidadeTotal().intValue() * 0.01;
        return (int)Math.ceil(Math.min(qtdLote, 125.0));
    }

    @Generated
    public AbstractSincronizarService(ObjectProvider<Publisher> publisher, TransactionHandlerComponent transactionHandlerComponent, RedisTemplate<String, StatusRepublishDTO> redisTemplate, NotificationWebSocketFeign notificationWebSocketFeign, ObjectMapper objectMapper, EntityManager entityManager, UnicoCrudRepository<E, K> repository, UnicoCrudService<E, K> service) {
        this.publisher = publisher;
        this.transactionHandlerComponent = transactionHandlerComponent;
        this.redisTemplate = redisTemplate;
        this.notificationWebSocketFeign = notificationWebSocketFeign;
        this.objectMapper = objectMapper;
        this.entityManager = entityManager;
        this.repository = repository;
        this.service = service;
    }
}

