/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.oxy;

import br.com.elotech.di.service.UnidadeService;
import br.com.elotech.folhapagamento.client.LotacaoClient;
import br.com.elotech.folhapagamento.client.domain.PessoaLotacaoDTO;
import br.com.elotech.folhapagamento.client.domain.PessoaPertenceLotacaoDTO;
import br.com.elotech.folhapagamento.client.domain.PessoaUnidadePesquisaDTO;
import br.com.elotech.folhapagamento.client.domain.UnicoLotacaoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.UnidadeDTO;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"cloud"})
public class OxyUnidadeService
implements UnidadeService {
    private static final PageRequest DEFAULT_PAGINATION = PageRequest.of((int)0, (int)100);
    private final LotacaoClient lotacaoClient;

    public UnidadeDTO getByCodigo(String unidade, Long entidade) {
        UnicoLotacaoDTO lotacao = this.lotacaoClient.getLotacaoByCodigo(unidade, entidade);
        return this.convertUnicoLotacaoDTO(lotacao);
    }

    public UnidadeDTO getUnidadeFromUsuario(String cpfCnpj, Long entidade) {
        UnicoLotacaoDTO lotacao = this.lotacaoClient.getLotacaoByCpfPessoa(cpfCnpj, entidade);
        return this.convertUnicoLotacaoDTO(lotacao);
    }

    public Boolean usuarioPertenceAUnidade(String cpfCnpj, List<String> unidades, Long entidade) {
        PessoaPertenceLotacaoDTO dto = new PessoaPertenceLotacaoDTO();
        dto.setCpf(cpfCnpj);
        dto.setCodigosLotacao(unidades);
        return this.lotacaoClient.checkPessoaPertenceALotacao(dto, entidade);
    }

    public List<PessoaDTO> getUsuariosFromUnidade(String unidade, Long entidade) {
        return this.lotacaoClient.getPessoasFromLotacao(unidade, "", entidade, (Pageable)DEFAULT_PAGINATION).getContent().stream().map(arg_0 -> this.convertPessoaLotacaoDTO(arg_0)).collect(Collectors.toList());
    }

    public PessoaDTO getResponsavelFromUnidade(String unidade, Long entidade) {
        PessoaLotacaoDTO responsavel = this.lotacaoClient.getResponsavelFromLotacao(unidade, entidade);
        return this.convertPessoaLotacaoDTO(responsavel);
    }

    public List<UnidadeDTO> searchUnidades(String search, Long entidade) {
        String rsql = StringUtils.isBlank((String)search) ? search : String.format("codigoLotacao=='*%s*' or nome=='*%s*'", search, search);
        return this.lotacaoClient.searchLotacao(rsql, entidade, (Pageable)DEFAULT_PAGINATION).getContent().stream().map(arg_0 -> this.convertUnicoLotacaoDTO(arg_0)).collect(Collectors.toList());
    }

    public List<PessoaDTO> searchUsuariosInUnidades(String search, List<String> unidades, Long entidade) {
        PessoaUnidadePesquisaDTO pesquisaDTO = PessoaUnidadePesquisaDTO.builder().search(search).unidades(unidades).build();
        return this.lotacaoClient.searchPessoasVariasLotacoes(pesquisaDTO, entidade, (Pageable)DEFAULT_PAGINATION).getContent().stream().map(arg_0 -> this.convertPessoaLotacaoDTO(arg_0)).collect(Collectors.toList());
    }

    private PessoaDTO convertPessoaLotacaoDTO(PessoaLotacaoDTO pessoaLotacaoDTO) {
        PessoaDTO dto = new PessoaDTO();
        dto.setId(pessoaLotacaoDTO.getId());
        dto.setCnpjCpf(pessoaLotacaoDTO.getCpf());
        dto.setNome(pessoaLotacaoDTO.getNome());
        return dto;
    }

    private UnidadeDTO convertUnicoLotacaoDTO(UnicoLotacaoDTO lotacaoDTO) {
        UnidadeDTO unidadeDTO = new UnidadeDTO();
        unidadeDTO.setEntidade(lotacaoDTO.getEntidade());
        unidadeDTO.setLotacao(lotacaoDTO.getCodigoLotacao());
        unidadeDTO.setDescricao(lotacaoDTO.getNome());
        return unidadeDTO;
    }

    @Generated
    public OxyUnidadeService(LotacaoClient lotacaoClient) {
        this.lotacaoClient = lotacaoClient;
    }
}

