/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.common;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.dto.ExercicioInfo;
import br.com.elotech.core.common.dto.ModuloInfo;
import br.com.elotech.core.common.dto.UsuarioInfo;
import br.com.elotech.core.common.service.AppInfoService;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioLogado;
import br.com.elotech.di.repository.Usuarios;
import br.com.elotech.di.service.UsuarioLogadoService;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityNotFoundException;
import lombok.Generated;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AppInfoServiceImpl
implements AppInfoService {
    private final Usuarios usuarios;
    private final UsuarioLogadoService usuarioLogadoService;

    public UsuarioInfo getUserInfo(String username) {
        Usuario usuario = this.usuarios.findByUsuarioIgnoreCase(this.getPreferredUsername());
        if (Objects.isNull(usuario)) {
            UsuarioLogado usuarioLogado = this.usuarioLogadoService.getUsuarioLogado();
            if (Objects.isNull(usuarioLogado)) {
                throw new EntityNotFoundException("Usu\u00e1rio n\u00e3o encontrado!");
            }
            Usuario novoUsuario = new Usuario();
            novoUsuario.setUsuario(usuarioLogado.getUsername());
            novoUsuario.setAtivo(Boolean.valueOf(true));
            novoUsuario.setCpf(usuarioLogado.getCpf());
            novoUsuario.setNome(usuarioLogado.getNome());
            novoUsuario.setEmail(usuarioLogado.getEmail());
            this.usuarios.save((Object)novoUsuario);
            usuario = novoUsuario;
        }
        UsuarioInfo usuarioInfo = UsuarioInfo.newInstance().withUsername(usuario.getUsuario());
        usuario.getEntidades().forEach(entidade -> usuarioInfo.addEntidade(EntidadeInfo.newInstance().withDescricao(entidade.getEntidade().getNome()).withId(entidade.getEntidade().getId().longValue()).withPrincipal(entidade.getPrincipal())));
        usuario.getModulos().forEach(modulo -> usuarioInfo.addModulo(ModuloInfo.newInstance().withDescricao(modulo.getModulo().getDescricao()).withId(ModuloEnum.getByValue((String)modulo.getModulo().getId().toString()).getValue()).withPrincipal(modulo.getPrincipal())));
        return usuarioInfo;
    }

    public List<ExercicioInfo> getExercicioInfoList(Long entidadeId) {
        return Collections.emptyList();
    }

    private String getPreferredUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KeycloakAuthenticationToken) {
            KeycloakAuthenticationToken keycloakAuthenticationToken = (KeycloakAuthenticationToken)authentication;
            return keycloakAuthenticationToken.getAccount().getKeycloakSecurityContext().getToken().getPreferredUsername();
        }
        return authentication.getName();
    }

    @Generated
    public AppInfoServiceImpl(Usuarios usuarios, UsuarioLogadoService usuarioLogadoService) {
        this.usuarios = usuarios;
        this.usuarioLogadoService = usuarioLogadoService;
    }
}

