/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.aise;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.di.service.UnidadeService;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.UnidadeDTO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!cloud"})
public class AiseUnidadeService
implements UnidadeService {
    private static final String ENTIDADE = "entidade";
    private static final String MODELO = "modelo";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final DBConfigProperties dbConfigProperties;

    public UnidadeDTO getByCodigo(String unidade, Long entidade) {
        String sql = this.injectSchema("select l.entidade,  l.modelolotacao,  l.nivellotacao,  l.lotacao,  l.descricao,  case coalesce(l.ativo, '') when 'S' then 1 else 0 end as ativo  from $SCHEMA.rhlotacao l  where l.lotacao = :codigo  and l.modelolotacao = :modelo  and l.entidade = :entidade ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("codigo", (Object)unidade);
        params.addValue(ENTIDADE, (Object)entidade);
        params.addValue(MODELO, (Object)this.getModeloLotacaoAtual(entidade));
        List list = this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(UnidadeDTO.class));
        if (list.isEmpty()) {
            return null;
        }
        return (UnidadeDTO)list.get(0);
    }

    public UnidadeDTO getUnidadeFromUsuario(String cpfCnpj, Long entidade) {
        String sql = this.injectSchema("select l.entidade,  l.modelolotacao,  l.nivellotacao,  l.lotacao,  l.descricao,  case coalesce(l.ativo, '') when 'S' then 1 else 0 end as ativo  from $SCHEMA.rhlotacao l  inner join $SCHEMA.rhfuncionario rf     on l.entidade = rf.entidade            and l.modelolotacao = rf.modelolotacao            and l.nivellotacao = rf.nivellotacao            and l.lotacao = rf.lotacao  inner join $SCHEMA.pessoa p on rf.pessoa = p.pessoa  where p.cnpj_cpf = :cpf     and l.entidade = :entidade     and l.modelolotacao = :modelo     and p.inativo = 'N'");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cpf", (Object)cpfCnpj);
        params.addValue(MODELO, (Object)this.getModeloLotacaoAtual(entidade));
        params.addValue(ENTIDADE, (Object)entidade);
        List list = this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(UnidadeDTO.class));
        if (list.isEmpty()) {
            return null;
        }
        return (UnidadeDTO)list.get(0);
    }

    public Boolean usuarioPertenceAUnidade(String cpfCnpj, List<String> unidades, Long entidade) {
        if (unidades.isEmpty()) {
            return false;
        }
        String sql = this.injectSchema("select 1 as result  from dual  where exists(select *              from $SCHEMA.rhlotacao rl                       inner join $SCHEMA.rhfuncionario rf                                  on rl.entidade = rf.entidade                                      and rl.modelolotacao = rf.modelolotacao                                      and rl.nivellotacao = rf.nivellotacao                                      and rl.lotacao = rf.lotacao                       inner join $SCHEMA.pessoa rp on rf.pessoa = rp.pessoa              where rp.cnpj_cpf = :cpf                and rl.entidade = :entidade                and rl.modelolotacao = :modelo               and rl.lotacao in (:lotacao))");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("lotacao", unidades);
        params.addValue(MODELO, (Object)this.getModeloLotacaoAtual(entidade));
        params.addValue(ENTIDADE, (Object)entidade);
        params.addValue("cpf", (Object)cpfCnpj);
        return !this.jdbcTemplate.queryForList(sql, (SqlParameterSource)params, Boolean.class).isEmpty();
    }

    public List<PessoaDTO> getUsuariosFromUnidade(String unidade, Long entidade) {
        String sql = this.injectSchema("select p.pessoa as id,        p.nome as nome,        p.inativo as inativo,        p.cnpj_cpf as cnpjCpf  from $SCHEMA.pessoa p  inner join $SCHEMA.rhfuncionario rf on p.pessoa = rf.pessoa  where p.inativo = 'N'     and rf.entidade = :entidade    and rf.lotacao = :lotacao    and rf.modelolotacao = :modelo  order by p.pessoa ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("lotacao", (Object)unidade);
        params.addValue(MODELO, (Object)this.getModeloLotacaoAtual(entidade));
        params.addValue(ENTIDADE, (Object)entidade);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(PessoaDTO.class));
    }

    public PessoaDTO getResponsavelFromUnidade(String unidade, Long entidade) {
        String sql = this.injectSchema("select p.pessoa as id,        p.nome as nome,        p.inativo as inativo,        p.cnpj_cpf as cnpjCpf   from $SCHEMA.rhlotacaoresponsavel lr  inner join $SCHEMA.rhfuncionario rf     on lr.entidade = rf.entidade            and lr.matricula = rf.matricula  inner join $SCHEMA.pessoa  p on rf.pessoa = p.pessoa  where lr.entidade = :entidade    and lr.modelolotacao = :modelo    and lr.lotacao = :lotacao    and lr.iniciovalidade = (select max(iniciovalidade)                            from $SCHEMA.rhlotacaoresponsavel x                               where x.entidade = lr.entidade                                 and x.modelolotacao = lr.modelolotacao                                 and x.nivellotacao = lr.nivellotacao                                 and x.lotacao = lr.lotacao                                 and x.iniciovalidade <= :dataReferencia )");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("lotacao", (Object)unidade);
        params.addValue(MODELO, (Object)this.getModeloLotacaoAtual(entidade));
        params.addValue(ENTIDADE, (Object)entidade);
        params.addValue("dataReferencia", (Object)LocalDate.now());
        List result = this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(PessoaDTO.class));
        return result.stream().findFirst().orElse(null);
    }

    public List<UnidadeDTO> searchUnidades(String search, Long entidade) {
        String sql = this.injectSchema("select l.entidade,        l.modelolotacao,        l.nivellotacao,        l.lotacao,        l.descricao,        case coalesce(l.ativo, '') when 'S' then 1 else 0 end as ativo  from $SCHEMA.rhlotacao l  where (lower(l.lotacao) like '%' || :search || '%' or lower(l.descricao) like '%' || :search || '%')   and l.modelolotacao = :modelo   and l.entidade = :entidade  order by l.lotacao");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("search", (Object)search.toLowerCase());
        params.addValue(MODELO, (Object)this.getModeloLotacaoAtual(entidade));
        params.addValue(ENTIDADE, (Object)entidade);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(UnidadeDTO.class));
    }

    private Long getModeloLotacaoAtual(Long entidade) {
        int exercicio = LocalDate.now().getYear();
        String sql = this.injectSchema("select p.valor  from $SCHEMA.parametroentidadeexercicio p  where p.entidade = :entidade   and p.exercicio = :exercicio   and p.modulo = '01'   and p.parametro = 'MODELOLOTACAO'");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue(ENTIDADE, (Object)entidade);
        params.addValue("exercicio", (Object)exercicio);
        return (Long)this.jdbcTemplate.queryForList(sql, (SqlParameterSource)params, Long.class).stream().findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi pos\u00edvel encontrar o modelo de lota\u00e7\u00e3o ativo para a entidade %d no exercicio %d", entidade, exercicio)));
    }

    public List<PessoaDTO> searchUsuariosInUnidades(String search, List<String> unidades, Long entidade) {
        if (unidades.isEmpty()) {
            return new ArrayList<PessoaDTO>();
        }
        String sql = this.injectSchema("select p.pessoa as id,        p.nome as nome,        p.inativo as inativo,        p.cnpj_cpf as cnpjCpf  from $SCHEMA.pessoa p  inner join $SCHEMA.rhfuncionario rf on p.pessoa = rf.pessoa  where p.inativo = 'N'     and rf.entidade = :entidade    and rf.lotacao in (:unidades)    and rf.modelolotacao = :modelo    and lower(p.nome) like '%' || :search  || '%' order by p.pessoa ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("unidades", unidades);
        params.addValue("search", (Object)search.toLowerCase());
        params.addValue(MODELO, (Object)this.getModeloLotacaoAtual(entidade));
        params.addValue(ENTIDADE, (Object)entidade);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(PessoaDTO.class));
    }

    private String injectSchema(String originalQuery) {
        return originalQuery.replace("$SCHEMA", this.dbConfigProperties.getAise().getSchema());
    }

    @Generated
    public AiseUnidadeService(NamedParameterJdbcTemplate jdbcTemplate, DBConfigProperties dbConfigProperties) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbConfigProperties = dbConfigProperties;
    }
}

