/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.aise;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.di.domain.aise.AiseModulo;
import br.com.elotech.di.domain.aise.AiseRegistro;
import br.com.elotech.di.repository.aise.AiseRegistroRepository;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Service;

@Service
public class AiseRegistroService {
    private final EntityManager entityManager;
    private final AiseRegistroRepository repository;
    public static final long DIAS_TOLERANCIA = 90L;

    public AiseRegistroService(EntityManager entityManager, AiseRegistroRepository repository) {
        this.entityManager = entityManager;
        this.repository = repository;
    }

    public boolean isValid(ModuloEnum modulo, LocalDate data) {
        AiseModulo aiseModulo = (AiseModulo)this.entityManager.find(AiseModulo.class, (Object)modulo.getValue());
        if (Objects.nonNull(aiseModulo)) {
            AiseRegistro registro = this.repository.findFirstByIdModuloOrderByIdValidadeDesc(aiseModulo);
            return Objects.nonNull(registro) && this.isDataValida(data, registro);
        }
        return false;
    }

    private boolean isDataValida(LocalDate data, AiseRegistro registro) {
        LocalDate validade = registro.getId().getValidade().plusDays(90L);
        return validade.isAfter(data) || validade.equals(data);
    }
}

