/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service.aise;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.di.service.CargoService;
import br.com.elotech.unico.client.dto.CargoDTO;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class AiseCargoService
implements CargoService {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final DBConfigProperties dbConfigProperties;

    public CargoDTO getCargoByCpf(String cpf) {
        String originalSql = "select c.entidade, c.cargo, c.descricao  from $SCHEMA.rhfuncionario f  inner join $SCHEMA.rhcargo c on f.entidade = c.entidade and f.cargo = c.cargo  inner join $SCHEMA.pessoa p on f.pessoa = p.pessoa  where f.principal = 'S' and p.cnpj_cpf = :cpf";
        String sql = originalSql.replace("$SCHEMA", this.dbConfigProperties.getAise().getSchema());
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cpf", (Object)cpf);
        return (CargoDTO)this.jdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(CargoDTO.class)).stream().findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar cargo para a pessoa com o cpf %s", cpf)));
    }

    @Generated
    public AiseCargoService(NamedParameterJdbcTemplate jdbcTemplate, DBConfigProperties dbConfigProperties) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbConfigProperties = dbConfigProperties;
    }
}

