/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.TipoLeiEscopo;
import br.com.elotech.di.domain.VeiculoPublicacao;
import br.com.elotech.di.repository.LeiAtos;
import br.com.elotech.di.service.support.UnicoCrudService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class VeiculoPublicacaoService
extends UnicoCrudService<VeiculoPublicacao, Long> {
    @Autowired
    private LeiAtos leiAtos;

    protected void validateEntity(VeiculoPublicacao entity, Authentication authentication, List<EloViolation> violations) {
        this.validateLeiAto(entity, violations);
    }

    private void validateLeiAto(VeiculoPublicacao entity, List<EloViolation> violations) {
        LeiAto leiAto;
        if (entity.getLeiAto() != null && (leiAto = (LeiAto)this.leiAtos.findOne((Object)entity.getLeiAto().getId())).getTipoLeiEscopo() != null && !TipoLeiEscopo.ESCOPO_ORGAO_OFICIAL.equals(leiAto.getTipoLeiEscopo().getCodigo())) {
            violations.add(new EloViolation("Escopo da Lei n\u00e3o compat\u00edvel.", "Lei Ato:"));
        }
    }

    public List<VeiculoPublicacao> findAll(String search) {
        return this.getRepository().findAll(this.createSpecification(Optional.empty(), this.buildRsqlFilter(search)));
    }
}

