/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.di.batch.job.BatchContextHolder;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.UsuarioMerger;
import br.com.elotech.di.service.UsuarioService;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioUnificarService {
    private final UsuarioMerger usuarioMerger;
    private final JdbcTemplate jdbcTemplate;
    private final DBConfigProperties dbConfigProperties;
    private final UsuarioService usuarioService;

    public UsuarioUnificarService(UsuarioMerger usuarioMerger, JdbcTemplate jdbcTemplate, DBConfigProperties dbConfigProperties, UsuarioService usuarioService) {
        this.usuarioMerger = usuarioMerger;
        this.jdbcTemplate = jdbcTemplate;
        this.dbConfigProperties = dbConfigProperties;
        this.usuarioService = usuarioService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public Usuario unificar(String usuarioOriginal, String usuarioSelecionado) {
        List usuarios = this.usuarioService.findAllByUsuarioOriginal(usuarioOriginal);
        Usuario newUser = new Usuario();
        Optional<Usuario> userPrimary = StringUtils.isNotBlank((String)usuarioSelecionado) ? usuarios.stream().filter(usuario -> usuarioSelecionado.equals(usuario.getUsuario())).findFirst() : Optional.of((Usuario)usuarios.get(0));
        BeanUtils.copyProperties((Object)userPrimary.get(), (Object)newUser);
        usuarios.forEach(u -> this.usuarioMerger.merge(newUser, u));
        newUser.setId(null);
        newUser.setUsuario(newUser.getUsuarioOriginal());
        newUser.setInvalido(Boolean.FALSE);
        BatchContextHolder.started();
        try {
            this.usuarioService.getEm().persist((Object)newUser);
            this.fixUsuariosLegados(newUser, usuarios);
            usuarios.forEach(u -> this.usuarioService.delete((EloDomain)u));
            this.usuarioService.save((EloDomain)newUser);
        }
        finally {
            BatchContextHolder.stopped();
        }
        return newUser;
    }

    private void fixUsuariosLegados(Usuario newUser, List<Usuario> usuarios) {
        for (Usuario usuario : usuarios) {
            this.jdbcTemplate.update("Update " + this.dbConfigProperties.getAise().getSchema() + ".usuario set idunico = ? where idunico = ? and usuario = ?", new Object[]{newUser.getId(), usuario.getId(), usuario.getUsuarioOriginal()});
            this.jdbcTemplate.update("Update " + this.dbConfigProperties.getCompras().getSchema() + ".usuario set idunico = ? where idunico = ? and usuario = ?", new Object[]{newUser.getId(), usuario.getId(), usuario.getUsuarioOriginal()});
            this.jdbcTemplate.update("Update " + this.dbConfigProperties.getContabilidade().getSchema() + ".usuario set idunico = ? where idunico = ? and usuario = ?", new Object[]{newUser.getId(), usuario.getId(), usuario.getUsuarioOriginal()});
            this.jdbcTemplate.update("Update " + this.dbConfigProperties.getProtocolo().getSchema() + ".usuario set idunico = ? where idunico = ? and login1 = ?", new Object[]{newUser.getId(), usuario.getId(), usuario.getUsuarioOriginal()});
        }
    }
}

