/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioHorarioAcesso;
import br.com.elotech.di.service.DateTimeService;
import br.com.elotech.di.service.UsuarioService;
import java.time.LocalTime;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class UsuarioServiceValidate {
    private UsuarioService usuarioService;
    private DateTimeService dateTimeService = new DateTimeService();

    public UsuarioServiceValidate(UsuarioService usuarioService) {
        this.usuarioService = usuarioService;
    }

    private Boolean isTimeBetween(LocalTime theTime, LocalTime startTime, LocalTime endTime) {
        return theTime.isBefore(endTime) && theTime.isAfter(startTime);
    }

    public Boolean checkHorariosByUsername(String username) {
        Usuario usuario = this.usuarioService.findByUsuario(username);
        if (Objects.isNull(usuario) || usuario.getHorariosAcesso().isEmpty()) {
            return Boolean.TRUE;
        }
        int diaSemanaHoje = this.dateTimeService.dateNow().getDayOfWeek().getValue();
        Optional<UsuarioHorarioAcesso> horarios = usuario.getHorariosAcesso().stream().filter(dia -> dia.getDiaSemana().intValue() == diaSemanaHoje).findFirst();
        if (horarios.isPresent()) {
            LocalTime agora = this.dateTimeService.timeNow();
            return this.isTimeBetween(agora, horarios.get().getEntrada1(), horarios.get().getSaida1()) != false || !Objects.isNull(horarios.get().getEntrada2()) && this.isTimeBetween(agora, horarios.get().getEntrada2(), horarios.get().getSaida2()) != false;
        }
        return Boolean.FALSE;
    }

    @Generated
    public void setUsuarioService(UsuarioService usuarioService) {
        this.usuarioService = usuarioService;
    }

    @Generated
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

