/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.UsuarioEntidadeDTO;
import br.com.elotech.console.dto.UsuarioPayloadDTO;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.domain.support.UsuarioTrocaSenha;
import br.com.elotech.di.repository.Entidades;
import br.com.elotech.di.repository.Usuarios;
import br.com.elotech.di.service.PermissaoInicialService;
import br.com.elotech.di.service.UsuarioServiceValidate;
import br.com.elotech.di.service.support.UnicoCrudService;
import br.com.elotech.unico.client.dto.LoginDTO;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.keycloak.TokenVerifier;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UsuarioService
extends UnicoCrudService<Usuario, Long> {
    @Autowired
    private PermissaoInicialService permissaoInicialService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UnicoProperties unicoProperties;
    @Autowired
    private UsuarioClient usuarioClient;
    @Autowired
    private Entidades entidadeRepository;
    private final UsuarioServiceValidate validator = new UsuarioServiceValidate(this);

    private Usuarios getUsuarios() {
        return (Usuarios)this.getCrudRepository();
    }

    protected void beforeSave(Usuario entity, Authentication authentication) {
        if (entity.isNew()) {
            if (entity.getSenha() != null) {
                this.attrSenhaCriptografada(entity);
            }
            if (this.getUsuarios().existsSameUsuario(entity.getUsuario())) {
                throw new IllegalArgumentException("Usu\u00e1rio \"" + entity.getUsuario() + "\" j\u00e1 est\u00e1 em uso.");
            }
        }
        this.defineEntidadePrincipal(entity);
        super.beforeSave((EloDomain)entity, authentication);
    }

    private void attrSenhaCriptografada(Usuario entity) {
        entity.setSenha(this.passwordEncoder.encode((CharSequence)entity.getSenha()));
    }

    protected void validateEntity(Usuario entity, Authentication authentication, List<EloViolation> violations) {
        this.validateChangeTryChangePassword(entity, violations);
    }

    private void validateChangeTryChangePassword(Usuario entity, List<EloViolation> violations) {
        Usuario usuarioSaved;
        if (!entity.isNew() && (usuarioSaved = (Usuario)this.findOne((Serializable)entity.getId())) != null && usuarioSaved.getSenha() != null && !usuarioSaved.getSenha().equals(entity.getSenha())) {
            violations.add(new EloViolation("A senha s\u00f3 pode ser alterada no altera senha", "Senha:", "senha", Usuario.class));
        }
    }

    @Transactional
    public void trocaSenha(Long idUsuario, UsuarioTrocaSenha usuarioTrocaSenha) {
        this.internalTrocaSenha(idUsuario, usuarioTrocaSenha, true);
    }

    private void internalTrocaSenha(Long idUsuario, UsuarioTrocaSenha usuarioTrocaSenha, boolean validaSenhaAnterior) {
        Usuario usuarioLoad = (Usuario)this.findOne((Serializable)idUsuario);
        if (usuarioLoad == null) {
            throw new IllegalArgumentException(String.format("Usu\u00e1rio n\u00e3o encontrado com id %d.", idUsuario));
        }
        if (validaSenhaAnterior && !this.passwordEncoder.matches((CharSequence)usuarioTrocaSenha.getSenhaAtual(), usuarioLoad.getSenha())) {
            throw new EloValidationException("Senha atual n\u00e3o confere.", Collections.emptyList());
        }
        usuarioLoad.setSenha(usuarioTrocaSenha.getSenhaNova());
        this.attrSenhaCriptografada(usuarioLoad);
        if (Boolean.TRUE.equals(usuarioLoad.getSenhaExpirada())) {
            usuarioLoad.setSenhaExpirada(Boolean.valueOf(false));
            usuarioLoad.setDataExpiracao(null);
        }
        this.getCrudRepository().saveAndFlush((Object)usuarioLoad);
    }

    private void defineEntidadePrincipal(Usuario entity) {
        Usuario usuarioSaved = entity;
        if (!entity.isNew()) {
            usuarioSaved = (Usuario)this.findOne((Serializable)entity.getId());
        }
        if (usuarioSaved != null && !usuarioSaved.getEntidades().isEmpty()) {
            Optional<UsuarioEntidade> usuarioEntidade = usuarioSaved.getEntidades().stream().filter(entidade -> BooleanUtils.isTrue((Boolean)entidade.getPrincipal())).findFirst();
            if (!usuarioEntidade.isPresent()) {
                ((UsuarioEntidade)usuarioSaved.getEntidades().iterator().next()).setPrincipal(Boolean.TRUE);
            }
            this.getCrudRepository().saveAndFlush((Object)usuarioSaved);
        }
    }

    @Transactional
    public void defineSenha(Long idUsuario, String senha) {
        this.internalTrocaSenha(idUsuario, new UsuarioTrocaSenha(null, senha), false);
    }

    public Usuario findByUsuario(String usuario) {
        return this.getUsuarios().findByUsuarioIgnoreCase(usuario);
    }

    public List<Usuario> findAllByUsuarioOriginal(String usuarioOriginal) {
        return this.getUsuarios().findAllByUsuarioOriginalIgnoreCaseAndAtivoAndInvalido(usuarioOriginal, true, true);
    }

    public List<Modulo> findUsuarioModulos(String username) {
        Usuario usuario = this.findByUsuario(username);
        return usuario.getModulos().stream().map(UsuarioModulo::getModulo).collect(Collectors.toList());
    }

    public Optional<UsuarioEntidade> getUsuarioEntidadePadraoUsuario(String username) {
        List entidadesUsuario = this.getUsuarios().findByUsuarioIgnoreCase(username).getEntidades();
        Optional<UsuarioEntidade> entidadesPadrao = entidadesUsuario.stream().filter(UsuarioEntidade::getPrincipal).findFirst();
        if (entidadesPadrao.isPresent()) {
            return entidadesPadrao;
        }
        return entidadesUsuario.stream().findFirst();
    }

    public Optional<Entidade> getEntidadePadraoUsuario(String username) {
        Optional usuarioEntidadePadraoUsuario = this.getUsuarioEntidadePadraoUsuario(username);
        if (usuarioEntidadePadraoUsuario.isPresent()) {
            return Optional.of(((UsuarioEntidade)usuarioEntidadePadraoUsuario.get()).getEntidade());
        }
        return Optional.empty();
    }

    public String getUsernameByClass(Usuario usuario, Class<?> clazz) {
        return (String)this.getEm().createQuery(String.format("select id from %s where idUnico = :idUnico", clazz.getName()), String.class).setParameter("idUnico", (Object)usuario.getId()).getSingleResult();
    }

    public Usuario initializeTemplate(Authentication authentication) {
        Usuario usuario = new Usuario();
        usuario.getGrupos().add(Grupo.GRUPO_USUARIO);
        return usuario;
    }

    @Transactional(noRollbackFor={BadCredentialsException.class})
    public Usuario updateFailedLoginAttemptsByUsername(String username) {
        Usuario usuario = this.findByUsuario(username);
        if (Objects.nonNull(usuario)) {
            usuario.setFailedLoginAttempts(Long.valueOf(Optional.ofNullable(usuario.getFailedLoginAttempts()).orElse(0L) + 1L));
            if (usuario.getFailedLoginAttempts() >= this.unicoProperties.getFailedLoginAttempts()) {
                usuario.setContaBloqueada(Boolean.valueOf(true));
                usuario.setFailedLoginAttempts(Long.valueOf(0L));
                usuario.setMotivoContaBloqueada("N\u00famero m\u00e1ximo de tentativas de acesso atingido");
            }
        }
        return usuario;
    }

    public void clearFailedLoginAttemptsByUsername(String username) {
        Usuario usuario = this.findByUsuario(username);
        usuario.setFailedLoginAttempts(Long.valueOf(0L));
    }

    public String getMotivoUsuarioBloqueado(String username) {
        Usuario usuario = this.findByUsuario(username);
        return usuario.getMotivoContaBloqueada();
    }

    public Optional<Usuario> findByIdKeycloak(UUID idKeycloak) {
        return this.getUsuarios().findByIdKeycloak(idKeycloak);
    }

    public Usuario addUserByKeycloakLdap(AccessTokenResponse tokenResponse, LoginDTO loginDTO) throws VerificationException {
        AccessToken token = (AccessToken)TokenVerifier.create((String)tokenResponse.getToken(), AccessToken.class).getToken();
        UUID idKeycloak = UUID.fromString(token.getSubject());
        Usuario usuario = this.findByIdKeycloak(idKeycloak).orElse(new Usuario());
        String senhaAntiga = usuario.getSenha();
        usuario.setSenha(loginDTO.getPassword());
        if (usuario.getId() == null) {
            usuario.setEmail(token.getEmail());
            usuario.setUsuario(token.getPreferredUsername().concat("@elotech.com.br"));
            usuario.setIdKeycloak(idKeycloak);
            usuario.setNome(token.getName());
        } else {
            this.attrSenhaCriptografada(usuario);
        }
        if (!usuario.getSenha().equals(senhaAntiga)) {
            usuario = (Usuario)this.saveAndFlush((EloDomain)usuario);
        }
        this.permissaoInicialService.adicionarUsuarioModuloUnico(usuario.getId());
        this.permissaoInicialService.adicionarUsuarioEntidadeUnico(usuario.getId());
        this.permissaoInicialService.adicionarUsuarioRecursoUnico(usuario.getId());
        this.permissaoInicialService.adicionarPermissoesIniciais(usuario.getUsuario());
        return usuario;
    }

    public Optional<Usuario> findForKeycloak(UsuarioPayloadDTO payload) {
        return this.getUsuarios().findByIdKeycloak(payload.getId()).or(() -> this.getUsuarios().findByUsuario(payload.getUsername())).flatMap(u -> this.getUsuarios().findById((Object)u.getId()));
    }

    @Transactional
    public Usuario createOrUpdateUsuario(UsuarioPayloadDTO payload) {
        Usuario usuario = this.findForKeycloak(payload).orElseGet(() -> {
            this.getLog().debug("Usu\u00e1rio {} n\u00e3o encontrado para atualiza\u00e7\u00e3o. Iniciando cadastro de novo usu\u00e1rio.", (Object)payload.getUsername());
            return new Usuario();
        });
        UsuarioService.applyUpdates((Usuario)usuario, (UsuarioPayloadDTO)payload);
        usuario.getEntidades().removeIf(entidade -> payload.getUsuarioEntidade().stream().noneMatch(entidadeDTO -> entidade.getEntidade().getEntidadeConsole().equals(entidadeDTO.getEntidadeId())));
        payload.getUsuarioEntidade().forEach(entidadeDTO -> {
            UsuarioEntidade usuarioEntidade = usuario.getEntidades().stream().filter(ue -> ue.getEntidade().getEntidadeConsole().equals(entidadeDTO.getEntidadeId())).findFirst().orElseGet(() -> {
                this.getLog().debug("Entidade {} n\u00e3o encontrado para atualiza\u00e7\u00e3o. Iniciando cadastro de nova usuarioEntidade.", (Object)entidadeDTO.getEntidadeId());
                Entidade entidade = (Entidade)this.entidadeRepository.findByEntidadeConsole(entidadeDTO.getEntidadeId()).orElseThrow(() -> new IllegalArgumentException(String.format("Entidade %s, do Usuario %s, n\u00e3o encontrada.", entidadeDTO.getEntidadeId(), entidadeDTO.getUsuarioId())));
                UsuarioEntidade newEntidade = new UsuarioEntidade();
                newEntidade.setEntidade(entidade);
                usuario.getEntidades().add(newEntidade);
                return newEntidade;
            });
            this.applyUpdatesUsuarioEntidade(usuarioEntidade, entidadeDTO);
        });
        return (Usuario)this.saveAndFlush((EloDomain)usuario);
    }

    private void applyUpdatesUsuarioEntidade(UsuarioEntidade usuarioEntidade, UsuarioEntidadeDTO usuarioEntidadeDTO) {
        usuarioEntidade.setPrincipal(usuarioEntidadeDTO.getPadrao());
    }

    private static void applyUpdates(Usuario usuario, UsuarioPayloadDTO payload) {
        usuario.setIdKeycloak(payload.getId());
        usuario.setUsuario(payload.getUsername());
        usuario.setAtivo(payload.getAtivo());
        usuario.setEmail(payload.getEmail());
        usuario.setUsuarioOriginal(payload.getUsername());
        usuario.setNome(payload.getNomeCompleto());
        usuario.setCpf(payload.getUsername());
    }

    public Iterable<Usuario> findAllByHashStringIsNull() {
        return this.getUsuarios().findAllByHashStringIsNull();
    }

    public List<Entidade> findAllEntidadesByUsuario() {
        String uuidUsuario = this.getUUIDUsuarioByAuthentication(SecurityContextHolder.getContext().getAuthentication());
        List entidadesConsole = this.usuarioClient.findAllEntidadesByUsuario(uuidUsuario).stream().map(u -> u.getEntidade().getId()).collect(Collectors.toList());
        return this.entidadeRepository.findByEntidadeConsoleInOrderById(entidadesConsole);
    }

    private String getUUIDUsuarioByAuthentication(Authentication authentication) {
        if (authentication instanceof KeycloakAuthenticationToken) {
            return this.getAccessToken(authentication).getSubject();
        }
        return null;
    }

    private AccessToken getAccessToken(Authentication authentication) {
        KeycloakAuthenticationToken keycloakAuthenticationToken = (KeycloakAuthenticationToken)authentication;
        return keycloakAuthenticationToken.getAccount().getKeycloakSecurityContext().getToken();
    }

    @Generated
    public void setPermissaoInicialService(PermissaoInicialService permissaoInicialService) {
        this.permissaoInicialService = permissaoInicialService;
    }

    @Generated
    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Generated
    public void setUnicoProperties(UnicoProperties unicoProperties) {
        this.unicoProperties = unicoProperties;
    }

    @Generated
    public void setUsuarioClient(UsuarioClient usuarioClient) {
        this.usuarioClient = usuarioClient;
    }

    @Generated
    public void setEntidadeRepository(Entidades entidadeRepository) {
        this.entidadeRepository = entidadeRepository;
    }

    @Generated
    public UsuarioServiceValidate getValidator() {
        return this.validator;
    }
}

