/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.aise.AiseUsuarioSeletor;
import br.com.elotech.di.domain.apice.ApiceUsuarioSeletor;
import br.com.elotech.di.domain.protocolo.ProtocoloUsuarioSeletor;
import br.com.elotech.di.domain.siscop.SiscopUsuarioSeletor;
import br.com.elotech.di.resource.dto.UnicoUsuarioSeletorMapper;
import br.com.elotech.unico.client.dto.UsuarioSeletorDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class UsuarioSeletorService {
    private final EntityManager em;
    private final UnicoUsuarioSeletorMapper unicoUsuarioSeletorMapper;
    private final UnicoProperties unicoProperties;

    public List<UsuarioSeletorDTO> findUsuarioSeletorFavoritos(String usuario) {
        if (this.unicoProperties.getCloud().booleanValue()) {
            return Collections.emptyList();
        }
        List aiseSeletores = this.loadSeletores(AiseUsuarioSeletor.class, usuario);
        List apiceSeletores = this.loadSeletores(ApiceUsuarioSeletor.class, usuario);
        List siscopSeletores = this.loadSeletores(SiscopUsuarioSeletor.class, usuario);
        List protocoloSeletores = this.loadSeletores(ProtocoloUsuarioSeletor.class, usuario);
        ArrayList<UsuarioSeletorDTO> dtos = new ArrayList<UsuarioSeletorDTO>();
        dtos.addAll(aiseSeletores.stream().map(arg_0 -> ((UnicoUsuarioSeletorMapper)this.unicoUsuarioSeletorMapper).toUsuarioSeletorDTO(arg_0)).collect(Collectors.toList()));
        dtos.addAll(apiceSeletores.stream().map(arg_0 -> ((UnicoUsuarioSeletorMapper)this.unicoUsuarioSeletorMapper).toUsuarioSeletorDTO(arg_0)).collect(Collectors.toList()));
        dtos.addAll(siscopSeletores.stream().map(arg_0 -> ((UnicoUsuarioSeletorMapper)this.unicoUsuarioSeletorMapper).toUsuarioSeletorDTO(arg_0)).collect(Collectors.toList()));
        dtos.addAll(protocoloSeletores.stream().map(arg_0 -> ((UnicoUsuarioSeletorMapper)this.unicoUsuarioSeletorMapper).toUsuarioSeletorDTO(arg_0)).collect(Collectors.toList()));
        return dtos;
    }

    private <T> List<T> loadSeletores(Class<T> classType, String usuario) {
        StringBuilder query = new StringBuilder().append("FROM ").append(classType.getSimpleName()).append(" WHERE id.usuario.id = :usuario").append(" AND favorito = 'S'");
        return this.em.createQuery(query.toString(), classType).setParameter("usuario", (Object)usuario).getResultList();
    }

    @Generated
    public UsuarioSeletorService(EntityManager em, UnicoUsuarioSeletorMapper unicoUsuarioSeletorMapper, UnicoProperties unicoProperties) {
        this.em = em;
        this.unicoUsuarioSeletorMapper = unicoUsuarioSeletorMapper;
        this.unicoProperties = unicoProperties;
    }
}

