/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.console.client.ConsoleClient;
import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.console.dto.RolesUsuarioDTO;
import br.com.elotech.console.dto.UsuarioDTO;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.UsuarioLogado;
import br.com.elotech.di.exception.UsuarioNaoLogadoException;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.di.service.UsuarioLogadoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsuarioLogadoUnicoService
implements UsuarioLogadoService {
    private static final String SYSTEM_USER = "system_user";
    private final ConsoleClient consoleClient;
    private final EntidadeService entidadeService;
    private final UsuarioClient usuarioClient;

    public UsuarioLogado getUsuarioLogado() {
        AccessToken accessToken = (AccessToken)this.getAccessToken().orElseThrow(UsuarioNaoLogadoException::new);
        UsuarioDTO usuarioSistema = this.usuarioClient.findUsuarioById(UUID.fromString(accessToken.getSubject()));
        UsuarioLogado usuarioLogado = new UsuarioLogado();
        usuarioLogado.setId(usuarioSistema.getId());
        usuarioLogado.setAtivo(usuarioSistema.getAtivo());
        usuarioLogado.setCpf(usuarioSistema.getUsername());
        usuarioLogado.setUsername(usuarioSistema.getUsername());
        usuarioLogado.setNome(usuarioSistema.getNome());
        usuarioLogado.setSobrenome(usuarioSistema.getSobrenome());
        usuarioLogado.setEmail(usuarioSistema.getEmail());
        usuarioLogado.setNomeCompleto(usuarioSistema.getNomeCompleto());
        return usuarioLogado;
    }

    public String getIdUsuarioLogado() {
        return this.getAccessToken().map(JsonWebToken::getId).orElse("system_user");
    }

    public RolesUsuarioDTO getPermissoesUsuario() {
        AccessToken accessToken = (AccessToken)this.getAccessToken().orElseThrow(UsuarioNaoLogadoException::new);
        Entidade entidadeLogada = this.entidadeService.getObjetoEntidadeLogada();
        if (Objects.isNull(entidadeLogada.getEntidadeConsole())) {
            throw new IllegalStateException(String.format("A entidade %d - %s n\u00e3o possu\u00ed vinculo com a entidade do OXY Console. Entre em contato com a Elotech.", entidadeLogada.getId(), entidadeLogada.getNome()));
        }
        return this.usuarioClient.findAllRolesByUsuarioAndEntidadeAndModulo(UUID.fromString(accessToken.getSubject()), entidadeLogada.getEntidadeConsole(), Modulo.OXY_UNICO);
    }

    public Optional<AccessToken> getAccessToken() {
        return UsuarioLogadoUnicoService.getSecurityContext().map(KeycloakSecurityContext::getToken);
    }

    private static Optional<KeycloakSecurityContext> getSecurityContext() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(requestAttributes -> (KeycloakSecurityContext)requestAttributes.getAttribute(KeycloakSecurityContext.class.getName(), 0));
    }

    public Boolean isUsuarioIntegracaoGeoArquivos() {
        return UsuarioLogadoUnicoService.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-geo-arquivos")).map(Object::toString).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
    }

    public Optional<String> getTenantIntegracaoGeoArquivos() {
        return UsuarioLogadoUnicoService.getSecurityContext().map(KeycloakSecurityContext::getToken).map(JsonWebToken::getOtherClaims).map(claims -> claims.get("integracao-geo-arquivos-tenant")).map(Object::toString);
    }

    public Boolean isUsuarioIntegracaoOutrosSistemas() {
        return this.getAccessToken().map(JsonWebToken::getSubject).map(UUID::fromString).map(arg_0 -> ((UsuarioClient)this.usuarioClient).findUsuarioById(arg_0)).map(UsuarioDTO::getUsername).map(username -> username.startsWith("service-account")).orElse(Boolean.TRUE);
    }

    @Generated
    public UsuarioLogadoUnicoService(ConsoleClient consoleClient, EntidadeService entidadeService, UsuarioClient usuarioClient) {
        this.consoleClient = consoleClient;
        this.entidadeService = entidadeService;
        this.usuarioClient = usuarioClient;
    }
}

