/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaBaseDTO;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.Envelope;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SituacaoEnvelopeAssinatura;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SituacaoSolicitacaoAssinatura;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinatura;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinaturaArquivo;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinaturaPessoa;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.repository.Envelopes;
import br.com.elotech.di.repository.Pessoas;
import br.com.elotech.di.repository.SolicitacaoAssinaturaArquivos;
import br.com.elotech.di.service.UsuarioLogadoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class SolicitacaoAssinaturaService
extends CrudService<SolicitacaoAssinatura, Long> {
    private final UsuarioLogadoService usuarioLogadoService;
    private final Envelopes envelopeRepository;
    private final SolicitacaoAssinaturaArquivos solicitacaoAssinaturaArquivoRepository;
    private final Arquivos arquivoRepository;
    private final Pessoas pessoaRepository;

    protected void beforeSave(SolicitacaoAssinatura entity, Authentication authentication) {
        entity.getDestinatarios().forEach(d -> d.setSolicitacaoAssinatura(entity));
        Function<SolicitacaoAssinaturaArquivo, Boolean> finalValidaArquivo = Objects.isNull(entity.getId()) ? a -> !this.solicitacaoAssinaturaArquivoRepository.findByArquivoId(a.getArquivo().getId()).isEmpty() : a -> this.solicitacaoAssinaturaArquivoRepository.existsByArquivoIdAndSolicitacaoAssinaturaIdNot(a.getArquivo().getId(), a.getSolicitacaoAssinatura().getId());
        entity.getArquivos().forEach(a -> {
            a.setSolicitacaoAssinatura(entity);
            if (((Boolean)finalValidaArquivo.apply((SolicitacaoAssinaturaArquivo)a)).booleanValue()) {
                throw new IllegalArgumentException(String.format("Arquivo %s est\u00e1 sendo utilizado em outra solicita\u00e7\u00e3o.", a.getArquivo().getId()));
            }
        });
        super.beforeSave((EloEntity)entity, authentication);
    }

    protected void beforeInsert(SolicitacaoAssinatura entity) {
        String username = this.usuarioLogadoService.getUsuarioLogado().getUsername();
        entity.setUsername(username);
        entity.setDataSolicitacao(LocalDate.now());
        entity.setSituacao(SituacaoSolicitacaoAssinatura.ABERTA);
        super.beforeInsert((EloEntity)entity);
    }

    protected void beforeEdit(SolicitacaoAssinatura entity) {
        SolicitacaoAssinatura solicitacaoAssinatura = (SolicitacaoAssinatura)this.getRepository().findOne((Object)entity.getId());
        if (!solicitacaoAssinatura.isPendente()) {
            throw new IllegalArgumentException(String.format("A solicita\u00e7\u00e3o n\u00e3o pode ser editada pois encontra-se %s", solicitacaoAssinatura.getSituacao().getDescricao()));
        }
        entity.setUsername(solicitacaoAssinatura.getUsername());
        entity.setSituacao(solicitacaoAssinatura.getSituacao());
        entity.setDataSolicitacao(solicitacaoAssinatura.getDataSolicitacao());
        entity.getEnvelopes().clear();
        entity.getEnvelopes().addAll(solicitacaoAssinatura.getEnvelopes());
        super.beforeEdit((EloEntity)entity);
    }

    protected void beforeDelete(SolicitacaoAssinatura entity, Authentication authentication) {
        if (!entity.isPendente()) {
            throw new IllegalArgumentException(String.format("A solicita\u00e7\u00e3o n\u00e3o pode ser excluida pois encontra-se %s", entity.getSituacao().getDescricao()));
        }
        super.beforeDelete((EloEntity)entity, authentication);
    }

    public SolicitacaoAssinatura initializeTemplate(Authentication authentication) {
        SolicitacaoAssinatura solicitacaoAssinatura = new SolicitacaoAssinatura();
        String username = this.usuarioLogadoService.getUsuarioLogado().getUsername();
        solicitacaoAssinatura.setUsername(username);
        solicitacaoAssinatura.setDataSolicitacao(LocalDate.now());
        return solicitacaoAssinatura;
    }

    protected void afterSave(SolicitacaoAssinatura saved, Authentication authentication) {
        List envelopesValidosPorArquivo = this.deleteEnvelopesByArquivo(saved);
        saved.getEnvelopes().clear();
        saved.getEnvelopes().addAll(envelopesValidosPorArquivo);
        List envelopesValidosPorDestinatario = this.deleteEnvelopesByDestinatario(saved);
        saved.getEnvelopes().clear();
        saved.getEnvelopes().addAll(envelopesValidosPorDestinatario);
        List arquivoNovos = this.filterArquivosNovos(saved);
        List envelopes = this.createEnvelopesWithCurrentDestinatariosWithNewArquivos(saved, arquivoNovos);
        saved.getEnvelopes().addAll(envelopes);
        envelopes = this.createEnvelopesWithNewDestinatariosWithCurrentArquivos(saved);
        saved.getEnvelopes().addAll(envelopes);
        this.getEm().flush();
        super.afterSave((EloEntity)saved, authentication);
    }

    protected List<Arquivo> filterArquivosNovos(SolicitacaoAssinatura saved) {
        return saved.getArquivos().stream().filter(saa -> saved.getEnvelopes().stream().noneMatch(ev -> ev.getArquivo().equals((Object)saa.getArquivo()))).map(SolicitacaoAssinaturaArquivo::getArquivo).collect(Collectors.toList());
    }

    protected List<Envelope> createEnvelopesWithNewDestinatariosWithCurrentArquivos(SolicitacaoAssinatura saved) {
        ArrayList<Envelope> envelopes = new ArrayList<Envelope>();
        Set destinatariosNovos = saved.getDestinatarios().stream().filter(d -> saved.getEnvelopes().stream().noneMatch(e -> e.getDestinatario().equals((Object)d.getDestinatario()))).map(SolicitacaoAssinaturaPessoa::getDestinatario).collect(Collectors.toSet());
        saved.getEnvelopes().stream().map(Envelope::getArquivo).collect(Collectors.toSet()).forEach(arquivo -> destinatariosNovos.forEach(d -> {
            Envelope envelope = new Envelope();
            envelope.setDestinatario(d);
            envelope.setSituacao(SituacaoEnvelopeAssinatura.PENDENTE);
            envelope.setSolicitacaoAssinatura(saved);
            envelope.setArquivo(arquivo);
            envelopes.add(envelope);
        }));
        this.envelopeRepository.saveAll(envelopes);
        return envelopes;
    }

    protected List<Envelope> createEnvelopesWithCurrentDestinatariosWithNewArquivos(SolicitacaoAssinatura saved, List<Arquivo> arquivoNovos) {
        ArrayList envelopes = new ArrayList();
        Set<Pessoa> destinatariosAtual = saved.getEnvelopes().stream().map(Envelope::getDestinatario).collect(Collectors.toSet());
        if (destinatariosAtual.isEmpty()) {
            destinatariosAtual = saved.getDestinatarios().stream().map(SolicitacaoAssinaturaPessoa::getDestinatario).collect(Collectors.toSet());
        }
        destinatariosAtual.forEach(d -> arquivoNovos.forEach(arquivo -> {
            Envelope envelope = new Envelope();
            envelope.setDestinatario(d);
            envelope.setSituacao(SituacaoEnvelopeAssinatura.PENDENTE);
            envelope.setSolicitacaoAssinatura(saved);
            envelope.setArquivo(arquivo);
            envelopes.add(envelope);
        }));
        return this.envelopeRepository.saveAll(envelopes);
    }

    protected List<Envelope> deleteEnvelopesByDestinatario(SolicitacaoAssinatura saved) {
        List<Envelope> envelopesValidosPorDestinatario = saved.getEnvelopes().stream().filter(e -> saved.getDestinatarios().stream().anyMatch(d -> d.getDestinatario().equals((Object)e.getDestinatario()))).collect(Collectors.toList());
        saved.getEnvelopes().stream().filter(e -> envelopesValidosPorDestinatario.stream().noneMatch(ev -> ev.getId().equals(e.getId()))).forEach(arg_0 -> ((Envelopes)this.envelopeRepository).delete(arg_0));
        return envelopesValidosPorDestinatario;
    }

    protected List<Envelope> deleteEnvelopesByArquivo(SolicitacaoAssinatura saved) {
        List<Envelope> envelopesValidosPorArquivo = saved.getEnvelopes().stream().filter(envelope -> saved.getArquivos().stream().anyMatch(a -> a.getArquivo().equals((Object)envelope.getArquivo()))).collect(Collectors.toList());
        saved.getEnvelopes().stream().filter(e -> envelopesValidosPorArquivo.stream().noneMatch(ev -> ev.getId().equals(e.getId()))).forEach(arg_0 -> ((Envelopes)this.envelopeRepository).delete(arg_0));
        return envelopesValidosPorArquivo;
    }

    public SolicitacaoAssinatura createOnDemandForCurrentUser(AssinaturaBaseDTO dto) {
        if (Objects.nonNull(dto.getIdEnvelope())) {
            throw new IllegalArgumentException(String.format("J\u00e1 possui um envelope. Envelope %s.", dto.getIdEnvelope()));
        }
        this.validarArquivoEmUsoEmOutraSolicitacao(dto.getIdArquivo());
        Arquivo arquivo = (Arquivo)this.arquivoRepository.findById((Object)dto.getIdArquivo()).orElseThrow(() -> new IllegalArgumentException("Arquivo informado n\u00e3o existe."));
        String username = this.usuarioLogadoService.getUsuarioLogado().getUsername();
        Pessoa pessoa = (Pessoa)this.pessoaRepository.findByCnpjCpf(username).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Usu\u00e1rio logado n\u00e3o est\u00e1 cadastrado como Pessoa."));
        SolicitacaoAssinatura solicitacaoAssinatura = new SolicitacaoAssinatura();
        solicitacaoAssinatura.setDescricao(String.format("Gerada pelo sistema durante a assinatura do arquivo '%s'.", dto.getIdArquivo()));
        SolicitacaoAssinaturaArquivo solicitacaoAssinaturaArquivo = new SolicitacaoAssinaturaArquivo();
        solicitacaoAssinaturaArquivo.setSolicitacaoAssinatura(solicitacaoAssinatura);
        solicitacaoAssinaturaArquivo.setArquivo(arquivo);
        solicitacaoAssinatura.getArquivos().add(solicitacaoAssinaturaArquivo);
        SolicitacaoAssinaturaPessoa solicitacaoAssinaturaPessoa = new SolicitacaoAssinaturaPessoa();
        solicitacaoAssinaturaPessoa.setSolicitacaoAssinatura(solicitacaoAssinatura);
        solicitacaoAssinaturaPessoa.setDestinatario(pessoa);
        solicitacaoAssinatura.getDestinatarios().add(solicitacaoAssinaturaPessoa);
        SolicitacaoAssinatura saved = (SolicitacaoAssinatura)this.save((EloEntity)solicitacaoAssinatura, null);
        this.getEm().refresh((Object)saved);
        return saved;
    }

    public void validarArquivoEmUsoEmOutraSolicitacao(Long idArquivo) {
        List list = this.solicitacaoAssinaturaArquivoRepository.findByArquivoId(idArquivo);
        if (!list.isEmpty()) {
            throw new IllegalArgumentException(String.format("Arquivo %s est\u00e1 sendo utilizado na solicita\u00e7\u00e3o [%s]", idArquivo, String.join((CharSequence)", ", list.stream().filter(solicitacao -> Objects.nonNull(solicitacao.getId())).map(solicitacao -> solicitacao.getId().toString()).collect(Collectors.toList()))));
        }
    }

    @Generated
    public SolicitacaoAssinaturaService(UsuarioLogadoService usuarioLogadoService, Envelopes envelopeRepository, SolicitacaoAssinaturaArquivos solicitacaoAssinaturaArquivoRepository, Arquivos arquivoRepository, Pessoas pessoaRepository) {
        this.usuarioLogadoService = usuarioLogadoService;
        this.envelopeRepository = envelopeRepository;
        this.solicitacaoAssinaturaArquivoRepository = solicitacaoAssinaturaArquivoRepository;
        this.arquivoRepository = arquivoRepository;
        this.pessoaRepository = pessoaRepository;
    }
}

