/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.di.converter.MapToByte;
import br.com.elotech.di.converter.ReportToMap;
import br.com.elotech.di.domain.Report;
import br.com.elotech.di.domain.ReportArquivo;
import br.com.elotech.di.domain.ReportJoinField;
import br.com.elotech.di.dto.ReportExecutionRequest;
import br.com.elotech.di.exception.ReportException;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.service.FileIntegrationService;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.Dataset;
import br.com.elotech.fluent.dataset.SimpleDataset;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.report.EloReportBuilder;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.unico.client.domain.UsuarioDatasetRecord;
import br.com.elotech.unico.client.domain.UsuarioModuloDatasetRecord;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ReportService
extends CrudService<Report, Long> {
    private static final Logger LOGGGER = LoggerFactory.getLogger(ReportService.class);
    private final ReportToMap toMap;
    private final Arquivos arquivos;
    private final FileIntegrationService fileIntegrationService;
    private final NamedParameterJdbcTemplate jdbcNamedTemplate;
    private static final String USUARIO_MODULO_DATASET = "ModulosPorUsuario";
    private static final String USUARIO_MODULO_DATASET_MODULO = "ModulosPorUsuarioModulo";
    public static final String USUARIO_MODULO_RPT = "ModulosPorUsuario.rpt";
    private static final String USUARIO_MODULO_SQL = "sql/modulosporusuario-usuarios.sql";
    private static final String USUARIO_MODULO_MODULOS_SQL = "sql/modulosporusuario-modulos.sql";
    private final ReportFileResolverFactory reportFileResolverFactory;

    public byte[] impressaoAnexo(Long reportId, ReportExecutionRequest request, Pageable pageable) {
        Report found = (Report)this.findOne((Serializable)reportId);
        request.setReport(found);
        List data = this.toMap.apply(request, pageable);
        ArrayList createdFiles = new ArrayList();
        EloReportBuilder reportBuilder = EloReportFactory.jasper().reportFile(() -> {
            try {
                createdFiles.addAll(this.fileIntegrationService.downloadReport(found));
            }
            catch (IOException e) {
                LOGGGER.error("Erro ao baixar arquivos(FileIntegrationService)", (Throwable)e);
            }
            if (createdFiles.isEmpty()) {
                return null;
            }
            return (File)createdFiles.get(0);
        });
        return new MapToByte(request.getEntidade(), reportBuilder).apply(data);
    }

    public byte[] impressaoAnexo(Long reportId, Pageable pageable) {
        ReportExecutionRequest request = new ReportExecutionRequest();
        return this.impressaoAnexo(reportId, request, pageable);
    }

    public byte[] impressaoUsuariosModulos(String nome, String usuario, String ativo, Long modulo) {
        StringBuilder where = new StringBuilder();
        String moduloFiltrado = "";
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (Objects.nonNull(nome)) {
            where.append(" and tiraacento(upper(u.nome)) like upper('%' || tiraacento(:nome) || '%') ");
            params.addValue("nome", (Object)nome);
        }
        if (Objects.nonNull(usuario)) {
            where.append(" and tiraacento(upper(u.usuario)) like upper('%' || tiraacento(:usuario) || '%') ");
            params.addValue("usuario", (Object)usuario);
        }
        if (Objects.nonNull(ativo) && !ativo.equals("")) {
            where.append(" and upper(u.ativo) = upper(:ativo) ");
            params.addValue("ativo", (Object)ativo);
        }
        if (Objects.nonNull(modulo)) {
            where.append(" and um.modulo = :modulo ");
            params.addValue("modulo", (Object)modulo);
            moduloFiltrado = "S";
        }
        String sqlUsuario = FileUtils.readResourceAsString((String)USUARIO_MODULO_SQL) + String.valueOf(where);
        String sqlModulos = FileUtils.readResourceAsString((String)USUARIO_MODULO_MODULOS_SQL) + String.valueOf(where);
        SimpleDataset dsUsuarios = SimpleDataset.of((List)this.jdbcNamedTemplate.query(sqlUsuario, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(UsuarioDatasetRecord.class)), UsuarioDatasetRecord.class);
        SimpleDataset dsModulos = SimpleDataset.of((List)this.jdbcNamedTemplate.query(sqlModulos, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(UsuarioModuloDatasetRecord.class)), UsuarioModuloDatasetRecord.class);
        ReportDatasource datasource = ReportDatasource.builder().add(USUARIO_MODULO_DATASET, () -> ReportService.lambda$impressaoUsuariosModulos$1((Dataset)dsUsuarios)).add(USUARIO_MODULO_DATASET_MODULO, () -> ReportService.lambda$impressaoUsuariosModulos$2((Dataset)dsModulos)).param(Param.of((String)"ModuloFiltrado", (Object)moduloFiltrado)).build();
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(USUARIO_MODULO_RPT)).setReportDatasource(datasource).build().exportToPdf();
    }

    protected void beforeSave(Report entity, Authentication authentication) {
        entity.getJoinFields().forEach(jf -> {
            this.verificarIntegridade(jf);
            jf.setReport(entity);
        });
        this.loadReportsArquivo(entity);
        this.validateRelatorioParent(entity);
        super.beforeSave((EloEntity)entity, authentication);
    }

    private void verificarIntegridade(ReportJoinField jf) {
        String rf;
        String pm = Objects.isNull(jf.getParentField()) ? "ParentField" : "";
        String mensagem = Arrays.asList(pm, rf = Objects.isNull(jf.getReportField()) ? "ReportField" : "").stream().filter(s -> !s.isEmpty()).collect(Collectors.joining(", "));
        if (!mensagem.isEmpty()) {
            throw new IllegalArgumentException("Os campos n\u00e3o foram informados -> " + mensagem);
        }
    }

    void validateRelatorioParent(Report report) {
        if (Objects.nonNull(report.getMainReport())) {
            ArrayList<String> messages = new ArrayList<String>();
            if (report.getJoinFields().isEmpty()) {
                messages.add("N\u00e3o foi informado um JoinField");
            }
            if (!messages.isEmpty()) {
                throw new ReportException(String.join((CharSequence)", ", messages));
            }
        }
        if (!report.getSubReport().isEmpty()) {
            report.getSubReport().forEach(arg_0 -> this.validateRelatorioParent(arg_0));
        }
    }

    private void loadReportsArquivo(Report report) {
        report.getArquivos().forEach(a -> a.setReport(report));
        report.getArquivos().forEach(arg_0 -> this.loadArquivo(arg_0));
        if (!report.getSubReport().isEmpty()) {
            report.getSubReport().forEach(arg_0 -> this.loadReportsArquivo(arg_0));
        }
    }

    private void loadArquivo(ReportArquivo reportArquivo) {
        Long idArquivo = reportArquivo.getArquivo().getId();
        if (Objects.nonNull(idArquivo)) {
            this.arquivos.findById((Object)idArquivo).ifPresent(arg_0 -> ((ReportArquivo)reportArquivo).setArquivo(arg_0));
        }
    }

    public Arquivo saveJasperFile(ArquivoNovoRequest request) {
        return this.fileIntegrationService.saveFile(request);
    }

    @Generated
    public ReportService(ReportToMap toMap, Arquivos arquivos, FileIntegrationService fileIntegrationService, NamedParameterJdbcTemplate jdbcNamedTemplate, ReportFileResolverFactory reportFileResolverFactory) {
        this.toMap = toMap;
        this.arquivos = arquivos;
        this.fileIntegrationService = fileIntegrationService;
        this.jdbcNamedTemplate = jdbcNamedTemplate;
        this.reportFileResolverFactory = reportFileResolverFactory;
    }

    private static /* synthetic */ Object lambda$impressaoUsuariosModulos$2(Dataset dsModulos) {
        return dsModulos;
    }

    private static /* synthetic */ Object lambda$impressaoUsuariosModulos$1(Dataset dsUsuarios) {
        return dsUsuarios;
    }
}

