/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.di.domain.ResultDTO;
import br.com.elotech.di.domain.ResultMetaDataDTO;
import br.com.elotech.di.domain.datasource.DataSourceType;
import br.com.elotech.di.domain.datasource.QueryExecutorFactory;
import br.com.elotech.di.domain.query.AbstractQuery;
import br.com.elotech.di.domain.query.OrderedField;
import br.com.elotech.di.domain.query.QueryField;
import br.com.elotech.di.domain.query.QueryResult;
import br.com.elotech.di.domain.query.param.JDBCQueryFilter;
import br.com.elotech.di.exception.QueryExecutionException;
import br.com.elotech.di.exception.RuntimeQueryExecutionException;
import br.com.elotech.di.repository.QueryFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class QueryService
extends CrudService<AbstractQuery, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryService.class);
    private final QueryExecutorFactory executorFactory;
    private final QueryFields queryFieldRepository;

    public ResultDTO consultar(AbstractQuery query, Pageable page) {
        Page execute;
        try {
            execute = this.executorFactory.execute(query, page);
        }
        catch (QueryExecutionException e) {
            LOGGER.info("Erro ao executar query", (Throwable)e);
            ResultDTO result = new ResultDTO((Page)new PageImpl(Collections.emptyList()));
            result.getErrors().add(e.toString());
            if (Objects.nonNull(e.getCause())) {
                result.getErrors().add(e.getCause().getMessage());
            }
            return result;
        }
        return this.criarResultado(execute);
    }

    private ResultDTO criarResultado(Page<List<QueryResult>> execute) {
        ArrayList result = new ArrayList();
        TreeSet<ResultMetaDataDTO> metadata = new TreeSet<ResultMetaDataDTO>(Comparator.comparing(ResultMetaDataDTO::getField));
        for (List linha : execute) {
            TreeMap<OrderedField, Object> record = new TreeMap<OrderedField, Object>(Comparator.comparing(OrderedField::hashCode));
            for (QueryResult qr : linha) {
                record.put(qr.getOrderedField(), qr.getValue());
                metadata.add(new ResultMetaDataDTO(qr.getOrderedField(), qr.getType().name()));
            }
            result.add(record);
        }
        PageImpl newPage = new PageImpl(result, execute.getPageable(), execute.getTotalElements());
        return new ResultDTO((Page)newPage, new ArrayList<ResultMetaDataDTO>(metadata));
    }

    protected void beforeSave(AbstractQuery saved, Authentication authentication) {
        List camposGerados = this.gerarCampos(saved);
        saved.addFields(camposGerados);
        this.validarCaptionDuplicado(saved);
        this.queryFieldRepository.saveAll((Iterable)saved.getFields());
        saved.getFields().parallelStream().forEach(f -> f.setQuery(saved));
        boolean isJDBC = DataSourceType.JDBC.equals((Object)saved.getType());
        saved.getFilters().parallelStream().forEach(p -> {
            if (isJDBC) {
                JDBCQueryFilter filter = (JDBCQueryFilter)p;
                this.findSameField(filter.getField(), saved.getFields()).ifPresent(arg_0 -> ((JDBCQueryFilter)filter).setField(arg_0));
            }
            p.setQuery(saved);
        });
        super.beforeSave((EloEntity)saved, authentication);
    }

    private Optional<QueryField> findSameField(QueryField field, List<QueryField> camposGerados) {
        return camposGerados.parallelStream().filter(c -> c.getName().equals(field.getName()) && c.getAlias().equals(field.getAlias())).findFirst();
    }

    private void validarCaptionDuplicado(AbstractQuery saved) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (QueryField field : saved.getFields()) {
            String caption = field.getCaption();
            if (map.containsKey(caption)) {
                map.put(caption, (Integer)map.get(caption) + 1);
                continue;
            }
            map.put(caption, 1);
        }
        String message = map.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(e -> String.format("O caption esta duplicado (%s)", e.getKey())).collect(Collectors.joining(","));
        if (!StringUtils.isEmpty((CharSequence)message)) {
            throw new RuntimeQueryExecutionException("Existem captions duplicados -> " + message);
        }
    }

    public Boolean testarHost(String host) {
        return this.executorFactory.testarHost(host);
    }

    public List<QueryField> gerarCampos(AbstractQuery query) {
        try {
            return this.executorFactory.gerarCampos(query).parallelStream().map(QueryField::of).collect(Collectors.toList());
        }
        catch (QueryExecutionException e) {
            LOGGER.info("Erro ao executar query", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Generated
    public QueryService(QueryExecutorFactory executorFactory, QueryFields queryFieldRepository) {
        this.executorFactory = executorFactory;
        this.queryFieldRepository = queryFieldRepository;
    }
}

