/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.service.support.CrudServiceException;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.service.PessoaServiceValidateModulo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PessoaServiceValidateModulo {
    private static final Set<String> BASE_NOT_ALLOWED = new HashSet<String>(Arrays.asList("/nome", "/cnpjCpf", "/tipoPessoa", "/inativo"));
    private static final String PROTOCOLO = "/protocolo";
    private static final String FORNECEDOR = "/fornecedor";
    private static final String CONTRIBUINTE = "/contribuinte";
    private static final String PESSOAL = "/pessoal";
    private final Map<String, List<ModuloEnum>> flagAllowChanges;
    private final Map<String, List<ModuloEnum>> flagBaseAllowChanges;
    @Value(value="${elotech.pessoaEnderecoFolha.enabled:false}")
    private Boolean enderecoAlteradoPeloRH;
    @Value(value="${elotech.unico.validateModulos:true}")
    private Boolean validateModulos = Boolean.TRUE;

    public void setEnderecoAlteradoPeloRH(Boolean value) {
        this.enderecoAlteradoPeloRH = value;
    }

    public PessoaServiceValidateModulo() {
        this.flagAllowChanges = new HashMap();
        this.flagAllowChanges.put(PESSOAL, Arrays.asList(ModuloEnum.MODULO_RH));
        this.flagAllowChanges.put(CONTRIBUINTE, Arrays.asList(ModuloEnum.MODULO_TRIBUTARIO, ModuloEnum.MODULO_COMPRAS));
        this.flagAllowChanges.put(PROTOCOLO, Arrays.asList(ModuloEnum.MODULO_PROTOCOLO));
        this.flagAllowChanges.put(FORNECEDOR, Arrays.asList(ModuloEnum.MODULO_SISCOP, ModuloEnum.MODULO_TESOURARIA, ModuloEnum.MODULO_COMPRAS, ModuloEnum.MODULO_FROTAS, ModuloEnum.MODULO_ALMOXARIFADO, ModuloEnum.MODULO_PATRIMONIO, ModuloEnum.MODULO_OBRAS));
        this.flagBaseAllowChanges = new HashMap();
        this.flagBaseAllowChanges.put(PESSOAL, Arrays.asList(ModuloEnum.MODULO_RH));
        this.flagBaseAllowChanges.put(CONTRIBUINTE, Arrays.asList(ModuloEnum.MODULO_TRIBUTARIO, ModuloEnum.MODULO_COMPRAS, ModuloEnum.MODULO_SISCOP, ModuloEnum.MODULO_RH));
        this.flagBaseAllowChanges.put(FORNECEDOR, Arrays.asList(ModuloEnum.MODULO_SISCOP, ModuloEnum.MODULO_TESOURARIA, ModuloEnum.MODULO_COMPRAS, ModuloEnum.MODULO_FROTAS, ModuloEnum.MODULO_ALMOXARIFADO, ModuloEnum.MODULO_PATRIMONIO, ModuloEnum.MODULO_OBRAS, ModuloEnum.MODULO_TRIBUTARIO, ModuloEnum.MODULO_RH));
    }

    public void valid(Pessoa pessoaBeforeChange, ModuloEnum modulo, List<String> changes) {
        Optional notAllowed;
        if (!this.validateModulos.booleanValue()) {
            return;
        }
        this.validateFlagChanges(changes, modulo);
        if (this.hasChangeBeyoundFlags(changes) && (notAllowed = this.hasNotAllowedChanges(pessoaBeforeChange, modulo, changes)).isPresent()) {
            List paths = ((NotAllowed)notAllowed.get()).paths.stream().filter(p -> changes.stream().anyMatch(c -> c.contains((CharSequence)p))).collect(Collectors.toList());
            CrudServiceException.throwExceptionViolations(Arrays.asList(new EloViolation(String.format("Altera\u00e7\u00f5es em %s permitidas somente no m\u00f3dulo %s", paths, ((NotAllowed)notAllowed.get()).getModuloEnum().getDescricao()))));
        }
    }

    private Optional<NotAllowed> hasNotAllowedChanges(Pessoa pessoaBeforeChange, ModuloEnum modulo, List<String> changes) {
        ArrayList<NotAllowed> calculatedAlllowedChanges = new ArrayList<NotAllowed>();
        if (pessoaBeforeChange.getPessoal().booleanValue() && !((List)this.flagBaseAllowChanges.get(PESSOAL)).contains(modulo)) {
            calculatedAlllowedChanges.add(new NotAllowed(ModuloEnum.MODULO_RH, BASE_NOT_ALLOWED));
        } else if (pessoaBeforeChange.getContribuinte().booleanValue() && !((List)this.flagBaseAllowChanges.get(CONTRIBUINTE)).contains(modulo)) {
            calculatedAlllowedChanges.add(new NotAllowed(ModuloEnum.MODULO_TRIBUTARIO, BASE_NOT_ALLOWED));
        } else if (pessoaBeforeChange.getFornecedor().booleanValue() && !((List)this.flagBaseAllowChanges.get(FORNECEDOR)).contains(modulo)) {
            calculatedAlllowedChanges.add(new NotAllowed(ModuloEnum.MODULO_SISCOP, BASE_NOT_ALLOWED));
        }
        this.addNotAllowedChanges(pessoaBeforeChange, pessoaBeforeChange.getProtocolo(), modulo, calculatedAlllowedChanges, PROTOCOLO);
        this.addNotAllowedChanges(pessoaBeforeChange, pessoaBeforeChange.getContribuinte(), modulo, calculatedAlllowedChanges, CONTRIBUINTE);
        this.addNotAllowedChanges(pessoaBeforeChange, pessoaBeforeChange.getPessoal(), modulo, calculatedAlllowedChanges, PESSOAL);
        this.addNotAllowedChanges(pessoaBeforeChange, pessoaBeforeChange.getFornecedor(), modulo, calculatedAlllowedChanges, FORNECEDOR);
        return calculatedAlllowedChanges.stream().filter(i -> i.paths.stream().anyMatch(p -> changes.stream().anyMatch(c -> c.startsWith((String)p)))).findFirst();
    }

    private void addNotAllowedChanges(Pessoa pessoa, Boolean flag, ModuloEnum modulo, List<NotAllowed> calculatedAlllowedChanges, String flagKey) {
        Map notAllowedChanges = this.getNotAllowChangesByType(pessoa);
        if (flag.booleanValue() && notAllowedChanges.containsKey(flagKey) && !((List)this.flagAllowChanges.get(flagKey)).contains(modulo)) {
            calculatedAlllowedChanges.add(new NotAllowed((ModuloEnum)((List)this.flagAllowChanges.get(flagKey)).get(0), (Set)notAllowedChanges.get(flagKey)));
        }
    }

    private Map<String, Set<String>> getNotAllowChangesByType(Pessoa pessoa) {
        HashMap<String, Set<String>> notAllowChangesByType = new HashMap<String, Set<String>>();
        if (this.enderecoAlteradoPeloRH.booleanValue() && pessoa.getPessoal().booleanValue()) {
            notAllowChangesByType.put(PESSOAL, new HashSet<String>(Arrays.asList("/rh", "/bancosPessoa", "/pis", "/rg", "/enderecos")));
            notAllowChangesByType.put(CONTRIBUINTE, new HashSet<String>(Arrays.asList("/ramoAtividades")));
        } else {
            notAllowChangesByType.put(PESSOAL, new HashSet<String>(Arrays.asList("/rh", "/bancosPessoa", "/pis", "/rg")));
            notAllowChangesByType.put(CONTRIBUINTE, new HashSet<String>(Arrays.asList("/enderecos", "/ramoAtividades")));
        }
        return notAllowChangesByType;
    }

    private void validateFlagChanges(List<String> changes, ModuloEnum modulo) {
        for (String change : changes) {
            if (!this.flagAllowChanges.containsKey(change) || ((List)this.flagAllowChanges.get(change)).contains(modulo)) continue;
            CrudServiceException.throwExceptionViolations(Arrays.asList(new EloViolation(String.format("N\u00e3o \u00e9 poss\u00edvel habilitar %s nesse m\u00f3dulo", change))));
        }
    }

    public void valid(Pessoa pessoaBeforeChange, ModuloEnum modulo) {
        this.valid(pessoaBeforeChange, modulo, Collections.emptyList());
    }

    private boolean hasChangeBeyoundFlags(List<String> changes) {
        for (String change : changes) {
            if (this.flagAllowChanges.containsKey(change)) continue;
            return true;
        }
        return false;
    }
}

