/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentDisposition;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.client.painel.feign.UsuarioExternoFeignClient;
import br.com.elotech.console.dto.EnderecoContatoUsuarioDTO;
import br.com.elotech.console.dto.EnderecoDTO;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.console.dto.UsuarioDTO;
import br.com.elotech.core.diff.DiffUtils;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.ModuloPessoaEscopo;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloDatabaseException;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.jpa.support.JpaUtil;
import br.com.elotech.core.json.update.JsonUpdateOperation;
import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.service.support.CrudSavingStatus;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.di.batch.job.BatchContextHolder;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Contato;
import br.com.elotech.di.domain.Endereco;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaConsorciada;
import br.com.elotech.di.domain.PessoaContato;
import br.com.elotech.di.domain.PessoaDocumento;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.PessoaImagem;
import br.com.elotech.di.domain.PessoaSocio;
import br.com.elotech.di.domain.TipoDocumento;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.aise.AisePessoa;
import br.com.elotech.di.domain.apice.ApicePessoa;
import br.com.elotech.di.domain.enums.ParametroEnum;
import br.com.elotech.di.domain.protocolo.ProtocoloPessoa;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.ArquivoContent;
import br.com.elotech.di.domain.shared.TipoArquivo;
import br.com.elotech.di.domain.siscop.SiscopFornecedor;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.dto.ParametroDTO;
import br.com.elotech.di.repository.PessoaEnderecos;
import br.com.elotech.di.repository.Pessoas;
import br.com.elotech.di.service.ParametroService;
import br.com.elotech.di.service.PessoaRhUtils;
import br.com.elotech.di.service.PessoaServiceValidaDocumentos;
import br.com.elotech.di.service.PessoaServiceValidateModulo;
import br.com.elotech.di.service.TipoArquivoService;
import br.com.elotech.di.service.UsuarioLogadoService;
import br.com.elotech.di.service.aise.AiseRegistroService;
import br.com.elotech.di.service.support.CrudServiceReplicate;
import br.com.elotech.di.service.support.UnicoCrudService;
import br.com.elotech.di.utils.NIFUtils;
import br.com.elotech.di.validation.EloValidatorCnpjCpfPessoa;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.unico.client.domain.enums.PessoaTipoEmpresa;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class PessoaService
extends UnicoCrudService<Pessoa, Long> {
    @Autowired
    private final PessoaServiceValidateModulo serviceValidateModulo;
    @Autowired
    private final PessoaServiceValidaDocumentos serviceValidaDocumentos;
    @Autowired
    private final AiseRegistroService aiseRegistroService;
    @Autowired
    private final PessoaEnderecos pessoaEnderecos;
    @Autowired
    private final TipoArquivoService tipoArquivoService;
    @Autowired
    private final ArquivoClient arquivoClient;
    @Autowired
    private final ParametroService parametroService;
    @Autowired
    private final UsuarioLogadoService usuarioLogadoService;
    private final UsuarioExternoFeignClient usuarioExternoFeignClient;

    public Pessoas getRepository() {
        return (Pessoas)super.getRepository();
    }

    private void validateSocio(Pessoa entity, List<EloViolation> violations) {
        List socios = entity.getSocios();
        for (PessoaSocio socioPessoa : socios) {
            if (socioPessoa.getSocio().getSocio().isNew() || !socioPessoa.getSocio().getSocio().equals((Object)entity)) continue;
            violations.add(new EloViolation("A pessoa n\u00e3o pode ser s\u00f3cio dela mesma", "S\u00f3cio:"));
        }
    }

    private void validateConsorciado(Pessoa entity, List<EloViolation> violations) {
        BigDecimal percentualMaximo = BigDecimal.valueOf(100.0);
        List consorciados = entity.getConsorciados();
        for (PessoaConsorciada consorciado : consorciados) {
            if (consorciado.getConsorciado().isNew() || !consorciado.getConsorciado().equals((Object)entity)) continue;
            violations.add(new EloViolation("A pessoa n\u00e3o pode ser consorciada dela mesma", "Consorciados:"));
        }
        Optional<BigDecimal> percentualFinal = consorciados.stream().map(PessoaConsorciada::getPercentual).reduce(BigDecimal::add);
        percentualFinal.ifPresent(percentual -> {
            if (percentual.compareTo(percentualMaximo) > 0) {
                violations.add(new EloViolation("A soma dos percentuais \u00e9 maior que 100%", "Consorciados:"));
            }
        });
    }

    protected void beforeSave(Pessoa entity, Authentication authentication) {
        List imagens;
        if (entity.isNew()) {
            entity.setDataInclusao(LocalDate.now());
            if (Objects.isNull(entity.getDataCadastro())) {
                entity.setDataCadastro(LocalDate.now());
            }
        }
        if (Boolean.FALSE.equals(br.com.elotech.core.utils.StringUtils.isSomenteNumeros((String)entity.getCnpjCpf()))) {
            entity.setCnpjCpf(br.com.elotech.core.utils.StringUtils.somenteNumeros((String)entity.getCnpjCpf()));
        }
        entity.setDataAlteracao(DateUtils.getLocalDateTimeNow());
        entity.markEnderecoPrincipalIfNoneExists();
        entity.markContatoPrincipalIfNoneExists();
        entity.getDocumentos().forEach(d -> this.fillArquivoData(d, authentication));
        entity.getIndices().forEach(i -> i.setPessoa(entity));
        entity.getOcorrencias().forEach(o -> o.setPessoa(entity));
        Boolean isServiceAccount = this.usuarioLogadoService.isUsuarioIntegracaoOutrosSistemas();
        entity.setIsServiceAccount(isServiceAccount);
        if (Boolean.FALSE.equals(isServiceAccount)) {
            this.dadosObrigatoriosPessoa(entity);
        }
        if (this.deveFazerUploadS3(imagens = entity.getImagens())) {
            PessoaImagem primeiraImagem = (PessoaImagem)imagens.get(0);
            Arquivo sharedArquivo = this.uploadImageOnS3(primeiraImagem.getArquivo());
            primeiraImagem.setArquivo(sharedArquivo);
            primeiraImagem.setImagem(null);
        }
        if (!this.isUnicoCloud()) {
            entity.getSocios().forEach(sc -> this.replicate((Serializable)sc.getSocio().getSocio().getId(), pessoa -> pessoa.setFornecedor(Boolean.TRUE)));
        }
        super.beforeSave((EloDomain)entity, authentication);
    }

    private boolean deveFazerUploadS3(List<PessoaImagem> imagens) {
        return this.isUnicoCloud() && imagens.stream().map(PessoaImagem::getArquivo).findFirst().filter(arquivo -> arquivo.getFullPath() == null).map(Arquivo::getContent).map(ArquivoContent::getBinary).isPresent();
    }

    private Arquivo uploadImageOnS3(Arquivo arquivo) {
        ArquivoNovoRequest arquivoNovoRequestBuild = this.getArquivoNovoRequest(arquivo);
        br.com.elotech.arquivos.domain.Arquivo arquivoS3 = this.arquivoClient.criarArquivo(arquivoNovoRequestBuild);
        Arquivo sharedArquivo = new Arquivo();
        sharedArquivo.setNome(arquivoS3.getFileName());
        sharedArquivo.setDataCriacao(arquivoS3.getDataCriacao().toLocalDate());
        sharedArquivo.setFullPath(arquivoS3.getFullPath());
        sharedArquivo.setContent(null);
        sharedArquivo.setMimeType(arquivo.getMimeType());
        return sharedArquivo;
    }

    private ArquivoNovoRequest getArquivoNovoRequest(Arquivo arquivo) {
        Tenant tenant = Tenant.create((String)TenantContextHolder.getCurrentTenantId());
        String fileName = arquivo.getNome();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(arquivo.getContent().getBinary());
        ContentType contentType = ContentType.fromType((String)arquivo.getMimeType());
        ArquivoNovoRequest.Builder arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)tenant, (Modulo)Modulo.OXY_UNICO);
        arquivoNovoRequest.filePath("/imagemPerfilPessoa");
        arquivoNovoRequest.fileName(fileName);
        arquivoNovoRequest.content((InputStream)inputStream);
        arquivoNovoRequest.contentType(contentType);
        return arquivoNovoRequest.build();
    }

    private void fillArquivoData(PessoaDocumento documento, Authentication authentication) {
        Optional.ofNullable(documento.getDoc().getArquivo()).ifPresent(arquivo -> {
            if (Boolean.TRUE.equals(arquivo.isS3File())) {
                TipoDocumento tipoDocumento = Optional.ofNullable(documento.getDoc().getDocumento().getTipoDocumento()).orElse(TipoDocumento.OUTROS);
                TipoArquivo tipoArquivo = this.tipoArquivoService.findByTipo(tipoDocumento.getTipoArquivoEnum());
                arquivo.safeSetFieldsForS3(tipoArquivo, Modulo.OXY_UNICO, authentication.getName());
            }
        });
    }

    protected void afterSave(Pessoa saved, Authentication authentication) {
        super.afterSave((EloDomain)saved, authentication);
        this.getEm().flush();
        this.getEm().refresh((Object)saved);
    }

    public void internalReplicate(Pessoa saved) {
        this.getEm().refresh((Object)saved);
        super.internalReplicate((EloDomain)saved);
    }

    protected void validateEntity(Pessoa entity, Authentication authentication, List<EloViolation> violations) {
        PessoaRhUtils.validateRequiredFieldsRH((Pessoa)entity, violations);
        this.validateSocio(entity, violations);
        if (entity.getTipoPessoa() != null && entity.getTipoPessoa().equals((Object)TipoPessoa.JURIDICA) && entity.getConsorcio() != null && Boolean.TRUE.equals(entity.getConsorcio())) {
            this.validateConsorciado(entity, violations);
        }
        this.validaNumeroNif(entity, violations);
        this.serviceValidaDocumentos.validateDocumento(entity, violations);
    }

    protected void beforeEdit(Pessoa entity) {
        if (ContextHolder.hasHeadersValue() && !ContextHolder.isInProcessoUnificacao()) {
            JpaUtil.initializeAndUnproxyFieldsDetach((Object)entity, (EntityManager)this.getEm());
            Pessoa pessoaLoad = (Pessoa)this.findOne((Serializable)entity.getId());
            JpaUtil.initializeAndUnproxyFieldsDetach((Object)pessoaLoad, (EntityManager)this.getEm());
            this.serviceValidateModulo.valid(pessoaLoad, ContextHolder.getHeaderValueModulo(), DiffUtils.getChangedFields((Object)entity, (Object)pessoaLoad));
        }
    }

    protected void beforeEditPartial(Pessoa entity, List<JsonUpdatePartial> updates) {
        if (ContextHolder.hasHeadersValue() && !ContextHolder.isInProcessoUnificacao()) {
            this.serviceValidateModulo.valid((Pessoa)this.findOne((Serializable)entity.getId()), ContextHolder.getHeaderValueModulo(), updates.stream().map(update -> update.getPath()).collect(Collectors.toList()));
        }
    }

    public Pessoa saveSkippingValidation(Pessoa entity, Authentication authentication) {
        boolean started = false;
        if (!BatchContextHolder.isRunning()) {
            BatchContextHolder.started();
            started = true;
        }
        try {
            CrudSavingStatus savingStatus = this.isNew((EloEntity)entity) ? CrudSavingStatus.CREATED : CrudSavingStatus.UPDATED;
            this.getCrudRepository().saveAndFlush((Object)entity);
            this.getEm().refresh((Object)entity);
            this.afterSave(entity, authentication);
            this.afterSaveWithStatus((EloDomain)entity, savingStatus);
            Pessoa pessoa = entity;
            return pessoa;
        }
        catch (Exception ex) {
            if (ex instanceof EloDatabaseException) {
                throw ex;
            }
            String message = String.format("Erro ao salvar a pessoa %s com ID %d.", entity.getNome(), entity.getId());
            this.getLog().error(message, (Throwable)ex);
            throw new EloDatabaseException(message, (Throwable)ex);
        }
        finally {
            if (started) {
                BatchContextHolder.stopped();
            }
        }
    }

    protected CrudServiceReplicate<Pessoa, Long> createReplicator(Pessoa entity) {
        HashSet<Class> classes = new HashSet<Class>();
        if (entity.getContribuinte().booleanValue() || entity.getPessoal().booleanValue()) {
            classes.add(AisePessoa.class);
        }
        if (Boolean.TRUE.equals(entity.getFornecedor()) && this.aiseRegistroService.isValid(ModuloEnum.MODULO_OBRAS, LocalDate.now())) {
            classes.add(AisePessoa.class);
        }
        if (Boolean.TRUE.equals(entity.getProtocolo())) {
            classes.add(ProtocoloPessoa.class);
        }
        if (Boolean.TRUE.equals(entity.getFornecedor())) {
            classes.add(ApicePessoa.class);
            classes.add(SiscopFornecedor.class);
        }
        List validReplicators = this.getReplicators().stream().filter(r -> classes.contains(r.getReplicableType())).collect(Collectors.toList());
        return new CrudServiceReplicate(validReplicators);
    }

    public void inactiveFromJoin(Pessoa pessoa) {
        pessoa.setInativo(Boolean.valueOf(true));
        this.getEm().merge((Object)pessoa);
    }

    public List<PessoaSocio> findSocios(Pessoa pessoaSocio) {
        return this.getEm().createQuery("from PessoaSocio where socio.socio=:pessoa", PessoaSocio.class).setParameter("pessoa", (Object)pessoaSocio).getResultList();
    }

    public Optional<String> defaultSearchFilter() {
        if (ContextHolder.hasHeadersValue() && !ContextHolder.getHeaderValueModulo().equals((Object)ModuloEnum.MODULO_UNDEFINED) && !ContextHolder.getHeaderValueModulo().getModuloPessoaEscopo().equals((Object)ModuloPessoaEscopo.UNDEFINED)) {
            return Optional.of(String.format("%s==true", ContextHolder.getHeaderValueModulo().getModuloPessoaEscopo().toString().toLowerCase(Locale.getDefault())));
        }
        return super.defaultSearchFilter();
    }

    public void flush() {
        this.getEm().flush();
    }

    public PessoaEndereco findEnderecoByCep(Long cep) {
        return this.pessoaEnderecos.findFirstByEnderecoCepAndEnderecoCidadeInativoFalseOrderByIdDesc(cep).orElse(new PessoaEndereco());
    }

    public boolean enviarPessoaParaEsocial(Pessoa pessoaSaved, List<JsonUpdatePartial> updates) {
        return this.hasChangePessoa(updates) || this.hasChangeEndereco(pessoaSaved, updates) || this.hasChangeContato(pessoaSaved, updates);
    }

    private boolean hasChangePessoa(List<JsonUpdatePartial> updates) {
        return updates.stream().anyMatch(update -> update.getPath().contains("nome") || update.getPath().contains("cidadeNascimento") || update.getPath().contains("escolaridade") || update.getPath().contains("cor") || update.getPath().contains("estadoCivil") || update.getPath().contains("sexo") || update.getPath().contains("deficiente"));
    }

    private boolean hasChangeEndereco(Pessoa pessoaSaved, List<JsonUpdatePartial> updates) {
        PessoaEndereco pessoaEndereco = pessoaSaved.getEnderecos().stream().filter(PessoaEndereco::getPrincipal).findFirst().orElse(null);
        if (Objects.nonNull(pessoaEndereco)) {
            return updates.stream().filter(update -> update.getPath().contains("enderecos/" + pessoaEndereco.getId())).anyMatch(endereco -> endereco.getPath().contains("cidade") || endereco.getPath().contains("logradouro") || endereco.getPath().contains("bairro") || endereco.getPath().contains("cep") || endereco.getPath().contains("complemento") || endereco.getPath().contains("principal") || endereco.getOp().equals((Object)JsonUpdateOperation.REMOVE));
        }
        return updates.stream().anyMatch(update -> update.getPath().contains("enderecos") && update.getOp().equals((Object)JsonUpdateOperation.ADD));
    }

    private boolean hasChangeContato(Pessoa pessoaSaved, List<JsonUpdatePartial> updates) {
        PessoaContato contatoSaved = pessoaSaved.getContatos().stream().filter(PessoaContato::getPrincipal).findFirst().orElse(null);
        if (Objects.nonNull(contatoSaved)) {
            return updates.stream().filter(update -> update.getPath().contains("contatos/" + contatoSaved.getId())).anyMatch(contato -> contato.getPath().contains("email") || contato.getPath().contains("telefone") || contato.getPath().contains("principal") || contato.getOp().equals((Object)JsonUpdateOperation.REMOVE));
        }
        return updates.stream().anyMatch(update -> update.getPath().contains("contatos") && update.getOp().equals((Object)JsonUpdateOperation.ADD));
    }

    public Optional<Pessoa> findByCnpjCpf(String cnpjCpf) {
        return this.getRepository().findByCnpjCpf(cnpjCpf).stream().findFirst();
    }

    public UsuarioDTO createUser(Long id) {
        if (Objects.nonNull(this.getUnicoProperties()) && Boolean.FALSE.equals(this.getUnicoProperties().getCloud())) {
            throw new EloValidationException("Essa funcionalidade est\u00e1 dispon\u00edvel apenas para o OXY.");
        }
        Pessoa pessoa = (Pessoa)this.findById((Serializable)id).orElseThrow(() -> RestException.notFound((String)"Pessoa n\u00e3o encontrada."));
        if (!EloValidatorCnpjCpfPessoa.getValidator((TipoPessoa)pessoa.getTipoPessoa()).invalidMessagesFor((Object)pessoa.getCnpjCpf()).isEmpty()) {
            throw new EloValidationException("CPF/CNPJ inv\u00e1lido. Primeiro fa\u00e7a a corre\u00e7\u00e3o do cadastro da pessoa.");
        }
        Contato contato = Optional.ofNullable(pessoa.getContato()).orElseGet(Contato::new);
        if (StringUtils.isBlank((CharSequence)contato.getEmail())) {
            throw new EloValidationException("E-mail inv\u00e1lido. Informe um email v\u00e1lido no contato principal da pessoa.");
        }
        String[] name = StringUtils.split((String)pessoa.getNome());
        UsuarioDTO usuarioDTO = new UsuarioDTO();
        usuarioDTO.setUsername(pessoa.getCnpjCpf());
        usuarioDTO.setEmail(contato.getEmail());
        usuarioDTO.setNome(name[0]);
        usuarioDTO.setSobrenome(Stream.of(name).skip(1L).collect(Collectors.joining(" ")));
        usuarioDTO.setAtivo(Boolean.TRUE);
        usuarioDTO.setTemporaryPassword(Boolean.TRUE);
        usuarioDTO.setTelefone((String)StringUtils.defaultIfBlank((CharSequence)contato.getTelefoneCelular(), (CharSequence)contato.getTelefoneResidencial()));
        PessoaEndereco endereco = pessoa.getPessoaEnderecoPrincipal();
        if (Objects.nonNull(endereco)) {
            if (Objects.isNull(endereco.getEndereco().getCep())) {
                throw new EloValidationException("CEP inv\u00e1lido. Informe um cep v\u00e1lido no endere\u00e7o da pessoa.");
            }
            EnderecoContatoUsuarioDTO enderecoContatoUsuario = new EnderecoContatoUsuarioDTO();
            EnderecoDTO enderecoUsuario = new EnderecoDTO();
            enderecoContatoUsuario.setTelefone(usuarioDTO.getTelefone());
            enderecoContatoUsuario.setEndereco(enderecoUsuario);
            enderecoUsuario.setCep(StringUtils.leftPad((String)endereco.getEndereco().getCep().toString(), (int)8, (String)"0"));
            enderecoUsuario.setLogradouro(endereco.getEndereco().getLogradouro().getDescricao());
            enderecoUsuario.setNumero(endereco.getEndereco().getNumero());
            enderecoUsuario.setBairro(endereco.getEndereco().getBairro().getDescricao());
            enderecoUsuario.setCidade(endereco.getEndereco().getCidade().getDescricao());
            enderecoUsuario.setUf(endereco.getEndereco().getCidade().getUf().getSigla());
            if (Objects.nonNull(endereco.getEndereco().getCidade().getCodigoIbge())) {
                enderecoUsuario.setIbge(endereco.getEndereco().getCidade().getCodigoIbge().toString());
            }
            enderecoUsuario.setComplemento(endereco.getEndereco().getComplemento());
            usuarioDTO.setEnderecoContatoUsuario(enderecoContatoUsuario);
        }
        return this.usuarioExternoFeignClient.create(usuarioDTO);
    }

    public String getImagemPerfil(Long id) {
        Pessoa pessoa = (Pessoa)this.findById((Serializable)id).orElseThrow(() -> RestException.notFound((String)String.format("Pessoa %s n\u00e3o encontrada.", id)));
        return this.getArquivoFromPessoa(pessoa.getImagens()).map(arquivo -> {
            String fullPath = arquivo.getFullPath();
            String fileName = Optional.ofNullable(arquivo.getNome()).orElse("");
            if (Objects.isNull(fullPath)) {
                return "";
            }
            ArquivoDownloadRequest request = this.generateArquivoDownloadRequest(fullPath, fileName);
            return this.arquivoClient.gerarUrlParaGet(request).getUrlAssinada();
        }).orElse("");
    }

    private Optional<Arquivo> getArquivoFromPessoa(List<PessoaImagem> pessoaImagem) {
        return Optional.ofNullable(pessoaImagem).flatMap(imagens -> imagens.stream().findFirst()).map(PessoaImagem::getArquivo);
    }

    private ArquivoDownloadRequest generateArquivoDownloadRequest(String fullPath, String fileName) {
        Tenant tenant = Tenant.create((String)TenantContextHolder.getCurrentTenantId());
        return ArquivoDownloadRequest.create((Tenant)tenant, (String)fullPath, (Integer)604800, (ContentDisposition)ContentDisposition.INLINE, (String)fileName);
    }

    private void validaNumeroNif(Pessoa entity, List<EloViolation> violations) {
        if (Boolean.TRUE.equals(this.isPaisExterior(entity.getEnderecos())) && Objects.nonNull(entity.getNif()) && Boolean.FALSE.equals(NIFUtils.isNIFValido((String)entity.getNif().getNumero()))) {
            violations.add(new EloViolation("N\u00famero NIF inv\u00e1lido", "Validar o n\u00famero inserido"));
        }
    }

    private Boolean isPaisExterior(List<PessoaEndereco> enderecos) {
        return enderecos.stream().map(e -> Optional.ofNullable(e.getEndereco()).map(Endereco::getCidade).map(Cidade::getUf).map(UF::getPais).orElse(null)).filter(Objects::nonNull).anyMatch(pais -> pais.isExterior() == false);
    }

    private void dadosObrigatoriosPessoa(Pessoa entity) {
        List parametros = this.parametroService.findAllParametrosConfiguraveis();
        Map parametrosMap = parametros.stream().collect(Collectors.toMap(ParametroDTO::getId, Function.identity()));
        LinkedHashMap<Function, ParametroEnum> validations = new LinkedHashMap<Function, ParametroEnum>();
        validations.put(arg_0 -> this.obrigatorioRg(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_RG);
        validations.put(arg_0 -> this.obrigatorioTipoEmpresa(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_TIPO_EMPRESA);
        validations.put(arg_0 -> this.obrigatorioInscricaoEstadual(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_IE);
        validations.put(arg_0 -> this.obrigatorioSocios(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_SOCIOS);
        validations.put(arg_0 -> this.obrigatorioContato(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_CONTATO);
        validations.put(arg_0 -> this.obrigatorioTelefone(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_TELEFONE);
        validations.put(arg_0 -> this.obrigatorioEmail(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_EMAIL);
        validations.put(arg_0 -> this.obrigatorioEndereco(arg_0), ParametroEnum.CADASTRO_PESSOA_OBRIGATORIO_ENDERECO);
        validations.forEach((validator, parametro) -> {
            ParametroDTO parametroDTO = (ParametroDTO)parametrosMap.get(parametro.getId());
            if (this.isParametroAtivo(parametroDTO)) {
                validator.apply(entity);
            }
        });
    }

    private Void obrigatorioRg(Pessoa entity) {
        if (TipoPessoa.FISICA.equals((Object)entity.getTipoPessoa()) && Objects.isNull(entity.getRg())) {
            throw new EloValidationException("Informe o RG");
        }
        return null;
    }

    private Void obrigatorioTipoEmpresa(Pessoa entity) {
        if (TipoPessoa.JURIDICA.equals((Object)entity.getTipoPessoa()) && Objects.isNull(entity.getTipoEmpresa())) {
            throw new EloValidationException("Informe o Tipo da Empresa");
        }
        return null;
    }

    private Void obrigatorioInscricaoEstadual(Pessoa entity) {
        if (TipoPessoa.JURIDICA.equals((Object)entity.getTipoPessoa()) && Objects.isNull(entity.getInscricaoEstadual())) {
            throw new EloValidationException("Informe a Inscri\u00e7\u00e3o Estadual");
        }
        return null;
    }

    private Void obrigatorioSocios(Pessoa entity) {
        if (TipoPessoa.JURIDICA.equals((Object)entity.getTipoPessoa()) && entity.getSocios().isEmpty() && PessoaTipoEmpresa.isTipoEmpresaExigeSocio((PessoaTipoEmpresa)entity.getTipoEmpresa())) {
            throw new EloValidationException("Informe o(s) S\u00f3cio(s)");
        }
        return null;
    }

    private Void obrigatorioContato(Pessoa entity) {
        if (Objects.isNull(entity.getContato())) {
            throw new EloValidationException("Informe o Contato Principal");
        }
        return null;
    }

    private Void obrigatorioEmail(Pessoa entity) {
        if (ObjectUtils.isEmpty((Object)entity.getSafeContato().getEmail())) {
            throw new EloValidationException("Informe o E-Mail do Contato Principal.");
        }
        return null;
    }

    private Void obrigatorioTelefone(Pessoa entity) {
        if (ObjectUtils.isEmpty((Object)entity.getSafeContato().getTelefonePrincipal())) {
            throw new EloValidationException("Informe o Telefone do Contato Principal.");
        }
        return null;
    }

    private Void obrigatorioEndereco(Pessoa entity) {
        if (Objects.isNull(entity.getEndereco())) {
            throw new EloValidationException("Informe o Endere\u00e7o.");
        }
        return null;
    }

    private boolean isParametroAtivo(ParametroDTO parametroDTO) {
        return Objects.nonNull(parametroDTO) && SimNao.SIM.getSigla().equals(parametroDTO.getValue());
    }

    @Generated
    public PessoaService(PessoaServiceValidateModulo serviceValidateModulo, PessoaServiceValidaDocumentos serviceValidaDocumentos, AiseRegistroService aiseRegistroService, PessoaEnderecos pessoaEnderecos, TipoArquivoService tipoArquivoService, ArquivoClient arquivoClient, ParametroService parametroService, UsuarioLogadoService usuarioLogadoService, UsuarioExternoFeignClient usuarioExternoFeignClient) {
        this.serviceValidateModulo = serviceValidateModulo;
        this.serviceValidaDocumentos = serviceValidaDocumentos;
        this.aiseRegistroService = aiseRegistroService;
        this.pessoaEnderecos = pessoaEnderecos;
        this.tipoArquivoService = tipoArquivoService;
        this.arquivoClient = arquivoClient;
        this.parametroService = parametroService;
        this.usuarioLogadoService = usuarioLogadoService;
        this.usuarioExternoFeignClient = usuarioExternoFeignClient;
    }
}

