/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.di.domain.PessoaOcorrencia;
import br.com.elotech.di.repository.PessoaOcorrenciaRepository;
import br.com.elotech.unico.client.dto.PessoaOcorrenciaDTO;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PessoaOcorrenciaService
extends ReadOnlyService<PessoaOcorrencia, Long> {
    public PessoaOcorrenciaRepository getRepository() {
        return (PessoaOcorrenciaRepository)super.getRepository();
    }

    public EloPage<PessoaOcorrenciaDTO> findAllToDTO(String search, Pageable pageable) {
        Page ocorrencias = this.findByRsql(search, pageable);
        List ocorrenciasDTO = ocorrencias.map(oc -> {
            PessoaOcorrenciaDTO pessoaOcorrenciaDTO = new PessoaOcorrenciaDTO();
            pessoaOcorrenciaDTO.setId(oc.getId());
            pessoaOcorrenciaDTO.setPessoaId(oc.getPessoa().getId());
            pessoaOcorrenciaDTO.setTipoPessoa(oc.getPessoa().getTipoPessoa().getDescricao());
            pessoaOcorrenciaDTO.setNome(oc.getPessoa().getNome());
            pessoaOcorrenciaDTO.setNomeFantasia(oc.getPessoa().getNomeFantasia());
            pessoaOcorrenciaDTO.setCnpjCpf(oc.getPessoa().getCnpjCpf());
            pessoaOcorrenciaDTO.setDataIniSuspensao(oc.getDataRestricaoInicio());
            pessoaOcorrenciaDTO.setDataFimSuspensao(oc.getDataRestricaoFim());
            pessoaOcorrenciaDTO.setObservacao(oc.getObservacao());
            Optional.ofNullable(oc.getArquivo()).ifPresent(arquivo -> {
                pessoaOcorrenciaDTO.setArquivoId(arquivo.getId());
                pessoaOcorrenciaDTO.setArquivoNome(arquivo.getNome());
            });
            return pessoaOcorrenciaDTO;
        }).toList();
        EloPage page = new EloPage(ocorrenciasDTO);
        page.setTotalElements(this.count(search).longValue());
        return page;
    }
}

