/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.di.domain.Agencia;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaBanco;
import br.com.elotech.di.domain.PessoaContato;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.PessoaRH;
import br.com.elotech.di.domain.TipoConta;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.dto.PessoaIntegracaoSocialDTO;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.service.AgenciaService;
import br.com.elotech.di.service.BairroService;
import br.com.elotech.di.service.BancoService;
import br.com.elotech.di.service.CidadeService;
import br.com.elotech.di.service.LogradouroService;
import br.com.elotech.di.service.PessoaService;
import br.com.elotech.di.service.UnidadeFederacaoService;
import br.com.elotech.unico.client.dto.PessoaDTO;
import java.util.Objects;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PessoaIntegracaoSocialService {
    private final UnidadeFederacaoService unidadeFederacaoService;
    private final CidadeService cidadeService;
    private final LogradouroService logradouroService;
    private final PessoaService pessoaService;
    private final BairroService bairroService;
    private final BancoService bancoService;
    private final AgenciaService agenciaService;

    public PessoaIntegracaoSocialService(UnidadeFederacaoService unidadeFederacaoService, CidadeService cidadeService, LogradouroService logradouroService, PessoaService pessoaService, BairroService bairroService, BancoService bancoService, AgenciaService agenciaService) {
        this.unidadeFederacaoService = unidadeFederacaoService;
        this.cidadeService = cidadeService;
        this.logradouroService = logradouroService;
        this.pessoaService = pessoaService;
        this.bairroService = bairroService;
        this.bancoService = bancoService;
        this.agenciaService = agenciaService;
    }

    @Transactional
    public PessoaDTO save(PessoaIntegracaoSocialDTO dto) {
        boolean naoPossuiContaEnviada;
        boolean naoPossuiEndereco;
        Long codigoCidade = this.saveCidade(dto);
        Long codigoLogradouro = this.saveLogradouro(dto, codigoCidade);
        Long codigobairro = this.saveBairro(dto, codigoCidade);
        Long codigoBanco = this.saveBanco(dto);
        Long codigoAgencia = this.saveAgencia(dto, codigoBanco);
        Optional optPessoa = this.pessoaService.findByCnpjCpf(dto.getCnpjCpf());
        Pessoa pessoa = optPessoa.orElseGet(Pessoa::new);
        pessoa.setCnpjCpf(dto.getCnpjCpf());
        pessoa.setNome(dto.getNome());
        pessoa.setDataNascimento(dto.getDataNascimento());
        PessoaRH pessoaRH = new PessoaRH();
        pessoa.setEscolaridade(dto.getEscolaridade());
        pessoa.setNomeSocial(dto.getNomeSocial());
        pessoaRH.getComum().setSexo(dto.getSexo());
        pessoaRH.getComum().setCor(dto.getCor());
        pessoaRH.getComum().setEstadoCivil(dto.getEstadoCivil());
        pessoaRH.getComum().setNacionalidade(dto.getNacionalidade());
        pessoaRH.getComum().setDeficiente(dto.getDeficiente());
        pessoaRH.getComum().setDataObito(dto.getDataObito());
        pessoaRH.getComum().setNomeMae(dto.getNomeMae());
        pessoaRH.getComum().setNomePai(dto.getNomePai());
        pessoa.setRh(pessoaRH);
        boolean naoPossuiContato = pessoa.getContatos().stream().noneMatch(contatoPessoa -> Objects.equals(contatoPessoa.getContato().getTelefoneCelular(), dto.getTelefoneCelular()) && Objects.equals(contatoPessoa.getContato().getTelefoneResidencial(), dto.getTelefoneResidencial()) && Objects.equals(contatoPessoa.getContato().getNome(), dto.getNome()));
        if (naoPossuiContato) {
            PessoaContato pessoaContato = new PessoaContato();
            pessoaContato.setPrincipal(Boolean.TRUE);
            pessoaContato.getContato().setNome(dto.getNome());
            pessoaContato.getContato().setTelefoneCelular(dto.getTelefoneCelular());
            pessoaContato.getContato().setTelefoneResidencial(dto.getTelefoneResidencial());
            pessoaContato.getContato().setCpf(dto.getCnpjCpf());
            pessoa.getContatos().add(pessoaContato);
        }
        if ((naoPossuiEndereco = pessoa.getEnderecos().stream().noneMatch(enderecoPessoa -> Objects.equals(enderecoPessoa.getEndereco().getNumero(), dto.getNumero()) && Objects.equals(enderecoPessoa.getEndereco().getComplemento(), dto.getComplemento()) && Objects.equals(enderecoPessoa.getEndereco().getCidade().getId(), codigoCidade) && Objects.equals(enderecoPessoa.getEndereco().getLogradouro().getId(), codigoLogradouro) && Objects.equals(enderecoPessoa.getEndereco().getBairro().getId(), codigobairro))) && Objects.nonNull(codigoLogradouro)) {
            PessoaEndereco pessoaEndereco = new PessoaEndereco();
            pessoaEndereco.setPrincipal(Boolean.TRUE);
            pessoaEndereco.getEndereco().setCep(dto.getCep());
            pessoaEndereco.getEndereco().setNumero(dto.getNumero());
            pessoaEndereco.getEndereco().setComplemento(dto.getComplemento());
            pessoaEndereco.getEndereco().setCidade(new Cidade().withId(codigoCidade));
            pessoaEndereco.getEndereco().setLogradouro(new Logradouro().withId(codigoLogradouro));
            pessoaEndereco.getEndereco().setBairro(new Bairro().withId(codigobairro));
            pessoaEndereco.getEndereco().setTipo(EnderecoTipo.RESIDENCIAL);
            pessoa.getEnderecos().add(pessoaEndereco);
        }
        if ((naoPossuiContaEnviada = pessoa.getBancosPessoa().stream().noneMatch(bancoPessoa -> bancoPessoa.getConta().getConta().equals(dto.getConta()))) && Objects.nonNull(codigoAgencia)) {
            PessoaBanco pessoaBanco = new PessoaBanco();
            pessoaBanco.getConta().setAgencia(new Agencia().withId(codigoAgencia));
            pessoaBanco.getConta().setConta(dto.getConta());
            pessoaBanco.getConta().setTipoConta(TipoConta.fromValue((String)dto.getTipo()));
            pessoa.getBancosPessoa().add(pessoaBanco);
        }
        return this.pessoaService.saveSkippingValidation(pessoa, null).convertToEvent();
    }

    protected Long saveCidade(PessoaIntegracaoSocialDTO dto) {
        Optional optEstado = this.unidadeFederacaoService.findFirstBySiglaIgnoreCase(dto.getSigla());
        if (Objects.isNull(dto.getCodigoIbge()) || optEstado.isEmpty()) {
            return null;
        }
        Optional optCidade = this.cidadeService.findFirstByCodigoIbgeAndInativoFalse(dto.getCodigoIbge());
        if (optCidade.isPresent()) {
            return ((Cidade)optCidade.get()).getId();
        }
        Optional optCidadeDescricao = this.cidadeService.findFirstByDescricaoIgnoreCaseAndInativoFalse(dto.getCidade());
        if (optCidadeDescricao.isPresent()) {
            return ((Cidade)optCidadeDescricao.get()).getId();
        }
        Cidade cidade = new Cidade();
        cidade.setDescricao(dto.getCidade());
        cidade.setCodigoIbge(dto.getCodigoIbge());
        cidade.setUf((UF)optEstado.get());
        Cidade codigoCid = (Cidade)this.cidadeService.saveAndFlush((EloDomain)cidade);
        return codigoCid.getId();
    }

    public Long saveLogradouro(PessoaIntegracaoSocialDTO dto, Long codigoCidade) {
        if (Objects.isNull(codigoCidade)) {
            return null;
        }
        Optional optLogradouro = this.logradouroService.findFirstByDescricaoIgnoreCaseAndInativoFalseAndCidadeId(dto.getLogradouro(), codigoCidade);
        if (optLogradouro.isPresent()) {
            return ((Logradouro)optLogradouro.get()).getId();
        }
        Logradouro logradouro = new Logradouro();
        logradouro.setDescricao(dto.getLogradouro());
        logradouro.setCidade(new Cidade().withId(codigoCidade));
        Logradouro codigoLog = (Logradouro)this.logradouroService.saveAndFlush((EloDomain)logradouro);
        return codigoLog.getId();
    }

    public Long saveBairro(PessoaIntegracaoSocialDTO dto, Long codigoCidade) {
        if (Objects.isNull(codigoCidade)) {
            return null;
        }
        Optional optBairro = this.bairroService.findFirstByDescricaoIgnoreCaseAndInativoFalseAndCidadeId(dto.getBairro(), codigoCidade);
        if (optBairro.isPresent()) {
            return ((Bairro)optBairro.get()).getId();
        }
        Bairro bairro = new Bairro();
        bairro.setDescricao(dto.getBairro());
        bairro.setCidade(new Cidade().withId(codigoCidade));
        Bairro codigoBai = (Bairro)this.bairroService.saveAndFlush((EloDomain)bairro);
        return codigoBai.getId();
    }

    public Long saveBanco(PessoaIntegracaoSocialDTO dto) {
        if (Objects.isNull(dto.getCodigoBanco())) {
            return null;
        }
        Optional optBanco = this.bancoService.findFirstByDescricaoIgnoreCase(dto.getBanco());
        if (optBanco.isPresent()) {
            return ((Banco)optBanco.get()).getId();
        }
        Banco banco = new Banco();
        banco.setDescricao(dto.getBanco());
        banco.setCodigo(dto.getCodigoBanco());
        Banco codigoBan = (Banco)this.bancoService.saveAndFlush((EloDomain)banco);
        return codigoBan.getId();
    }

    public Long saveAgencia(PessoaIntegracaoSocialDTO dto, Long codigoBanco) {
        if (Objects.isNull(codigoBanco)) {
            return null;
        }
        Optional optAgencia = this.agenciaService.findFirstByCodigoIgnoreCaseAndBancoId(dto.getAgencia(), codigoBanco);
        if (optAgencia.isPresent()) {
            return ((Agencia)optAgencia.get()).getId();
        }
        Agencia agencia = new Agencia();
        agencia.setDescricao(dto.getAgencia().concat(" ").concat(dto.getBanco()));
        agencia.setCodigo(dto.getAgencia());
        agencia.setBanco(new Banco().withId(codigoBanco));
        Agencia codigoAge = (Agencia)this.agenciaService.saveAndFlush((EloDomain)agencia);
        return codigoAge.getId();
    }
}

