/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Endereco;
import br.com.elotech.di.domain.LocalidadeAtivo;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO;
import br.com.elotech.di.domain.enums.DuplicacaoStatus;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.repository.Bairros;
import br.com.elotech.di.repository.Logradouros;
import br.com.elotech.di.repository.Pessoas;
import br.com.elotech.di.repository.support.UnicoCrudRepository;
import br.com.elotech.di.service.BairroService;
import br.com.elotech.di.service.DuplicacaoService;
import br.com.elotech.di.service.LogradouroService;
import br.com.elotech.di.service.PessoaService;
import br.com.elotech.di.service.support.UnicoCrudService;
import br.com.elotech.di.unificacao.CidadeDuplicadaService;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PessoaEnderecoService {
    private final Logradouros logradouroRepository;
    private final Bairros bairroRepostory;
    private final Pessoas pessoas;
    private final PessoaService pessoaService;
    private final DuplicacaoService duplicacaoService;
    private final CidadeDuplicadaService cidadeDuplicadaService;
    private final LogradouroService logradouroService;
    private final BairroService bairroService;
    private static final Logger LOG = LoggerFactory.getLogger(PessoaEnderecoService.class);

    @Transactional
    public void refactoryCidadesInativas(DuplicadaDTO cidadeDuplicadaDTO) {
        try {
            this.internalRefactoryCidades(cidadeDuplicadaDTO);
            this.duplicacaoService.updateExecutado(cidadeDuplicadaDTO.getDuplicacoesIds());
        }
        catch (Exception e) {
            LOG.error("Erro ao processar refactoryCidadesInativas", (Throwable)e);
            this.handlingException(cidadeDuplicadaDTO, e);
        }
    }

    private void handlingException(DuplicadaDTO duplicadaDTO, Exception e) {
        duplicadaDTO.setErro(ExceptionUtils.getRootCauseMessage((Throwable)e));
        this.duplicacaoService.updateFalha(duplicadaDTO.getDuplicacoesIds(), duplicadaDTO.getErro());
    }

    private void internalRefactoryCidades(DuplicadaDTO cidadeDuplicadaDTO) {
        this.validateDuplicacao(cidadeDuplicadaDTO);
        this.cidadeDuplicadaService.removerDuplicacoes(cidadeDuplicadaDTO);
        List chavesInativa = cidadeDuplicadaDTO.getChavesInativa();
        List byPessoaEnderecoCidadeIdIn = this.pessoas.findByPessoaEnderecoCidadeIdIn(chavesInativa);
        byPessoaEnderecoCidadeIdIn.forEach(pessoa -> {
            this.refactoryEndereco(cidadeDuplicadaDTO, chavesInativa, pessoa);
            this.savePessoa(cidadeDuplicadaDTO, chavesInativa, pessoa, "cidade");
        });
    }

    private void savePessoa(DuplicadaDTO duplicadaDTO, List<Long> chavesInativa, Pessoa pessoa, String tipo) {
        LOG.info(String.format("Iniciando refactory endere\u00e7o %s pessoa: %s, chaveInativa: %s, chavePrincipal: %s", tipo, pessoa.getCnpjCpf(), chavesInativa, duplicadaDTO.getChavePrincipal()));
        pessoa.markEnderecoPrincipalIfNoneExists();
        this.pessoaService.saveSkippingValidation(pessoa, null);
        LOG.info(String.format("Finalizando refactory endere\u00e7o %s pessoa: %s, chaveInativa: %s, chavePrincipal: %s", tipo, pessoa.getCnpjCpf(), chavesInativa, duplicadaDTO.getChavePrincipal()));
    }

    private void validateDuplicacao(DuplicadaDTO cidadeDuplicadaDTO) {
        if (!cidadeDuplicadaDTO.getStatus().equals((Object)DuplicacaoStatus.PROCESSANDO)) {
            throw new IllegalArgumentException(String.format("A duplica\u00e7\u00e3o com id %s est\u00e1 com status n\u00e3o esperado %s.", cidadeDuplicadaDTO.getId(), cidadeDuplicadaDTO.getStatus()));
        }
    }

    private void refactoryEndereco(DuplicadaDTO cidadeDuplicadaDTO, List<Long> chavesInativa, Pessoa pessoa) {
        pessoa.getEnderecos().forEach(enderecoPessoa -> {
            Endereco endereco = enderecoPessoa.getEndereco();
            boolean existeChaveInativada = chavesInativa.stream().anyMatch(codigoInativacao -> codigoInativacao.equals(endereco.getCidade().getId()));
            if (existeChaveInativada) {
                Cidade cidade = new Cidade();
                cidade.setId(cidadeDuplicadaDTO.getChavePrincipal());
                Bairro bairroCidadePrincipal = Optional.ofNullable(this.bairroRepostory.findFirstByDescricaoIgnoreCaseAndCidade(endereco.getBairro().getDescricao(), cidade)).orElseThrow(() -> new IllegalArgumentException(String.format("Pessoa %s. N\u00e3o foi encontrado bairro %s na cidade codigo %s", pessoa.getId(), endereco.getBairro().getDescricao(), cidade.getId())));
                Logradouro logradouroCidadePrincipal = Optional.ofNullable(this.logradouroRepository.findFirstByDescricaoIgnoreCaseAndCidade(endereco.getLogradouro().getDescricao(), cidade)).orElseThrow(() -> new IllegalArgumentException(String.format("Pessoa %s. N\u00e3o foi encontrado logradouro %s na cidade codigo %s", pessoa.getId(), endereco.getLogradouro().getDescricao(), cidade.getId())));
                endereco.setCidade(cidade);
                endereco.setBairro(bairroCidadePrincipal);
                endereco.setLogradouro(logradouroCidadePrincipal);
            }
        });
    }

    @Transactional
    public void refactoryLogradouro(DuplicadaDTO logradouroDuplicadoDTO) {
        try {
            this.internalRefactory(logradouroDuplicadoDTO, "logradouro", (UnicoCrudRepository)this.logradouroRepository, (UnicoCrudService)this.logradouroService, e -> e.getLogradouro().getId(), Endereco::setLogradouro, () -> this.pessoas.findByPessoaEnderecoLogradouroIdIn(logradouroDuplicadoDTO.getChavesInativa()));
            this.duplicacaoService.updateExecutado(logradouroDuplicadoDTO.getDuplicacoesIds());
        }
        catch (Exception e2) {
            this.handlingException(logradouroDuplicadoDTO, e2);
        }
    }

    private <T extends EloDomain<Long>> void internalRefactory(DuplicadaDTO duplicadaDTO, String tipo, UnicoCrudRepository<T, Long> repository, UnicoCrudService<T, Long> service, Function<Endereco, Long> functionGetId, BiConsumer<Endereco, T> functionAttLocalidade, Supplier<List<Pessoa>> suplierPessoas) {
        this.validateDuplicacao(duplicadaDTO);
        EloDomain ativo = (EloDomain)repository.findOne((Object)duplicadaDTO.getChavePrincipal());
        List chavesInativas = duplicadaDTO.getChavesInativa();
        repository.findAllById((Iterable)chavesInativas).stream().peek(l -> ((LocalidadeAtivo)l).setInativo(Boolean.valueOf(true))).forEach(x$0 -> service.save((EloDomain)x$0));
        List<Pessoa> byPessoaEnderecosIdIn = suplierPessoas.get();
        byPessoaEnderecosIdIn.stream().flatMap(p -> p.getEnderecos().stream()).filter(e -> chavesInativas.contains(functionGetId.apply(e.getEndereco()))).forEach(e -> functionAttLocalidade.accept(e.getEndereco(), ativo));
        byPessoaEnderecosIdIn.forEach(p -> this.savePessoa(duplicadaDTO, chavesInativas, p, tipo));
    }

    @Transactional
    public void refactoryBairro(DuplicadaDTO bairroDuplicadoDTO) {
        try {
            this.internalRefactory(bairroDuplicadoDTO, "bairro", (UnicoCrudRepository)this.bairroRepostory, (UnicoCrudService)this.bairroService, e -> e.getBairro().getId(), Endereco::setBairro, () -> this.pessoas.findByPessoaEnderecoBairroIdIn(bairroDuplicadoDTO.getChavesInativa()));
            this.duplicacaoService.updateExecutado(bairroDuplicadoDTO.getDuplicacoesIds());
        }
        catch (Exception e2) {
            this.handlingException(bairroDuplicadoDTO, e2);
        }
    }

    @Generated
    public PessoaEnderecoService(Logradouros logradouroRepository, Bairros bairroRepostory, Pessoas pessoas, PessoaService pessoaService, DuplicacaoService duplicacaoService, CidadeDuplicadaService cidadeDuplicadaService, LogradouroService logradouroService, BairroService bairroService) {
        this.logradouroRepository = logradouroRepository;
        this.bairroRepostory = bairroRepostory;
        this.pessoas = pessoas;
        this.pessoaService = pessoaService;
        this.duplicacaoService = duplicacaoService;
        this.cidadeDuplicadaService = cidadeDuplicadaService;
        this.logradouroService = logradouroService;
        this.bairroService = bairroService;
    }
}

