/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.caelum.stella.tinytype.CNPJ;
import br.com.caelum.stella.tinytype.CPF;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaDisableDuplicate;
import br.com.elotech.di.domain.dto.PessoaDto;
import br.com.elotech.di.repository.PessoaDisableDuplicates;
import br.com.elotech.di.repository.Pessoas;
import br.com.elotech.di.repository.projection.PessoaExistsProjection;
import br.com.elotech.di.service.PessoaService;
import br.com.elotech.di.unificacao.PessoaJoinLogger;
import br.com.elotech.di.unificacao.PessoasDuplicadasService;
import br.com.elotech.di.validation.EloValidatorCnpjCpfPessoa;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PessoaDuplicatesService {
    private static final int TAMANHO_CPF = 11;
    private final Pessoas pessoas;
    private final PessoaService pessoaService;
    private final PessoaDisableDuplicates pessoaDisableDuplicates;
    private final PessoasDuplicadasService pessoasDuplicadasService;
    private final Environment environment;
    private final EntityManager em;

    public void addIdAndNOme(PessoaDto pessoaDto, Pessoa pessoa) {
        pessoaDto.addId(pessoa.getId());
        if (StringUtils.isBlank((String)pessoaDto.getNome())) {
            pessoaDto.setNome(pessoa.getNome());
        }
    }

    public List<PessoaDto> getDuplicatesValidsFilter(List<PessoaDto> pessoasDuplicates) {
        return pessoasDuplicates.stream().filter(p -> EloValidatorCnpjCpfPessoa.getValidator((TipoPessoa)p.getTipoPessoa()).invalidMessagesFor((Object)p.getCnpjCpf()).isEmpty()).collect(Collectors.toList());
    }

    public Page<PessoaDto> findDuplicates(Pageable pageable) {
        Page pageDuplicates = this.pessoas.findDuplicates(pageable);
        return this.internalFindDuplicates(pageable, pageDuplicates);
    }

    public Page<PessoaDto> findDuplicatesCnpjCpf(Pageable pageable, String cnpjCpf) {
        Page pageDuplicates = this.pessoas.findDuplicatesByCnpjCpfLike(pageable, cnpjCpf);
        return this.internalFindDuplicates(pageable, pageDuplicates);
    }

    public Page<PessoaExistsProjection> findExistsCnpjCpf(Pageable pageable, String cnpjCpf) {
        return this.pessoas.findByCnpjCpfLikeAndInativo(pageable, cnpjCpf, Boolean.FALSE);
    }

    private Page<PessoaDto> internalFindDuplicates(Pageable pageable, Page<Object> pageDuplicates) {
        List pessoasDuplicates = PessoaDto.sanitize(pageDuplicates);
        List pessoasDuplicatesValids = this.getDuplicatesValidsFilter(pessoasDuplicates);
        pessoasDuplicatesValids.forEach(pessoaDto -> {
            List listPessoa = this.pessoas.findByTipoPessoaAndCnpjCpf(pessoaDto.getTipoPessoa(), pessoaDto.getCnpjCpf());
            listPessoa.forEach(p -> this.addIdAndNOme(pessoaDto, p));
        });
        return new PageImpl(pessoasDuplicatesValids, pageable, pageDuplicates.getTotalElements());
    }

    @Transactional
    public PessoaDisableDuplicate savePessoaDisableDuplicate(PessoaDisableDuplicate pessoaDisableDuplicate) {
        PessoaDisableDuplicate pessoaDisableDuplicateToSave = new PessoaDisableDuplicate();
        pessoaDisableDuplicateToSave.setPessoaEnable((Pessoa)this.pessoaService.findOne((Serializable)pessoaDisableDuplicate.getPessoaEnable().getId()));
        pessoaDisableDuplicate.getPessoaDisables().forEach(p -> pessoaDisableDuplicateToSave.getPessoaDisables().add((Pessoa)this.pessoaService.findOne((Serializable)p.getId())));
        pessoaDisableDuplicateToSave.getPessoaEnable().setInativo(Boolean.valueOf(false));
        this.pessoaService.saveSkippingValidation(pessoaDisableDuplicateToSave.getPessoaEnable(), null);
        pessoaDisableDuplicateToSave.getPessoaDisables().forEach(p -> this.disableAndAttrModulo(p, pessoaDisableDuplicateToSave.getPessoaEnable()));
        pessoaDisableDuplicateToSave.getPessoaDisables().forEach(p -> this.pessoaService.saveSkippingValidation(p, null));
        pessoaDisableDuplicateToSave.setData(LocalDateTime.now());
        Authentication user = this.pessoaService.getAuthentication();
        if (user != null) {
            pessoaDisableDuplicateToSave.setUserName(user.getName());
        }
        PessoaDisableDuplicate saved = (PessoaDisableDuplicate)this.pessoaDisableDuplicates.save((Object)pessoaDisableDuplicateToSave);
        if (!this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"cloud"}))) {
            this.pessoasDuplicadasService.unificarWithDisableDuplicate(saved);
        }
        return saved;
    }

    public PessoaDisableDuplicate inativarPessoa(Long id) {
        PessoaDisableDuplicate pessoaDisableDuplicateToSave = new PessoaDisableDuplicate();
        Pessoa pessoa = (Pessoa)this.pessoaService.findOne((Serializable)id);
        if (BooleanUtils.isTrue((Boolean)pessoa.getInativo())) {
            return null;
        }
        pessoa.setInativo(Boolean.TRUE);
        pessoaDisableDuplicateToSave.setPessoaEnable(pessoa);
        pessoaDisableDuplicateToSave.getPessoaDisables().add(pessoa);
        this.pessoaService.saveSkippingValidation(pessoaDisableDuplicateToSave.getPessoaEnable(), null);
        pessoaDisableDuplicateToSave.setData(LocalDateTime.now());
        Authentication user = this.pessoaService.getAuthentication();
        if (user != null) {
            pessoaDisableDuplicateToSave.setUserName(user.getName());
        }
        return (PessoaDisableDuplicate)this.pessoaDisableDuplicates.save((Object)pessoaDisableDuplicateToSave);
    }

    private void disableAndAttrModulo(Pessoa pessoaDisable, Pessoa pessoaEnable) {
        pessoaDisable.setInativo(Boolean.valueOf(true));
        if (BooleanUtils.isTrue((Boolean)pessoaDisable.getPessoal())) {
            pessoaEnable.setPessoal(Boolean.valueOf(true));
        }
        if (BooleanUtils.isTrue((Boolean)pessoaDisable.getContribuinte())) {
            pessoaEnable.setContribuinte(Boolean.valueOf(true));
        }
        if (BooleanUtils.isTrue((Boolean)pessoaDisable.getFornecedor())) {
            pessoaEnable.setFornecedor(Boolean.valueOf(true));
        }
        if (BooleanUtils.isTrue((Boolean)pessoaDisable.getProtocolo())) {
            pessoaEnable.setProtocolo(Boolean.valueOf(true));
        }
    }

    public Boolean validaCpfCnpj(String cpfCnpj) {
        if (cpfCnpj.length() <= 11) {
            CPF resultCpf = new CPF(cpfCnpj);
            return resultCpf.isValido();
        }
        CNPJ resultCnpj = new CNPJ(cpfCnpj);
        return resultCnpj.isValid();
    }

    @Transactional
    public void remove(PessoaDisableDuplicate pessoaDisableDuplicate) {
        PessoaDisableDuplicate pessoaDisableDuplicateLoaded = (PessoaDisableDuplicate)this.pessoaDisableDuplicates.findOne((Object)pessoaDisableDuplicate.getId());
        pessoaDisableDuplicateLoaded.getPessoaDisables().forEach(p -> p.setInativo(Boolean.valueOf(false)));
        pessoaDisableDuplicateLoaded.getPessoaDisables().forEach(p -> this.pessoaService.saveSkippingValidation(p, null));
        this.pessoaDisableDuplicates.delete((Object)pessoaDisableDuplicateLoaded);
    }

    @Transactional
    public void revert(Long pessoaDisableDuplicateId) throws IOException {
        PessoaDisableDuplicate pessoaDisableDuplicate = (PessoaDisableDuplicate)this.pessoaDisableDuplicates.findById((Object)pessoaDisableDuplicateId).orElseThrow();
        List idsToUpdate = Stream.concat(pessoaDisableDuplicate.getPessoaDisables().stream().map(Pessoa::getId), Stream.of(pessoaDisableDuplicate.getPessoaEnable().getId())).collect(Collectors.toList());
        PessoaJoinLogger pessoaJoinLogger = this.pessoasDuplicadasService.readJoinXml(pessoaDisableDuplicate.getPessoaEnable().getId());
        pessoaJoinLogger.getPessoaJoin().forEach(p -> this.pessoasDuplicadasService.recreatePessoaJoin(p));
        this.pessoasDuplicadasService.reverseCommands(pessoaJoinLogger.getPessoaRemaing(), pessoaJoinLogger.getCommands());
        this.em.flush();
        this.em.clear();
        List pessoasToUpdate = this.pessoas.findByIdIn(idsToUpdate);
        pessoasToUpdate.forEach(p -> p.setInativo(Boolean.valueOf(false)));
        pessoasToUpdate.forEach(p -> this.pessoaService.saveSkippingValidation(p, null));
        this.pessoaDisableDuplicates.delete((Object)pessoaDisableDuplicate);
    }

    @Generated
    public PessoaDuplicatesService(Pessoas pessoas, PessoaService pessoaService, PessoaDisableDuplicates pessoaDisableDuplicates, PessoasDuplicadasService pessoasDuplicadasService, Environment environment, EntityManager em) {
        this.pessoas = pessoas;
        this.pessoaService = pessoaService;
        this.pessoaDisableDuplicates = pessoaDisableDuplicates;
        this.pessoasDuplicadasService = pessoasDuplicadasService;
        this.environment = environment;
        this.em = em;
    }
}

