/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.config.DBConfigProperties;
import lombok.Generated;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class PermissaoInicialService {
    public static final String USUARIO_SELETOR_SISCOP = "USRXPROG";
    public static final String USUARIO_SELETOR_APICE_PROTOCOLO_AISE = "USUARIOSELETOR";
    public static final String USUARIO_SELETOR_GERAL = "USUARIOSELETORGERAL";
    public static final String SELETOR_SISCOP_COLUMN_NAME = "PROGRAMA";
    public static final String SELETOR_APICE_AISE_COLUMN_NAME = "SELETOR";
    public static final String USUARIOENTIDADE = "USUARIOENTIDADE";
    public static final String USUARIO_ENTIDADE = "USUARIO_ENTIDADE";
    public static final String USRXMOD = "USRXMOD";
    public static final String USUARIOMODULO = "USUARIOMODULO";
    private final JdbcTemplate jdbcTemplate;
    private final DBConfigProperties dbConfigProperties;

    public void adicionarUsuarioEntidadeUnico(Long idUsuario) {
        String platform = this.dbConfigProperties.getUnico().getPlatform();
        String sequenceNextVal = platform.equals("oracle") ? this.dbConfigProperties.getUnico().getSchema().concat(".S_USUARIOENTIDADE.NEXTVAL") : "NEXTVAL('".concat(this.dbConfigProperties.getUnico().getSchema().concat(".S_USUARIOENTIDADE')"));
        String sql = String.format("INSERT INTO %s.USUARIOENTIDADE (ID, USUARIO, ENTIDADE, PRINCIPAL) SELECT %s, %d, e.ID , 'N' FROM %s.ENTIDADE e WHERE NOT EXISTS (SELECT ue.ENTIDADE FROM %s.USUARIOENTIDADE ue WHERE ue.ENTIDADE = e.ID AND ue.usuario = '%s')", this.dbConfigProperties.getUnico().getSchema(), sequenceNextVal, idUsuario, this.dbConfigProperties.getUnico().getSchema(), this.dbConfigProperties.getUnico().getSchema(), idUsuario);
        this.jdbcTemplate.execute(sql);
    }

    public void adicionarUsuarioRecursoUnico(Long idUsuario) {
        String sql = String.format("INSERT INTO %s.USUARIORECURSO (USUARIO, RECURSO) SELECT %d, r.ID FROM %s.RECURSO r WHERE NOT EXISTS (SELECT ur.RECURSO FROM %s.USUARIORECURSO ur WHERE ur.RECURSO = r.ID AND ur.usuario = %d)", this.dbConfigProperties.getUnico().getSchema(), idUsuario, this.dbConfigProperties.getUnico().getSchema(), this.dbConfigProperties.getUnico().getSchema(), idUsuario);
        this.jdbcTemplate.execute(sql);
    }

    public void adicionarUsuarioModuloUnico(Long idUsuario) {
        String platform = this.dbConfigProperties.getUnico().getPlatform();
        String sequenceNextVal = platform.equals("oracle") ? this.dbConfigProperties.getUnico().getSchema().concat(".S_USUARIOMODULO.NEXTVAL") : "NEXTVAL('".concat(this.dbConfigProperties.getUnico().getSchema().concat(".S_USUARIOMODULO')"));
        String sql = String.format("INSERT INTO %s.USUARIOMODULO (ID, USUARIO, MODULO) SELECT %s, %d, r.MODULO FROM %s.MODULO r WHERE NOT EXISTS (SELECT ur.MODULO FROM %s.USUARIOMODULO ur WHERE ur.MODULO = r.MODULO AND ur.usuario = %d)", this.dbConfigProperties.getUnico().getSchema(), sequenceNextVal, idUsuario, this.dbConfigProperties.getUnico().getSchema(), this.dbConfigProperties.getUnico().getSchema(), idUsuario);
        this.jdbcTemplate.execute(sql);
    }

    public void adicionarPermissoesIniciais(String usuario) {
        this.adicionarTodosUsuarioModulo(usuario);
        this.adicionarTodosUsuarioEntidade(usuario);
        this.adicionarTodosSeletores(usuario);
    }

    private void adicionarTodosSeletores(String usuario) {
        this.adicionarUsuarioSeletor(this.dbConfigProperties.getContabilidade().getSchema(), usuario, USUARIO_SELETOR_SISCOP, SELETOR_SISCOP_COLUMN_NAME);
        this.adicionarUsuarioSeletor(this.dbConfigProperties.getCompras().getSchema(), usuario, USUARIO_SELETOR_APICE_PROTOCOLO_AISE, SELETOR_APICE_AISE_COLUMN_NAME);
        this.adicionarUsuarioSeletorProtocolo(this.dbConfigProperties.getProtocolo().getSchema(), usuario);
        this.adicionarUsuarioSeletorAise(this.dbConfigProperties.getAise().getSchema(), usuario);
        this.adicionarUsuarioSeletorCampoAise(this.dbConfigProperties.getAise().getSchema(), usuario);
        this.adicionarUsuarioSeletor(this.dbConfigProperties.getAise().getSchema(), usuario, USUARIO_SELETOR_GERAL, SELETOR_APICE_AISE_COLUMN_NAME);
    }

    private void adicionarTodosUsuarioEntidade(String usuario) {
        this.adicionarUsuarioEntidade(this.dbConfigProperties.getContabilidade().getSchema(), usuario, USUARIO_ENTIDADE);
        this.adicionarUsuarioEntidade(this.dbConfigProperties.getContabilidade().getSchema(), usuario, USUARIOENTIDADE);
        this.adicionarUsuarioEntidade(this.dbConfigProperties.getCompras().getSchema(), usuario, USUARIOENTIDADE);
        this.adicionarUsuarioEntidade(this.dbConfigProperties.getProtocolo().getSchema(), usuario, USUARIO_ENTIDADE);
        this.adicionarUsuarioEntidade(this.dbConfigProperties.getAise().getSchema(), usuario, USUARIOENTIDADE);
    }

    private void adicionarTodosUsuarioModulo(String usuario) {
        this.adicionarUsuarioModulo(this.dbConfigProperties.getContabilidade().getSchema(), usuario, USRXMOD);
        this.adicionarUsuarioModulo(this.dbConfigProperties.getCompras().getSchema(), usuario, USUARIOMODULO);
        this.adicionarUsuarioModulo(this.dbConfigProperties.getProtocolo().getSchema(), usuario, USRXMOD);
        this.adicionarUsuarioModulo(this.dbConfigProperties.getAise().getSchema(), usuario, USUARIOMODULO);
    }

    private void adicionarUsuarioEntidade(String schema, String usuario, String usuarioEntidadeTableName) {
        String sql = String.format("INSERT INTO %s.%s (USUARIO, ENTIDADE, PADRAO) SELECT '%s', e.ENTIDADE , 'S' FROM %s.ENTIDADE e WHERE NOT EXISTS (SELECT ue.ENTIDADE FROM %s.%s ue WHERE ue.ENTIDADE = e.ENTIDADE AND ue.usuario = '%s')", schema, usuarioEntidadeTableName, usuario, schema, schema, usuarioEntidadeTableName, usuario);
        this.jdbcTemplate.execute(sql);
    }

    private void adicionarUsuarioModulo(String schema, String usuario, String usuarioModuloTableName) {
        String sql = String.format("INSERT INTO %s.%s (USUARIO, MODULO) SELECT '%s', m.MODULO FROM %s.MODULO m WHERE NOT EXISTS (SELECT um.MODULO FROM %s.%s um WHERE um.MODULO = m.MODULO AND um.usuario = '%s')", schema, usuarioModuloTableName, usuario, schema, schema, usuarioModuloTableName, usuario);
        this.jdbcTemplate.execute(sql);
    }

    private void adicionarUsuarioSeletor(String schema, String usuario, String usuarioSeletorTableName, String seletorColumnName) {
        String sql = String.format("INSERT INTO %s.%s (USUARIO, MODULO, %s, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) SELECT '%s', s.MODULO , s.%s , 'S', 'S', 'S', 'S' FROM %s.SELETOR s  WHERE NOT EXISTS (SELECT us.%s FROM %s.%s us WHERE us.%s = s.%s AND us.usuario = '%s' AND us.modulo = s.modulo)", schema, usuarioSeletorTableName, seletorColumnName, usuario, seletorColumnName, schema, seletorColumnName, schema, usuarioSeletorTableName, seletorColumnName, seletorColumnName, usuario);
        this.jdbcTemplate.execute(sql);
    }

    private void adicionarUsuarioSeletorCampoAise(String schema, String usuario) {
        String sql = String.format("INSERT INTO %s.USUARIOSELETORCAMPO (USUARIO, MODULO, SELETOR, ENTIDADE, CAMPO) SELECT '%s', sc.MODULO , sc.SELETOR , e.ENTIDADE, sc.CAMPO FROM %s.SELETORCAMPO sc CROSS JOIN %s.ENTIDADE e  WHERE NOT EXISTS (SELECT uc.SELETOR FROM %s.USUARIOSELETORCAMPO uc WHERE uc.SELETOR = sc.SELETOR AND uc.usuario = '%s' AND uc.CAMPO = sc.CAMPO AND uc.entidade = e.ENTIDADE)", schema, usuario, schema, schema, schema, usuario);
        this.jdbcTemplate.execute(sql);
    }

    private void adicionarUsuarioSeletorProtocolo(String schema, String usuario) {
        String sql = String.format("INSERT INTO %s.USUARIOSELETOR (USUARIO, MODULO, SELETOR, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) SELECT '%s', '4' , s.NOMEPROG , 'S', 'S', 'S', 'S' FROM %s.SELETOR  s WHERE NOT EXISTS (SELECT us.SELETOR FROM %s.USUARIOSELETOR us WHERE us.SELETOR = s.NOMEPROG AND us.usuario = '%s')", schema, usuario, schema, schema, usuario);
        this.jdbcTemplate.execute(sql);
    }

    private void adicionarUsuarioSeletorAise(String schema, String usuario) {
        String sql = String.format("INSERT INTO %s.USUARIOSELETOR (ENTIDADE, USUARIO, MODULO, SELETOR, INSERIR, ALTERAR, EXCLUIR, FUNCAOESPECIAL) SELECT e.ENTIDADE, '%s', s.MODULO , s.SELETOR , 'S', 'S', 'S', 'S' FROM %s.SELETOR s CROSS JOIN %s.ENTIDADE e WHERE NOT EXISTS (SELECT us.SELETOR FROM %s.USUARIOSELETOR us WHERE us.SELETOR = s.SELETOR AND us.usuario = '%s')", schema, usuario, schema, schema, schema, usuario);
        this.jdbcTemplate.execute(sql);
    }

    @Generated
    public PermissaoInicialService(JdbcTemplate jdbcTemplate, DBConfigProperties dbConfigProperties) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbConfigProperties = dbConfigProperties;
    }
}

