/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.domain.enums.ParametroEnum;
import br.com.elotech.di.domain.shared.Parametro;
import br.com.elotech.di.dto.ParametroDTO;
import br.com.elotech.di.repository.Parametros;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParametroService {
    private final Parametros parametroRepository;

    public List<ParametroDTO> findAllParametrosConfiguraveis() {
        List<ParametroDTO> parametrosDTO = ParametroEnum.getConfiguraveis().stream().map(ParametroDTO::fromParamEnum).toList();
        List parametros = this.parametroRepository.findAllByIdIn(parametrosDTO.stream().map(ParametroDTO::getId).toList());
        parametros.forEach(parametro -> parametrosDTO.stream().filter(paramDTO -> Objects.equals(paramDTO.getId(), parametro.getId())).forEach(paramDTO -> paramDTO.setValue(parametro.getValue())));
        return parametrosDTO;
    }

    @Transactional
    public List<ParametroDTO> saveAll(@NotNull List<ParametroDTO> parametroDTO) {
        List<Parametro> parametros = parametroDTO.stream().map(Parametro::fromDTO).filter(Objects::nonNull).toList();
        return this.parametroRepository.saveAllAndFlush(parametros).stream().map(Parametro::toDTO).toList();
    }

    public List<ParametroDTO> findAll() {
        return this.parametroRepository.findAll().stream().map(Parametro::toDTO).filter(Objects::nonNull).toList();
    }

    public ParametroDTO findById(Long id) {
        Parametro parametro = this.parametroRepository.findById((Object)id).orElse(new Parametro());
        return parametro.toDTO();
    }

    @Generated
    public ParametroService(Parametros parametroRepository) {
        this.parametroRepository = parametroRepository;
    }
}

