/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.siscop.SiscopUsuario;
import br.com.elotech.di.domain.siscop.SiscopUsuarioModulo;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.repository.Modulos;
import br.com.elotech.di.service.support.UnicoCrudService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ModuloService
extends UnicoCrudService<Modulo, Long> {
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private Modulos modulos;

    @PreAuthorize(value="denyAll")
    public void delete(Modulo entity) {
        super.delete((EloDomain)entity);
    }

    @PreAuthorize(value="denyAll")
    public void delete(Modulo entity, Authentication authentication) {
        super.delete((EloEntity)entity, authentication);
    }

    public LocalDateTime updateSiscopLastLogin(String usuario, String moduloEnum) {
        List siscopUsuarios = this.em.createQuery("from SiscopUsuario where id = :usuario", SiscopUsuario.class).setParameter("usuario", (Object)usuario).getResultList();
        LocalDateTime now = LocalDateTime.now();
        if (!siscopUsuarios.isEmpty()) {
            for (SiscopUsuario siscopUsuario : siscopUsuarios) {
                Optional<SiscopUsuarioModulo> modulo = siscopUsuario.getModulos().stream().filter(m -> ModuloEnum.getByValue((String)m.getPk().getModulo().getId()).equals((Object)ModuloEnum.getByValue((String)moduloEnum))).findFirst();
                if (!modulo.isPresent()) continue;
                modulo.get().setUltimoAcesso(now);
                this.em.merge((Object)modulo.get());
            }
        }
        return now;
    }

    public List<Modulo> findAllByHashStringIsNull() {
        return this.modulos.findAllByHashStringIsNull();
    }
}

