/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.common.dto.MailResultInfo;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.di.config.MailConfigParams;
import br.com.elotech.di.domain.dto.MensagemDTO;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
public class MensagemService {
    public static final long TIMEOUT_ENVIO_EMAIL = 1L;
    private final MailService mailService;
    private final SpringTemplateEngine templateEngine;
    private final Locale locale = Locale.getDefault();
    private final MailConfigParams mailConfigParams;

    public Boolean enviarMensagem(MensagemDTO mensagem, String destinatario) {
        MailParams mailParams = MailParams.builder().from(this.mailConfigParams.getFrom()).to(destinatario).subject(mensagem.getAssunto()).content(this.buildContent(mensagem)).multipart(false).html(true).build();
        MailResultInfo resultadoEnvio = (MailResultInfo)this.mailService.sendEmail(mailParams).get(1L, TimeUnit.MINUTES);
        return resultadoEnvio.isSuccess();
    }

    private String buildContent(MensagemDTO mensagem) {
        Context context = new Context(this.locale);
        context.setVariable("email", (Object)mensagem.getEmail());
        context.setVariable("nome", (Object)mensagem.getNome());
        context.setVariable("mensagem", (Object)mensagem.getMensagem());
        context.setVariable("assunto", (Object)mensagem.getAssunto());
        return this.templateEngine.process("simplesEmail", (IContext)context);
    }

    @Generated
    public MensagemService(MailService mailService, SpringTemplateEngine templateEngine, MailConfigParams mailConfigParams) {
        this.mailService = mailService;
        this.templateEngine = templateEngine;
        this.mailConfigParams = mailConfigParams;
    }
}

