/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.dto.duplicacao.LogradouroSimilaridadeDTO;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.repository.Logradouros;
import br.com.elotech.di.service.support.UnicoCrudService;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LogradouroService
extends UnicoCrudService<Logradouro, Long> {
    public Logradouros getRepository() {
        return (Logradouros)super.getRepository();
    }

    public Page<LogradouroSimilaridadeDTO> findAllWithSimilarity(Pageable pageable, String search, Double similarityDegree, Boolean somenteComVinculo) {
        return this.getRepository().findAllWithSimilarity(pageable, "%".concat(Optional.ofNullable(search).orElse("").concat("%")), similarityDegree, somenteComVinculo.toString());
    }

    public Optional<Logradouro> findFirstByDescricaoIgnoreCaseAndInativoFalseAndCidadeId(String descricao, Long codigoCidade) {
        return this.getRepository().findFirstByDescricaoIgnoreCaseAndInativoFalseAndCidadeId(descricao, codigoCidade);
    }

    protected void beforeSave(Logradouro entity, Authentication authentication) {
        if (Objects.isNull(entity.getInativo())) {
            entity.setInativo(Boolean.FALSE);
        }
        super.beforeSave((EloDomain)entity, authentication);
    }
}

