/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.repository.support.EmStatelessSession;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.domain.LeiAtoArquivo;
import br.com.elotech.di.domain.Modulo;
import br.com.elotech.di.domain.TipoLeiDocumento;
import br.com.elotech.di.domain.shared.TipoArquivo;
import br.com.elotech.di.domain.siscop.SiscopEntidade;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.replicate.support.ReplicatorFacade;
import br.com.elotech.di.repository.LeiAtos;
import br.com.elotech.di.repository.TipoLeiDocumentos;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.di.service.ModuloService;
import br.com.elotech.di.service.TipoArquivoService;
import br.com.elotech.di.service.support.UnicoCrudService;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LeiAtoService
extends UnicoCrudService<LeiAto, Long> {
    @Autowired
    private TipoLeiDocumentos tipoLeiDocumentos;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DBConfigProperties dbConfigProperties;
    @Autowired
    private ReplicatorFacade replicatorFacade;
    @Autowired
    private EmStatelessSession emStatelessSession;
    @Autowired
    private ModuloService moduloService;
    @Autowired
    private TipoArquivoService tipoArquivoService;
    @Autowired
    private LeiAtos repository;
    @Autowired
    private EntidadeService entidadeService;

    public LeiAtos getLeisAtos() {
        return (LeiAtos)super.getCrudRepository();
    }

    protected void beforeSave(LeiAto entity, Authentication authentication) {
        this.attrModuloIfNecessary(entity);
        this.attrDataCadastroIfNecessary(entity);
        this.attrMostraPessoalEqualsAtoPessoal(entity);
        super.beforeSave((EloDomain)entity, authentication);
        entity.markArquivoPrincipalIfNoneExists();
        entity.getArquivos().forEach(arq -> this.fillArquivoData(arq, authentication));
    }

    private void attrModuloIfNecessary(LeiAto entity) {
        if (ContextHolder.hasHeadersValue() && Objects.isNull(entity.getModulo())) {
            entity.setModulo((Modulo)this.moduloService.findOne((Serializable)ContextHolder.getHeaderValueModulo().getLongValue()));
        }
    }

    private void attrDataCadastroIfNecessary(LeiAto entity) {
        if (Objects.isNull(entity.getDataCadastro())) {
            entity.setDataCadastro(LocalDate.now());
        }
    }

    private void attrMostraPessoalEqualsAtoPessoal(LeiAto entity) {
        entity.setMostraPessoal(entity.getAtoPessoal());
    }

    private void fillArquivoData(LeiAtoArquivo leiAtoArquivo, Authentication authentication) {
        Optional.ofNullable(leiAtoArquivo.getArquivo()).ifPresent(arquivo -> {
            if (leiAtoArquivo.getArquivo().isS3File().booleanValue()) {
                TipoArquivo tipoArquivo = this.tipoArquivoService.findByTipo(TipoArquivoEnum.LEI_ATO);
                leiAtoArquivo.getArquivo().safeSetFieldsForS3(tipoArquivo, br.com.elotech.console.dto.Modulo.OXY_UNICO, authentication.getName());
            }
        });
    }

    protected void beforeEdit(LeiAto entity) {
        this.attrModuloIfNecessary(entity);
        super.beforeEdit((EloEntity)entity);
    }

    protected void validateEntity(LeiAto entity, Authentication authentication, List<EloViolation> violations) {
        this.validateLeiAutorizativa(entity, violations);
        this.validateTipoLeiNatureza(entity, violations);
        this.validateDataCadastro(entity, violations);
        this.validatePublicacoes(entity, violations);
        this.validateIdTceDuplicado(entity, violations);
        this.validateEnteConsorciado(entity, violations);
        this.validateTamanhoIdTce(entity, violations);
    }

    public LeiAto initializeTemplate(Authentication authentication) {
        LeiAto leiAto = (LeiAto)super.initializeTemplate(authentication);
        this.entidadeService.getEntidadePrincipal().ifPresent(entidade -> leiAto.setEntidade(entidade));
        leiAto.setDataCadastro(LocalDate.now());
        return leiAto;
    }

    private void validateTipoLeiNatureza(LeiAto entity, List<EloViolation> violations) {
        TipoLeiDocumento tipoLeiDocumento;
        if (entity.getTipoLeiDocumento() != null && !(tipoLeiDocumento = (TipoLeiDocumento)this.tipoLeiDocumentos.findOne((Object)entity.getTipoLeiDocumento().getId())).getEscopos().contains(entity.getTipoLeiEscopo())) {
            violations.add(new EloViolation("Documento inv\u00e1lido em rela\u00e7\u00e3o ao escopo", "Documento:", "tipoLeiDocumento", LeiAto.class));
        }
    }

    private void validateLeiAutorizativa(LeiAto entity, List<EloViolation> violations) {
        LeiAto leiAutorizativa;
        if (entity.getLeiAut() != null && (leiAutorizativa = (LeiAto)this.findOne((Serializable)entity.getLeiAut().getId())).getLeiAut() != null && leiAutorizativa.getLeiAut().equals((Object)entity)) {
            violations.add(new EloViolation("Lei autorizativa inv\u00e1lida", "Lei Autorizativa:", "leiAut", LeiAto.class));
        }
    }

    private void validateDataCadastro(LeiAto entity, List<EloViolation> violations) {
        if (entity.getDataCadastro() != null) {
            if (!entity.isNew()) {
                LeiAto leiAtoLoad = (LeiAto)this.emStatelessSession.getFromDatabase(LeiAto.class, (Serializable)entity.getId());
                if (leiAtoLoad != null && entity.hasChangesOnCloseDate(leiAtoLoad)) {
                    this.isValidDataCadastro(entity, violations);
                }
            } else {
                this.isValidDataCadastro(entity, violations);
            }
        }
    }

    private void validatePublicacoes(LeiAto entity, List<EloViolation> violations) {
        boolean mesmoVeiculo = entity.getPublicacoes().stream().anyMatch(p -> entity.getPublicacoes().stream().filter(op -> op.getVeiculoPublicacao().equals((Object)p.getVeiculoPublicacao())).count() > 1L);
        if (mesmoVeiculo) {
            violations.add(new EloViolation("Existe um Veiculo de publica\u00e7\u00e3o duplicado", "Publica\u00e7\u00f5es:", "publicacoes", LeiAto.class));
        }
    }

    private void validateIdTceDuplicado(LeiAto entity, List<EloViolation> violations) {
        boolean existeLeiAtocomIdTceDuplicado;
        List leiAtos;
        if (entity.getIdTce() != null && entity.getIdTce() > 0L && !(leiAtos = this.repository.findByEntidadeAndIdTce(entity.getEntidade(), entity.getIdTce())).isEmpty() && (existeLeiAtocomIdTceDuplicado = leiAtos.stream().anyMatch(l -> !l.getId().equals(entity.getId())))) {
            violations.add(new EloViolation(String.format("J\u00e1 existe o cadastro de Lei Ato com o c\u00f3digo TCE [%s].", entity.getIdTce()), "IdTce:", "idTce", LeiAto.class));
        }
    }

    private void validateEnteConsorciado(LeiAto entity, List<EloViolation> violations) {
        if (entity.getVincularEnteConsorciado().booleanValue() && Objects.isNull(entity.getEnteConsorciado())) {
            violations.add(new EloViolation("\u00c9 necess\u00e1rio informar um Ente Consorciado como Entidade Origem.", "Entidade Origem:", "enteConsorciado", LeiAto.class));
        }
    }

    private void validateTamanhoIdTce(LeiAto entity, List<EloViolation> violations) {
        if (!entity.getAtoPessoal().booleanValue() && Objects.nonNull(entity.getIdTce()) && entity.getIdTce().toString().length() > 7) {
            violations.add(new EloViolation("Campo limitado a 7 d\u00edgitos quando 'Ato de Pessoal' n\u00e3o estiver marcado.", "C\u00f3digo TCE:", "idTce", LeiAto.class));
        }
    }

    private void isValidDataCadastro(LeiAto entity, List<EloViolation> violations) {
        if (this.isMonthClosedInContabil(entity.getDataCadastro(), entity.getEntidade())) {
            violations.add(new EloViolation("Alterada para um m\u00eas e ano fechado na contabilidade, verifique!", "Data para Envio TCE:", "dataGeracaoTC", LeiAto.class));
        }
    }

    private boolean isMonthClosedInContabil(LocalDate dataCadastro, Entidade entidade) {
        if (this.getUnicoProperties().getCloud().booleanValue()) {
            return false;
        }
        SiscopEntidade entidadeSiscop = this.replicatorFacade.getSiscopEntidade(entidade);
        Month mes = dataCadastro.getMonth();
        int ano = dataCadastro.getYear();
        String sql = "select count(*) from " + this.dbConfigProperties.getContabilidade().getSchema() + ".exercicio_mes where entidade = ? and exercicio = ? and mes = ? and situacao = ?";
        int count = (Integer)this.jdbcTemplate.queryForObject(sql, new Object[]{entidadeSiscop.getId(), ano, mes.getValue(), "F"}, Integer.class);
        return count > 0;
    }

    public void internalReplicate(LeiAto saved) {
        this.reloadCodigoTipos(saved);
        super.internalReplicate((EloDomain)saved);
    }

    private void reloadCodigoTipos(LeiAto saved) {
        if (this.nonNullTipoLeiDocumento(saved) || this.nonNullTipoLeiEscopo(saved) || this.nonNullTipoLeiNatureza(saved)) {
            this.getEm().refresh((Object)saved);
        }
    }

    private boolean nonNullTipoLeiDocumento(LeiAto saved) {
        return Objects.nonNull(saved.getTipoLeiDocumento()) && Objects.isNull(saved.getTipoLeiDocumento().getCodigo());
    }

    private boolean nonNullTipoLeiEscopo(LeiAto saved) {
        return Objects.nonNull(saved.getTipoLeiEscopo()) && Objects.isNull(saved.getTipoLeiEscopo().getCodigo());
    }

    private boolean nonNullTipoLeiNatureza(LeiAto saved) {
        return Objects.nonNull(saved.getTipoLeiNatureza()) && Objects.isNull(saved.getTipoLeiNatureza().getCodigo());
    }
}

