/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.exception.InvalidCredentialsException;
import br.com.elotech.unico.client.dto.LoginDTO;
import java.io.IOException;
import java.io.InputStream;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class KeycloakAuthService {
    public static final String KEYCLOAK_LDAP_JSON = "keycloak-ldap.json";
    private final KeycloakDeployment keycloakDeployment;
    private final RestTemplate restTemplate;

    public KeycloakAuthService(RestTemplate restTemplate) throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(KEYCLOAK_LDAP_JSON);
        this.keycloakDeployment = KeycloakDeploymentBuilder.build((InputStream)classPathResource.getInputStream());
        this.restTemplate = restTemplate;
    }

    private MultiValueMap<String, String> buildLoginRequestBody(LoginDTO dto) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"username", (Object)dto.getUsername());
        body.add((Object)"password", (Object)dto.getPassword());
        body.add((Object)"grant_type", (Object)"password");
        body.add((Object)"client_id", (Object)this.keycloakDeployment.getResourceName());
        body.add((Object)"client_secret", (Object)this.keycloakDeployment.getResourceCredentials().get("secret").toString());
        return body;
    }

    public AccessTokenResponse auth(LoginDTO dto) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap body = this.buildLoginRequestBody(dto);
        HttpEntity loginRequest = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            ResponseEntity loginResponse = this.restTemplate.postForEntity(this.keycloakDeployment.getTokenUrl(), (Object)loginRequest, AccessTokenResponse.class, new Object[0]);
            return (AccessTokenResponse)loginResponse.getBody();
        }
        catch (HttpClientErrorException ex) {
            if (ex.getResponseBodyAsString().contains("Invalid user credentials")) {
                throw new InvalidCredentialsException("Credenciais inv\u00e1lidas", (Throwable)ex);
            }
            throw new InvalidCredentialsException(ex.getResponseBodyAsString(), (Throwable)ex);
        }
    }
}

