/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.console.client.ConsoleClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.utils.Cipher;
import br.com.elotech.di.domain.HashArquivosCloudConfig;
import br.com.elotech.di.domain.enums.ParametroEnum;
import br.com.elotech.di.domain.shared.Parametro;
import br.com.elotech.di.repository.Parametros;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.multitenant.domain.Tenant;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.ws.rs.NotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HashArquivosCloudConfigService {
    private static final String CONSOLE_KEY = "ARQUIVOS_CLOUD";
    private static final Logger LOGGER = LoggerFactory.getLogger(HashArquivosCloudConfigService.class);
    private EntidadeService entidadeService;
    @Autowired
    private ConsoleClient consoleClient;
    private Parametros parametros;
    private ObjectMapper mapper;

    public HashArquivosCloudConfig updateConfigsFromConsole(HashArquivosCloudConfig oldConfig, Boolean throwExceptionIfFail) {
        HashArquivosCloudConfig config = oldConfig != null ? oldConfig : this.getCurrentConfig();
        try {
            config.setAtivado(Boolean.valueOf(Optional.of((String)((Tenant)this.consoleClient.getTenantConfig(this.entidadeService.getTenantId(), Modulo.OXY_UNICO).orElseThrow()).getAttributes().get(CONSOLE_KEY)).orElse("").toUpperCase().startsWith("S")));
            config.setUltimaVerificacao(LocalDateTime.now());
            this.save(config);
        }
        catch (Exception ex) {
            if (Boolean.TRUE.equals(throwExceptionIfFail)) {
                throw new NotFoundException("N\u00e3o foi poss\u00edvel buscar as configura\u00e7\u00f5es do Cloud. Por favor, verifique!", (Throwable)ex);
            }
            LOGGER.warn("Falha ao buscar informa\u00e7\u00f5es referentes aos Arquivos Cloud do Console.", (Throwable)ex);
        }
        return config;
    }

    public void save(HashArquivosCloudConfig hashArquivosCloudConfig) {
        Parametro param = new Parametro();
        param.setId(ParametroEnum.HASH_ARQUIVOS_CLOUD.getId());
        param.setDescricao("Arquivos Cloud Hash");
        LOGGER.info("Salvando configura\u00e7\u00f5es Cloud no Banco de Dados");
        param.setValue(Cipher.encrypt((String)this.mapper.writeValueAsString((Object)hashArquivosCloudConfig), (String)CONSOLE_KEY));
        this.parametros.saveAndFlush((Object)param);
    }

    private Optional<HashArquivosCloudConfig> load() {
        Parametro param = this.parametros.findById((Object)ParametroEnum.HASH_ARQUIVOS_CLOUD.getId()).orElse(null);
        if (param == null) {
            LOGGER.warn("Nenhuma configura\u00e7\u00e3o Arquivo Cloud Hash encontrada.");
            return Optional.empty();
        }
        try {
            HashArquivosCloudConfig config = (HashArquivosCloudConfig)this.mapper.readValue(Cipher.encrypt((String)param.getValue(), (String)CONSOLE_KEY), HashArquivosCloudConfig.class);
            if (this.entidadeService.getTenantId().equals(config.getTenant())) {
                return Optional.of(config);
            }
            LOGGER.warn("A configura\u00e7\u00e3o Arquivo Cloud Hash presente pertence a outro Tenant e ser\u00e1 desconsiderada.");
            return Optional.empty();
        }
        catch (JsonProcessingException ex) {
            LOGGER.warn("Falha ao ler configura\u00e7\u00e3o Arquivo Cloud Hash. Provavelmente foi modificado manualmente.");
            return Optional.empty();
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Par\u00e2metro da configura\u00e7\u00e3o de Arquivos Cloud Hash estava nula.");
            return Optional.empty();
        }
    }

    public HashArquivosCloudConfig getCurrentConfig() {
        return this.load().orElse(new HashArquivosCloudConfig().withAtivado(Boolean.valueOf(false)).withTenant(this.entidadeService.getTenantId()).withUltimaVerificacao(LocalDate.EPOCH.atStartOfDay()));
    }

    public HashArquivosCloudConfig getActualConfig() {
        HashArquivosCloudConfig config = this.getCurrentConfig();
        if (config.getUltimaVerificacao().isBefore(LocalDateTime.now().minusDays(10L))) {
            LOGGER.warn("A \u00faltima verifica\u00e7\u00e3o das configura\u00e7\u00f5es do Cloud aconteceu h\u00e1 mais de 10 dias, ou nunca aconteceu. \u00c9 PRECISO verificar novamente. ");
            config = this.updateConfigsFromConsole(config, config.getAtivado());
        } else if (config.getUltimaVerificacao().isBefore(LocalDateTime.now().minusDays(1L))) {
            LOGGER.info("A \u00faltima verifica\u00e7\u00e3o das configura\u00e7\u00f5es do Cloud aconteceu h\u00e1 mais de 24 horas. \u00c9 preciso verificar novamente.");
            config = this.updateConfigsFromConsole(config, Boolean.FALSE);
        }
        return config;
    }

    @Generated
    public HashArquivosCloudConfigService(EntidadeService entidadeService, ConsoleClient consoleClient, Parametros parametros, ObjectMapper mapper) {
        this.entidadeService = entidadeService;
        this.consoleClient = consoleClient;
        this.parametros = parametros;
        this.mapper = mapper;
    }
}

