/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.di.domain.Report;
import br.com.elotech.di.domain.ReportArquivo;
import br.com.elotech.di.exception.DownloadException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.springframework.stereotype.Service;

@Service
public class FileIntegrationService {
    private final ArquivoClient arquivoClient;

    public List<File> downloadReport(Report report) throws IOException {
        Tenant tenant = Tenant.create((String)TenantContextHolder.getCurrentTenantId());
        String dir = Files.createTempDirectory("report", new FileAttribute[0]).toFile().getAbsolutePath();
        return report.getArquivos().stream().sorted(Comparator.comparing(ReportArquivo::getPrincipal).reversed()).map(ReportArquivo::getArquivo).map(arquivo -> {
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)tenant, (String)arquivo.getFullPath());
            ArquivoUrl arquivoUrl = this.arquivoClient.gerarUrlParaGet(arquivoDownloadRequest);
            return this.downloadFile(dir, arquivo.getNome(), arquivoUrl);
        }).collect(Collectors.toList());
    }

    public File downloadFile(String dir, String nome, ArquivoUrl arquivoUrl) {
        try {
            File file = this.createFile(dir, nome);
            FileUtils.copyURLToFile((URL)new URL(arquivoUrl.getUrlAssinada()), (File)file);
            return file;
        }
        catch (IOException e) {
            throw new DownloadException("Falha ao baixar arquivo", (Exception)e);
        }
    }

    public File createFile(String dir, String nome) {
        String filePath = String.join((CharSequence)File.separator, dir, TenantContextHolder.getCurrentTenantId(), nome);
        return new File(filePath);
    }

    public File createFile(String nome) {
        String dir = String.valueOf(System.currentTimeMillis());
        return this.createFile(dir, nome);
    }

    public Arquivo saveFile(ArquivoNovoRequest request) {
        return this.arquivoClient.criarArquivo(request);
    }

    @Generated
    public FileIntegrationService(ArquivoClient arquivoClient) {
        this.arquivoClient = arquivoClient;
    }
}

