/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Feriado;
import br.com.elotech.di.domain.FeriadoDTO;
import br.com.elotech.di.repository.FeriadoRepository;
import br.com.elotech.unico.client.domain.enums.TipoFeriado;
import br.com.elotech.unico.client.dto.CidadeDTO;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class FeriadoService
extends CrudService<Feriado, Long> {
    public FeriadoRepository getRepository() {
        return (FeriadoRepository)super.getRepository();
    }

    public Feriado save(Feriado entity, Authentication authentication) {
        if (TipoFeriado.FIXO.equals((Object)entity.getTipoFeriado())) {
            LocalDate dataFormatada = LocalDate.of(1900, entity.getDataFeriado().getMonth(), entity.getDataFeriado().getDayOfMonth());
            entity.setDataFeriado(dataFormatada);
        }
        return (Feriado)super.save((EloEntity)entity, authentication);
    }

    public Page<FeriadoDTO> findAll(String search, Pageable pageable) {
        Page pageFeriado = this.getPageFeriados(search, pageable);
        Long count = super.count(search);
        List feriados = pageFeriado.getContent();
        List<FeriadoDTO> feriadosDTO = feriados.stream().map(arg_0 -> this.convertToFeriadoDTO(arg_0)).collect(Collectors.toList());
        for (Feriado feriado : feriados) {
            if (!TipoFeriado.FIXO.equals((Object)feriado.getTipoFeriado())) continue;
            feriadosDTO.forEach(dto -> {
                if (Objects.isNull(dto.getCidade()) && dto.getId().equals(feriado.getId())) {
                    dto.setCidade(this.getCidadeDTOGeral());
                }
            });
        }
        return new PageImpl(feriadosDTO, pageFeriado.getPageable(), count.longValue());
    }

    private Page<Feriado> getPageFeriados(String search, Pageable pageable) {
        Page pageFeriado;
        if (pageable.getSort().isSorted() && pageable.getSort().get().anyMatch(o -> o.getProperty().equals("dataFeriado"))) {
            Sort anoMes = Sort.by((String[])new String[]{"mesCalculado", "diaCalculado"});
            Sort.Order dataFeriado = pageable.getSort().getOrderFor("dataFeriado");
            anoMes = dataFeriado.isAscending() ? anoMes.ascending() : anoMes.descending();
            PageRequest pageRequest = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)anoMes);
            pageFeriado = this.findByRsql(search, (Pageable)pageRequest);
        } else {
            pageFeriado = this.findByRsql(search, pageable);
        }
        return pageFeriado;
    }

    public Boolean validarDataFeriado(LocalDate dataFeriado, Optional<Long> cidade) {
        return cidade.map(cidadeId -> this.getRepository().existsFeriadoByDataFeriadoAndCidadeId(dataFeriado, cidadeId) != false || this.getRepository().existsFeriadoByDataFeriadoAndCidadeIdAndTipoFixo(dataFeriado.getMonthValue(), dataFeriado.getDayOfMonth(), cidadeId) != false).orElseGet(() -> this.getRepository().existsFeriadoByDataFeriadoAndCidadeIdIsNull(dataFeriado) != false || this.getRepository().existsFeriadoSistemaByData(dataFeriado.getMonthValue(), dataFeriado.getDayOfMonth()) != false);
    }

    public FeriadoDTO convertToFeriadoDTO(Feriado feriado) {
        FeriadoDTO feriadoDTO = new FeriadoDTO();
        feriadoDTO.setId(feriado.getId());
        feriadoDTO.setAno(feriado.getAno());
        feriadoDTO.setDataFeriado(feriado.getDataFeriado());
        feriadoDTO.setDescricao(feriado.getDescricao());
        feriadoDTO.setPeriodo(feriado.getPeriodo());
        feriadoDTO.setTipoFeriado(feriado.getTipoFeriado());
        feriadoDTO.setCidade((CidadeDTO)Optional.ofNullable(feriado.getCidade()).map(Cidade::convertToEvent).orElse(null));
        return feriadoDTO;
    }

    public CidadeDTO getCidadeDTOGeral() {
        CidadeDTO cidadeDTO = new CidadeDTO();
        cidadeDTO.setDescricao("Geral");
        return cidadeDTO;
    }
}

