/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaBaseDTO;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaCarimboDTO;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaCertificadoA1DTO;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaTextoDTO;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.Envelope;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SituacaoEnvelopeAssinatura;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SituacaoSolicitacaoAssinatura;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinatura;
import br.com.elotech.di.service.ArquivoAssinaturaA1Service;
import br.com.elotech.di.service.ArquivoAssinaturaCarimboService;
import br.com.elotech.di.service.SolicitacaoAssinaturaService;
import br.com.elotech.di.service.UsuarioLogadoService;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EnvelopeService
extends CrudService<Envelope, Long> {
    private UsuarioLogadoService usuarioLogadoService;
    private ArquivoAssinaturaCarimboService arquivoAssinaturaCarimboService;
    private ArquivoAssinaturaA1Service arquivoAssinaturaA1Service;
    private SolicitacaoAssinaturaService solicitacaoAssinaturaService;

    public Optional<String> defaultSearchFilter() {
        String cpf = this.usuarioLogadoService.getUsuarioLogado().getCpf();
        return Optional.of("destinatario.cnpjCpf==" + cpf);
    }

    public Envelope findOne(Long id) {
        Envelope envelope = (Envelope)this.getCrudRepository().getOne((Object)id);
        this.validateUsuarioLogado(envelope);
        return envelope;
    }

    public void assinar(AssinaturaCarimboDTO dto) {
        this.createSolicitacao((AssinaturaBaseDTO)dto);
        Envelope envelope = (Envelope)this.getCrudRepository().getOne((Object)dto.getIdEnvelope());
        this.validateFields(envelope, dto.getIdArquivo());
        this.arquivoAssinaturaCarimboService.assinarComCarimbo(dto);
    }

    public void assinar(AssinaturaTextoDTO dto) {
        this.createSolicitacao((AssinaturaBaseDTO)dto);
        Envelope envelope = (Envelope)this.getCrudRepository().getOne((Object)dto.getIdEnvelope());
        this.validateFields(envelope, dto.getIdArquivo());
        this.arquivoAssinaturaCarimboService.assinarComTexto(dto);
    }

    public void assinar(AssinaturaCertificadoA1DTO dto) throws IOException {
        this.createSolicitacao((AssinaturaBaseDTO)dto);
        Envelope envelope = (Envelope)this.getCrudRepository().getOne((Object)dto.getIdEnvelope());
        this.validateFields(envelope, dto.getIdArquivo());
        this.arquivoAssinaturaA1Service.assinar(dto);
    }

    protected void validateSolicitacao(SolicitacaoAssinatura solicitacaoAssinatura) {
        if (!solicitacaoAssinatura.isPendente()) {
            throw new IllegalArgumentException("S\u00f3 \u00e9 poss\u00edvel assinar arquivos em solicita\u00e7\u00f5es pendentes.");
        }
    }

    protected void validateEnvelope(Envelope envelope) {
        if (!envelope.isPendente()) {
            throw new IllegalArgumentException("S\u00f3 \u00e9 poss\u00edvel assinar Envelopes que est\u00e3o pendentes.");
        }
    }

    protected void validateArquivo(Arquivo arquivo, Long idArquivo) {
        if (!idArquivo.equals(arquivo.getId())) {
            throw new IllegalArgumentException("O arquivo n\u00e3o \u00e9 o mesmo do envelope.");
        }
    }

    protected void validateUsuarioLogado(Envelope envelope) {
        String cpf = this.usuarioLogadoService.getUsuarioLogado().getCpf();
        if (!envelope.getDestinatario().getCnpjCpf().equals(cpf)) {
            throw new IllegalArgumentException("O usu\u00e1rio logado n\u00e3o \u00e9 o mesmo do envelope.");
        }
    }

    protected void updateSolicitacao(SolicitacaoAssinatura solicitacaoAssinatura) {
        boolean algumEnvelopePendente = solicitacaoAssinatura.getEnvelopes().stream().anyMatch(e -> e.getSituacao().equals((Object)SituacaoEnvelopeAssinatura.PENDENTE));
        if (algumEnvelopePendente) {
            solicitacaoAssinatura.setSituacao(SituacaoSolicitacaoAssinatura.EM_ANDAMENTO);
        } else {
            solicitacaoAssinatura.setSituacao(SituacaoSolicitacaoAssinatura.ENCERRADA);
        }
    }

    protected void updateEnvelope(Envelope envelope) {
        envelope.setDataAssinatura(LocalDate.now());
        if (Objects.isNull(envelope.getDataAbertura())) {
            envelope.setDataAbertura(LocalDate.now());
        }
        envelope.setSituacao(SituacaoEnvelopeAssinatura.APROVADO);
    }

    private void createSolicitacao(AssinaturaBaseDTO dto) {
        if (Objects.isNull(dto.getIdEnvelope())) {
            SolicitacaoAssinatura solicitacaoAssinatura = this.solicitacaoAssinaturaService.createOnDemandForCurrentUser(dto);
            dto.setIdEnvelope(((Envelope)solicitacaoAssinatura.getEnvelopes().get(0)).getId());
        }
    }

    private void validateFields(Envelope envelope, Long idArquivo) {
        this.validateUsuarioLogado(envelope);
        this.validateSolicitacao(envelope.getSolicitacaoAssinatura());
        this.validateEnvelope(envelope);
        this.validateArquivo(envelope.getArquivo(), idArquivo);
        this.updateEnvelope(envelope);
        this.updateSolicitacao(envelope.getSolicitacaoAssinatura());
    }

    @Generated
    public EnvelopeService(UsuarioLogadoService usuarioLogadoService, ArquivoAssinaturaCarimboService arquivoAssinaturaCarimboService, ArquivoAssinaturaA1Service arquivoAssinaturaA1Service, SolicitacaoAssinaturaService solicitacaoAssinaturaService) {
        this.usuarioLogadoService = usuarioLogadoService;
        this.arquivoAssinaturaCarimboService = arquivoAssinaturaCarimboService;
        this.arquivoAssinaturaA1Service = arquivoAssinaturaA1Service;
        this.solicitacaoAssinaturaService = solicitacaoAssinaturaService;
    }
}

